/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.instance;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AppclientModule;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ServerXPathHelper;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.instance.ExceptionType;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.Localizer;
import com.sun.enterprise.instance.ModuleEnvironment;
import com.sun.enterprise.instance.ModulesManager;
import com.sun.enterprise.instance.SerializedDescriptorHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.enterprise.deploy.shared.ModuleType;

public class AppclientModulesManager
extends ModulesManager {
    public AppclientModulesManager(InstanceEnvironment env) throws ConfigException {
        super(env, true);
    }

    public AppclientModulesManager(InstanceEnvironment env, boolean useBackupServerXml) throws ConfigException {
        super(env, useBackupServerXml);
        AppclientModule[] jArray = ((Applications)this.configBean).getAppclientModule();
        if (jArray != null) {
            for (int i = 0; i < jArray.length; ++i) {
                jArray[i].setConfigContext(this.configContext);
                jArray[i].setXPath(ServerXPathHelper.getAppClientModuleIdXpathExpression(jArray[i].getName()));
            }
        }
    }

    public ModuleType getModuleType() {
        return ModuleType.CAR;
    }

    public AppclientModule[] getAllApps() {
        AppclientModule[] apps = ((Applications)this.configBean).getAppclientModule();
        if (apps == null) {
            return new AppclientModule[0];
        }
        ArrayList<AppclientModule> list = new ArrayList<AppclientModule>();
        for (int i = 0; i < apps.length; ++i) {
            if (!this.isReferenced(apps[i].getName())) continue;
            list.add(apps[i]);
        }
        AppclientModule[] refList = new AppclientModule[list.size()];
        return list.toArray(refList);
    }

    public List listIds() {
        ArrayList<String> arr = new ArrayList<String>();
        AppclientModule[] apps = ((Applications)this.configBean).getAppclientModule();
        if (apps == null) {
            return arr;
        }
        for (int i = 0; i < apps.length; ++i) {
            String name = apps[i].getName();
            if (!this.isReferenced(name)) continue;
            arr.add(name);
        }
        return arr;
    }

    public String getLocation(String appId) throws ConfigException {
        AppclientModule app = ((Applications)this.configBean).getAppclientModuleByName(appId);
        return this.resolvePath(app.getLocation());
    }

    public boolean isEnabled(String appId) throws ConfigException {
        return true;
    }

    public boolean isJavaWebStartEnabled(String appId) throws ConfigException {
        AppclientModule app = ((Applications)this.configBean).getAppclientModuleByName(appId);
        return app.isJavaWebStartEnabled();
    }

    public boolean isSystem(String appId) throws ConfigException {
        return false;
    }

    public boolean isSystemAdmin(String appId) throws ConfigException {
        return false;
    }

    public boolean isSystemPredeployed(String appId) throws ConfigException {
        return false;
    }

    public String getStubLocation(String name) {
        ModuleEnvironment menv = this.instanceEnvironment.getModuleEnvironment(name, DeployableObjectType.CAR);
        return menv.getModuleStubPath();
    }

    public String getGeneratedXMLLocation(String name) {
        ModuleEnvironment menv = this.instanceEnvironment.getModuleEnvironment(name, DeployableObjectType.CAR);
        return menv.getModuleGeneratedXMLPath();
    }

    protected boolean isRegistered(String appId, ConfigBean bean) {
        AppclientModule cb = null;
        try {
            cb = ((Applications)bean).getAppclientModuleByName(appId);
        }
        catch (Exception cn) {
            // empty catch block
        }
        return cb != null;
    }

    public void remove(String appId) throws ConfigException {
        AppclientModule backJa = ((Applications)this.configBean).getAppclientModuleByName(appId);
        ((Applications)this.configBean).removeAppclientModule(backJa);
    }

    public void setEnable(String appId, boolean enabled) throws ConfigException {
    }

    public void setLocation(String appId, String location) throws ConfigException {
        this.getAppclientModule(appId).setLocation(location);
    }

    public void setOptionalAttributes(String appId, Properties optionalAttributes) throws ConfigException {
    }

    public String getDescription(String id) throws ConfigException {
        return this.getAppclientModule(id).getDescription();
    }

    private AppclientModule getAppclientModule(String appId) throws ConfigException {
        AppclientModule app = ((Applications)this.configBean).getAppclientModuleByName(appId);
        if (app == null) {
            throw new ConfigException(Localizer.getValue(ExceptionType.APP_NOT_EXIST));
        }
        return app;
    }

    public void setDescription(String id, String desc) throws ConfigException {
        this.getAppclientModule(id).setDescription(desc);
    }

    public Application getDescriptor(String modId, ClassLoader cl, String modDir, boolean validateXml) throws ConfigException {
        Application application = this.getRegisteredDescriptor(modId);
        if (application != null) {
            application.setClassLoader(cl);
            return application;
        }
        try {
            AppClientArchivist appClientArchivist = new AppClientArchivist();
            appClientArchivist.setXMLValidation(validateXml);
            appClientArchivist.setClassLoader(cl);
            FileArchive archive = this.openDDArchive(modId, modDir);
            SerializedDescriptorHelper.Loader sdLoader = SerializedDescriptorHelper.load(modId, this);
            Application deserializedApplication = sdLoader.getApplication();
            application = deserializedApplication != null ? deserializedApplication : ApplicationArchivist.openArchive(modId, appClientArchivist, archive, true);
            application.setClassLoader(cl);
            application.setGeneratedXMLDirectory(this.getGeneratedXMLLocation(modId));
            this.registerDescriptor(modId, application);
            sdLoader.store(application);
            return application;
        }
        catch (IOException ioe) {
            throw new ConfigException(Localizer.getValue(ExceptionType.IO_ERROR_LOADING_DD, modId), ioe);
        }
        catch (Throwable t) {
            throw new ConfigException(Localizer.getValue(ExceptionType.FAIL_DD_LOAD, modId), t);
        }
    }
}

