/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.jbi.AppServerContext;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.logging.LogDomains;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class AppServerContextImpl
implements AppServerContext {
    private static String SERVER = "server";
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system");
    private Method irMethod = null;
    private final String INSTANCE_REGISTRY = "com.sun.enterprise.ee.admin.clientreg.InstanceRegistry";

    public AppServerContextImpl() {
        try {
            this.irMethod = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Class<?> cls = Class.forName("com.sun.enterprise.ee.admin.clientreg.InstanceRegistry");
                    return cls.getMethod("getInstanceConnection", String.class);
                }
            });
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public boolean isDAS() {
        AdminService adminSvc = AdminService.getAdminService();
        boolean isDAS = false;
        if (adminSvc != null) {
            isDAS = adminSvc.isDas();
        }
        return isDAS;
    }

    public String getTargetName() throws Exception {
        String instanceName = this.getInstanceName();
        return this.getTargetName(instanceName);
    }

    public String getInstanceName() {
        return System.getProperty("com.sun.aas.instanceName");
    }

    public MBeanServerConnection getMBeanServerConnection(final String instanceName) throws Exception {
        if (this.getInstanceName().equals(instanceName)) {
            return this.getPlatformMBeanServer();
        }
        if (this.isDAS() && !this.multipleServersSupported()) {
            throw new Exception("Developer profile does not support multiple server instances");
        }
        return (MBeanServerConnection)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return AppServerContextImpl.this.irMethod.invoke(null, instanceName);
            }
        });
    }

    public boolean isInstanceUp(String instanceName) {
        boolean isRunning = false;
        if (this.isDAS()) {
            if (SERVER.equals(instanceName)) {
                isRunning = true;
            } else {
                String instanceObjName = "amx:J2EEServer=" + instanceName + ",j2eeType=JVM,*";
                ObjectName objName = null;
                try {
                    objName = new ObjectName(instanceObjName);
                }
                catch (MalformedObjectNameException mex) {
                    _logger.log(Level.SEVERE, mex.getMessage(), mex);
                    return false;
                }
                Set<ObjectName> nameSet = this.getPlatformMBeanServer().queryNames(objName, null);
                if (!nameSet.isEmpty()) {
                    isRunning = true;
                }
            }
        }
        return isRunning;
    }

    public boolean multipleServersSupported() {
        if (this.isDAS()) {
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            DomainRoot domainRoot = ProxyFactory.getInstance(mbeanServer).getDomainRoot();
            return domainRoot.getSystemInfo().supportsFeature("SupportsMultipleServers");
        }
        return false;
    }

    public String[] getStandaloneServerNames() {
        try {
            Server[] servers = ServerHelper.getUnclusteredServers(this.getConfigContext(), false);
            return this.getServerNames(servers);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, ex.getMessage(), ex);
            return new String[0];
        }
    }

    public String[] getClusterNames() {
        try {
            Cluster[] clusters = ClusterHelper.getClustersInDomain(this.getConfigContext());
            return this.getClusterNames(clusters);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, ex.getMessage(), ex);
            return new String[0];
        }
    }

    public String[] getServersInCluster(String clusterName) {
        try {
            Server[] servers = ServerHelper.getServersInCluster(this.getConfigContext(), clusterName);
            return this.getServerNames(servers);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, ex.getMessage(), ex);
            return new String[0];
        }
    }

    public String getTargetName(String instanceName) throws Exception {
        String targetName = instanceName;
        if (this.isInstanceClustered(instanceName)) {
            targetName = this.getClusterForInstance(instanceName);
        }
        return targetName;
    }

    public boolean isInstanceClustered(String instanceName) throws Exception {
        boolean isClustered = false;
        ConfigContext ctx = this.getConfigContext();
        if (ctx != null) {
            isClustered = ServerHelper.isServerClustered(ctx, instanceName);
        }
        return isClustered;
    }

    private String getClusterForInstance(String instanceName) throws Exception {
        String clusterName = null;
        if (this.isInstanceClustered(instanceName)) {
            Cluster cluster = ClusterHelper.getClusterForInstance(this.getConfigContext(), instanceName);
            clusterName = cluster.getName();
        }
        return clusterName;
    }

    private ConfigContext getConfigContext() {
        ConfigContext ctx = null;
        if (this.isDAS()) {
            if (AdminService.getAdminService() != null) {
                ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            }
        } else if (ApplicationServer.getServerContext() != null) {
            ctx = ApplicationServer.getServerContext().getConfigContext();
        }
        return ctx;
    }

    private MBeanServer getPlatformMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    private String[] getServerNames(Server[] servers) {
        String[] ucServers = new String[servers.length];
        for (int i = 0; i < servers.length; ++i) {
            ucServers[i] = servers[i].getName();
        }
        return ucServers;
    }

    private String[] getClusterNames(Cluster[] clusters) {
        String[] domClusters = new String[clusters.length];
        for (int i = 0; i < clusters.length; ++i) {
            domClusters[i] = clusters[i].getName();
        }
        return domClusters;
    }
}

