/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.install;

import com.sun.enterprise.jbi.serviceengine.ServiceEngineException;
import com.sun.enterprise.jbi.serviceengine.install.Installer;
import com.sun.enterprise.jbi.serviceengine.install.MBeanHelper;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;

public class InstallerImpl
implements Installer {
    private static final String ADD_COMPONENT_OPERATION = "addComponent";
    private static final String INSTALL_COMPONENT_OPERATION = "installComponent";
    private static final String REMOVE_COMPONENT_OPERATION = "removeComponent";
    private static final String UNINSTALL_COMPONENT_OPERATION = "uninstallComponent";
    private static final String START_COMPONENT_OPERATION = "startComponent";
    private static final String STOP_COMPONENT_OPERATION = "stopComponent";
    private static final String IS_ENGINE_OPERATION = "isEngine";
    private static final String IS_CAS_OPERATION = "getIsCentralAdminServer";
    private String componentName = null;
    private String SE_BUNDLE = "lib/addons/jbi/appserv-jbise.jar";
    private String JBI_INSTANCE_NAME = "JBI_INSTANCE_NAME";
    private String JBI_FOLDER = "jbi";
    private String JBI_ENV_PROPERTIES = File.separatorChar + this.JBI_FOLDER + File.separatorChar + "config" + File.separatorChar + "jbienv.properties";
    private MBeanHelper mbeanHelper;
    private String jbiInstanceName;
    private boolean casInstallation;
    private boolean jbiInstalled = false;
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system");

    public InstallerImpl(MBeanHelper mbeanHelper) {
        this.mbeanHelper = mbeanHelper;
        String installationRoot = ApplicationServer.getServerContext().getInstallRoot();
        String jbiInstallationDir = installationRoot + File.separator + this.JBI_FOLDER;
        boolean bl = this.jbiInstalled = new File(jbiInstallationDir).exists() && this.getJBIInstanceName() != null;
        if (this.jbiInstalled) {
            this.casInstallation = this.isCASInstallation();
        }
    }

    public boolean isJBIInstalled() {
        return this.jbiInstalled;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String install(String zipFilePath) throws ServiceEngineException {
        String result = null;
        if (zipFilePath == null) {
            zipFilePath = this.getServiceEngineBundle();
            if (this.casInstallation) {
                this.log(Level.FINE, "Java EE Service Engine Bundle :", zipFilePath);
                try {
                    ObjectName objName = this.mbeanHelper.getObjectName("com.sun.jbi.esb:ServiceType=Installation");
                    this.log(Level.FINEST, "installation_service_log_name", objName.toString());
                    result = (String)this.mbeanHelper.invokeMBeanOperation(objName, ADD_COMPONENT_OPERATION, new Object[]{zipFilePath}, new String[]{"java.lang.String"});
                    this.log(Level.FINEST, " Status of addComponent ", result);
                    result = (String)this.mbeanHelper.invokeMBeanOperation(objName, INSTALL_COMPONENT_OPERATION, new Object[]{this.componentName, Arrays.asList(this.jbiInstanceName), new Properties()}, new String[]{"java.lang.String", "java.util.List", "java.util.Properties"});
                    this.log(Level.FINEST, " Status of installComponent ", result);
                }
                catch (Exception e) {
                    this.log(Level.SEVERE, "Error occurred during installation of Java EE Service Engine", e.getMessage());
                }
            }
        }
        return result;
    }

    public void start() throws ServiceEngineException {
        if (this.casInstallation) {
            try {
                ObjectName objName = this.mbeanHelper.getObjectName("com.sun.jbi.esb:ServiceType=LifeCycle");
                this.log(Level.FINEST, "lifecycle_service_obj_name", objName.toString());
                String result = (String)this.mbeanHelper.invokeMBeanOperation(objName, START_COMPONENT_OPERATION, new Object[]{this.componentName}, new String[]{"java.lang.String"});
                this.log(Level.FINEST, "Start Component Status", result);
            }
            catch (Exception e) {
                this.log(Level.SEVERE, "Error occurred during startup of Java EE Service Engine", e.getMessage());
            }
        }
    }

    public boolean isComponentInstalled() {
        if (this.casInstallation) {
            try {
                ObjectName objName = this.mbeanHelper.getObjectName("com.sun.jbi.esb:ServiceType=Installation");
                String result = (String)this.mbeanHelper.invokeMBeanOperation(objName, "getComponentInfo", new Object[]{this.componentName}, new String[]{"java.lang.String"});
                if (result == null || result.trim().length() == 0) {
                    return false;
                }
            }
            catch (Exception e) {
                this.log(Level.WARNING, "Exception occurred while getting component by name", e.getMessage());
                return false;
            }
        }
        return true;
    }

    public void stop() throws ServiceEngineException {
        if (this.casInstallation) {
            try {
                ObjectName objName = this.mbeanHelper.getObjectName("com.sun.jbi.esb:ServiceType=LifeCycle");
                this.log(Level.FINEST, "lifecycle_service_obj_name", objName.toString());
                String result = (String)this.mbeanHelper.invokeMBeanOperation(objName, STOP_COMPONENT_OPERATION, new Object[]{this.componentName}, new String[]{"java.lang.String"});
                this.log(Level.FINEST, "Start Component Status", result);
            }
            catch (Exception e) {
                this.log(Level.SEVERE, "Error occurred during stopping of Java EE Service Engine", e.getMessage());
            }
        }
    }

    public void uninstall() throws ServiceEngineException {
        if (this.casInstallation) {
            try {
                ObjectName objName = this.mbeanHelper.getObjectName("com.sun.jbi.esb:ServiceType=Installation");
                this.log(Level.FINEST, "installation_service_log_name", objName.toString());
                String result = (String)this.mbeanHelper.invokeMBeanOperation(objName, UNINSTALL_COMPONENT_OPERATION, new Object[]{this.componentName}, new String[]{"java.lang.String"});
                this.log(Level.FINEST, " Status of uninstallComponent ", result);
                result = (String)this.mbeanHelper.invokeMBeanOperation(objName, REMOVE_COMPONENT_OPERATION, new Object[]{this.componentName}, new String[]{"java.lang.String"});
                this.log(Level.FINEST, " Status of removeComponent ", result);
            }
            catch (Exception e) {
                this.log(Level.SEVERE, "Error occurred during uninstallation of Java EE Service Engine", e.getMessage());
            }
        }
    }

    private boolean isCASInstallation() {
        try {
            ObjectName objName = this.mbeanHelper.getObjectName(this.jbiInstanceName, "Framework");
            this.log(Level.FINEST, "Framework MBean Object", objName.toString());
            Boolean result = (Boolean)this.mbeanHelper.invokeMBeanOperation(objName, IS_CAS_OPERATION, null, new String[0]);
            return result;
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Error occurred during checking if the instance is CAS or not", e.getMessage());
            return false;
        }
    }

    private String getJBIInstanceName() {
        if (this.jbiInstanceName == null) {
            try {
                String installRoot = ApplicationServer.getServerContext().getInstallRoot();
                String jbiEnvProperties = installRoot + this.JBI_ENV_PROPERTIES;
                Properties jbiEnv = new Properties();
                logger.fine("JBI Env properties :" + jbiEnvProperties);
                jbiEnv.load(new FileInputStream(jbiEnvProperties));
                this.jbiInstanceName = jbiEnv.getProperty(this.JBI_INSTANCE_NAME);
                logger.fine("JBI Instance name " + this.jbiInstanceName);
            }
            catch (IOException ioe) {
                logger.log(Level.SEVERE, "IOException during reading of jbi env properties " + ioe.getMessage());
            }
        }
        return this.jbiInstanceName;
    }

    private String getServiceEngineBundle() {
        String seBundle = System.getProperty("com.sun.aas.installRoot") + File.separator + this.SE_BUNDLE;
        return seBundle;
    }

    private void log(Level level, String property, String logString) {
        logger.log(level, property, logString);
    }
}

