/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.launcher;

import java.io.File;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StatusProber {
    final String domainConfigFilePath;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage : java StatusProber <s1as-instanceRoot>");
            System.exit(1);
        }
        String instanceRoot = args[0];
        String domainConfigFilePath = instanceRoot + File.separator + "config" + File.separator + "domain.xml";
        new StatusProber(domainConfigFilePath);
    }

    public StatusProber(String configFilePath) {
        this.domainConfigFilePath = configFilePath;
    }

    public void probeStatus() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(this.domainConfigFilePath);
            Element root = doc.getDocumentElement();
            Element httpListenerElement = null;
            String webserverHostname = null;
            String webserverPort = null;
            String adminserverHostname = null;
            String adminserverPort = null;
            NodeList httpListeners = root.getElementsByTagName("http-listener");
            for (int hl = 0; hl < httpListeners.getLength(); ++hl) {
                httpListenerElement = (Element)httpListeners.item(hl);
                String server_id = httpListenerElement.getAttribute("id");
                String server_name = httpListenerElement.getAttribute("server-name");
                String server_port = httpListenerElement.getAttribute("server-port");
                if (server_id.equals("admin-listener")) {
                    adminserverHostname = server_name;
                    adminserverPort = server_port;
                    continue;
                }
                webserverHostname = server_name;
                webserverPort = server_port;
            }
            int webServerPort = new Integer(webserverPort);
            int adminServerPort = new Integer(adminserverPort);
            StatusChecker sc = new StatusChecker(webserverHostname, webServerPort);
            boolean serverUp = sc.probeServer();
            if (!serverUp) {
                System.out.println("Error : Web Server is not up in specified time interval");
                return;
            }
            sc = new StatusChecker(adminserverHostname, adminServerPort);
            serverUp = sc.probeServer();
            if (!serverUp) {
                System.out.println("Error : Admin Server is not up in specified time interval");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected class StatusChecker
    extends Thread {
        boolean status;
        String hostName;
        final long TIMEOUT = 100000L;
        long startTime;
        long elapsedTime;
        String startPage = "index.html";
        int timeout = 240;
        int port = 8080;

        public StatusChecker(String hostName, int port, String startPage, int timeout) {
            this.hostName = hostName;
            this.port = port;
            this.startPage = startPage;
            this.timeout = timeout;
        }

        public StatusChecker(String hostName, int port, String startPage) {
            this(hostName, port, startPage, 120);
        }

        public StatusChecker(String hostName, int port) {
            this(hostName, port, "index.html", 120);
        }

        public boolean probeServer() {
            this.start();
            try {
                this.join();
            }
            catch (InterruptedException e) {
                System.err.println("Exception : " + e);
            }
            if (this.getStatus()) {
                System.out.println("Server is up");
            } else {
                System.out.println("Error : Server is Not up");
            }
            return this.getStatus();
        }

        public boolean getValue() {
            try {
                URL url = new URL("http", this.hostName, this.port, "index.html");
                HttpURLConnection h = (HttpURLConnection)url.openConnection();
                if (h.getResponseCode() != 200) {
                    return false;
                }
                System.out.println("Server " + this.hostName + " is Up ");
                return true;
            }
            catch (ConnectException e) {
                return false;
            }
            catch (Exception e) {
                System.out.println("ERROR " + e);
                return false;
            }
        }

        public void setHostName(String hn) {
            this.hostName = hn;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public boolean getStatus() {
            return this.status;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                long elapsedTime;
                long startTime = System.currentTimeMillis();
                System.out.println("Pinging localhost ...");
                this.status = this.getValue();
                do {
                    elapsedTime = System.currentTimeMillis();
                    if (this.status) return;
                    Thread.sleep(1000L);
                    this.status = this.getValue();
                } while (elapsedTime - startTime < (long)(this.timeout * 1000));
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.status = false;
            }
        }
    }
}

