/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.repository;

import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.repository.ResourcePropertyImpl;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class J2EEResourceBase
implements J2EEResource,
Serializable {
    String name_;
    Map properties_;
    boolean enabled_;
    String description_;

    public J2EEResourceBase(String name) {
        this.name_ = name;
        this.properties_ = new HashMap();
    }

    public String getName() {
        return this.name_;
    }

    public void setEnabled(boolean value) {
        this.enabled_ = value;
    }

    public boolean isEnabled() {
        return this.enabled_;
    }

    public void setDescription(String value) {
        this.description_ = value;
    }

    public String getDescription() {
        return this.description_;
    }

    public abstract int getType();

    public Set getProperties() {
        HashSet<ResourceProperty> shallowCopy = new HashSet<ResourceProperty>();
        Collection collection = this.properties_.values();
        for (ResourceProperty next : collection) {
            shallowCopy.add(next);
        }
        return shallowCopy;
    }

    public void addProperty(ResourceProperty property) {
        this.properties_.put(property.getName(), property);
    }

    public boolean removeProperty(ResourceProperty property) {
        Object removedObj = this.properties_.remove(property.getName());
        return removedObj != null;
    }

    public ResourceProperty getProperty(String propertyName) {
        return (ResourceProperty)this.properties_.get(propertyName);
    }

    public J2EEResource makeClone(String name) {
        J2EEResource clone = this.doClone(name);
        Set entrySet = this.properties_.entrySet();
        for (Map.Entry next : entrySet) {
            ResourceProperty nextProp = (ResourceProperty)next.getValue();
            ResourcePropertyImpl propClone = new ResourcePropertyImpl((String)next.getKey());
            propClone.setValue(next.getValue());
            clone.addProperty(propClone);
        }
        clone.setEnabled(this.isEnabled());
        clone.setDescription(this.getDescription());
        return clone;
    }

    protected String getPropsString() {
        StringBuffer propsBuffer = new StringBuffer();
        Set props = this.getProperties();
        if (!props.isEmpty()) {
            Iterator iter = props.iterator();
            while (iter.hasNext()) {
                if (propsBuffer.length() == 0) {
                    propsBuffer.append("[ ");
                } else {
                    propsBuffer.append(" , ");
                }
                ResourceProperty next = (ResourceProperty)iter.next();
                propsBuffer.append(next.getName() + "=" + next.getValue());
            }
            propsBuffer.append(" ]");
        }
        return propsBuffer.toString();
    }

    protected abstract J2EEResource doClone(String var1);
}

