/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.repository;

import com.sun.enterprise.repository.RepositoryContext;
import com.sun.logging.LogDomains;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

class Repository {
    private static Logger _logger = null;
    private Context ctx = null;
    private String name = null;

    public String find(String name) {
        try {
            String value = (String)this.ctx.lookup(name);
            return value;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean add(String name, String value) {
        try {
            this.ctx.rebind(name, (Object)value);
            return true;
        }
        catch (NamingException ne) {
            _logger.log(Level.SEVERE, "enterprise.addinrepository_exception", ne);
            return false;
        }
    }

    public boolean remove(String name) {
        try {
            this.ctx.unbind(name);
            return true;
        }
        catch (NamingException ne) {
            _logger.log(Level.SEVERE, "enterprise.delinrepository_exception", ne);
            return false;
        }
    }

    public String[] keys() {
        Vector<String> v = new Vector<String>(10);
        NamingEnumeration<Binding> e = null;
        try {
            e = this.ctx.listBindings("");
        }
        catch (NamingException ne) {
            _logger.log(Level.SEVERE, "enterprise.naming_exception", ne);
        }
        while (e != null && e.hasMoreElements()) {
            Binding b = (Binding)e.nextElement();
            v.add(b.getName());
        }
        Object[] keynames = new String[v.size()];
        v.copyInto(keynames);
        return keynames;
    }

    public String getName() {
        return RepositoryContext.getRepositoryName(this.name);
    }

    public Repository(String repositoryName) {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.enterprise.repository.RepositoryInitContextFactory");
        env.put("com.sun.enterprise.repository.name", repositoryName);
        this.name = repositoryName;
        this.init(env);
    }

    public Repository(String repositoryName, String repositoryDir) {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.enterprise.repository.RepositoryInitContextFactory");
        env.put("com.sun.enterprise.repository.name", repositoryName);
        env.put("com.sun.enterprise.repository.dir", repositoryDir);
        this.name = repositoryName;
        this.init(env);
    }

    private void init(Properties env) {
        try {
            this.ctx = new InitialContext(env);
        }
        catch (NamingException ne) {
            _logger.log(Level.SEVERE, "enterprise.naming_exception", ne);
            this.ctx = null;
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise");
    }
}

