/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.Switch;
import com.sun.enterprise.connectors.ConnectorConstants;
import com.sun.enterprise.resource.AbstractResourcePool;
import com.sun.enterprise.resource.AssocWithThreadResourcePool;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourcePool;
import com.sun.enterprise.resource.SJSASResourcePool;
import com.sun.enterprise.resource.UnpooledResource;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourcePoolFactoryImpl {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private static final String SWITCH_OFF_ACC_CONNECTION_POOLING = "com.sun.enterprise.connectors.SwitchoffACCConnectionPooling";
    private static String switchOffACCConnectionPoolingProperty = System.getProperty("com.sun.enterprise.connectors.SwitchoffACCConnectionPooling");

    public static ResourcePool newInstance(String poolName, ConnectorConstants.PoolType pt) throws PoolingException {
        AbstractResourcePool pool = null;
        if (Switch.getSwitch().getContainerType() == 1 && "TRUE".equalsIgnoreCase(switchOffACCConnectionPoolingProperty)) {
            return new UnpooledResource(poolName);
        }
        pool = pt == ConnectorConstants.PoolType.ASSOCIATE_WITH_THREAD_POOL ? new AssocWithThreadResourcePool(poolName) : new SJSASResourcePool(poolName);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Using Pool " + (Object)((Object)pt));
        }
        return pool;
    }
}

