/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.monitor;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.stats.ConnectorConnectionPoolStats;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.resource.MonitorableResourcePool;
import com.sun.enterprise.resource.monitor.ConnectorConnectionPoolStatsImpl;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.j2ee.statistics.Stats;

public class ConnectorPoolMonitoringLevelListener
implements MonitoringLevelListener {
    private MonitoringRegistry registry_;
    private static final MonitoringLevel OFF = MonitoringLevel.OFF;
    private static final MonitoringLevel HIGH = MonitoringLevel.HIGH;
    private static final MonitoringLevel LOW = MonitoringLevel.LOW;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    public void setLevel(MonitoringLevel level) {
    }

    public void changeLevel(MonitoringLevel from, MonitoringLevel to, Stats handback) {
    }

    public void changeLevel(MonitoringLevel from, MonitoringLevel to, MonitoredObjectType type) {
        if (from == to) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ServerContext ctxt = ApplicationServer.getServerContext();
                if (ctxt != null) {
                    ConnectorPoolMonitoringLevelListener.this.registry_ = ctxt.getMonitoringRegistry();
                }
                return null;
            }
        });
        if ((from == OFF || from == LOW) && to == HIGH) {
            this.logFine("Changing level from " + from + "  to HIGH");
            this.transitionToHigh();
        }
        if ((from == HIGH || from == LOW) && to == OFF) {
            this.logFine("Switching level from " + from + " to OFF");
            this.switchOffMonitoring();
        }
        if ((from == OFF || from == HIGH) && to == LOW) {
            this.logFine("Changing level from " + from + " to LOW");
            this.transitionToLow();
        }
    }

    private PoolManager getPoolManager() {
        return Switch.getSwitch().getPoolManager();
    }

    private void transitionToHigh() {
        final ResourcesUtil resUtil = ResourcesUtil.createInstance();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Map<ConnectorConnectionPool, MonitorableResourcePool> poolMap = resUtil.getPoolMap();
                if (poolMap == null) {
                    return null;
                }
                for (Map.Entry<ConnectorConnectionPool, MonitorableResourcePool> entry : poolMap.entrySet()) {
                    ConnectorConnectionPool ccp = entry.getKey();
                    MonitorableResourcePool pool = entry.getValue();
                    if (pool == null) continue;
                    try {
                        ConnectorConnectionPoolStatsImpl stats = new ConnectorConnectionPoolStatsImpl(pool);
                        ConnectorPoolMonitoringLevelListener.this.getPoolManager().setMonitoringEnabledHigh(pool.getPoolName());
                        ConnectorPoolMonitoringLevelListener.this.registry_.registerConnectorConnectionPoolStats((ConnectorConnectionPoolStats)stats, pool.getPoolName(), resUtil.getAppName(ccp), resUtil.getRAName(ccp), null);
                    }
                    catch (Exception mre) {
                        try {
                            _logger.log(Level.WARNING, "poolmon.cannot_reg", mre.getMessage());
                            ConnectorPoolMonitoringLevelListener.this.getPoolManager().disableMonitoring(pool.getPoolName());
                        }
                        catch (Exception ex) {}
                    }
                }
                return null;
            }
        });
    }

    private void switchOffMonitoring() {
        final ResourcesUtil resUtil = ResourcesUtil.createInstance();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Map<ConnectorConnectionPool, MonitorableResourcePool> pools = resUtil.getPoolMap();
                if (pools == null) {
                    return null;
                }
                for (Map.Entry<ConnectorConnectionPool, MonitorableResourcePool> entry : pools.entrySet()) {
                    ConnectorConnectionPool ccp = entry.getKey();
                    MonitorableResourcePool pool = entry.getValue();
                    if (pool == null) continue;
                    try {
                        ConnectorPoolMonitoringLevelListener.this.registry_.unregisterConnectorConnectionPoolStats(pool.getPoolName(), resUtil.getAppName(ccp), resUtil.getRAName(ccp));
                        ConnectorPoolMonitoringLevelListener.this.getPoolManager().disableMonitoring(pool.getPoolName());
                    }
                    catch (Exception mre) {
                        _logger.log(Level.INFO, "poolmon.cannot_unreg");
                    }
                }
                return null;
            }
        });
    }

    private void transitionToLow() {
        final ResourcesUtil resUtil = ResourcesUtil.createInstance();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Map<ConnectorConnectionPool, MonitorableResourcePool> poolMap = resUtil.getPoolMap();
                if (poolMap == null) {
                    return null;
                }
                for (Map.Entry<ConnectorConnectionPool, MonitorableResourcePool> entry : poolMap.entrySet()) {
                    ConnectorConnectionPool ccp = entry.getKey();
                    MonitorableResourcePool pool = entry.getValue();
                    if (pool == null) continue;
                    try {
                        ConnectorConnectionPoolStatsImpl stats = new ConnectorConnectionPoolStatsImpl(pool);
                        ConnectorPoolMonitoringLevelListener.this.getPoolManager().setMonitoringEnabledLow(pool.getPoolName());
                        ConnectorPoolMonitoringLevelListener.this.registry_.registerConnectorConnectionPoolStats((ConnectorConnectionPoolStats)stats, pool.getPoolName(), resUtil.getAppName(ccp), resUtil.getRAName(ccp), null);
                    }
                    catch (Exception mre) {
                        try {
                            _logger.log(Level.WARNING, "poolmon.cannot_reg", mre.getMessage());
                            ConnectorPoolMonitoringLevelListener.this.getPoolManager().disableMonitoring(pool.getPoolName());
                        }
                        catch (Exception ex) {}
                    }
                }
                return null;
            }
        });
    }

    private void logFine(String msg) {
        if (msg != null && _logger.isLoggable(Level.FINE)) {
            _logger.fine(msg);
        }
    }
}

