/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.appserv.management.util.misc.RunnableBase;
import com.sun.appserv.server.ServerLifecycle;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.alert.AlertConfigurator;
import com.sun.enterprise.admin.event.AdminEventListenerRegistry;
import com.sun.enterprise.admin.event.MessageSecurityConfigEvent;
import com.sun.enterprise.admin.event.jms.JmsHostEvent;
import com.sun.enterprise.admin.event.jms.JmsServiceEvent;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.loader.ClassLoaderUtils;
import com.sun.enterprise.security.audit.AuditModuleEventListenerImpl;
import com.sun.enterprise.security.audit.SecurityServiceEventListenerImpl;
import com.sun.enterprise.security.auth.realm.AuthRealmEventListenerImpl;
import com.sun.enterprise.security.auth.realm.UserMgmtEventListenerImpl;
import com.sun.enterprise.security.jmac.config.MessageSecurityConfigEventListenerImpl;
import com.sun.enterprise.server.J2EEServer;
import com.sun.enterprise.server.JmsHostEventListener;
import com.sun.enterprise.server.JmsServiceEventListener;
import com.sun.enterprise.server.PELaunch;
import com.sun.enterprise.server.ResourceManager;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.ServerContextImpl;
import com.sun.enterprise.server.logging.ServerLogManager;
import com.sun.enterprise.server.pluggable.InternalServicesList;
import com.sun.enterprise.util.ConnectorClassLoader;
import com.sun.enterprise.util.FeatureAvailability;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationServer {
    protected static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    private static ServerContext context = null;
    private final List<ServerLifecycle> services = new ArrayList<ServerLifecycle>();
    private ClassLoader commonClassLoader;
    private ClassLoader connectorClassLoader;
    private static final int CLASSNAME_IDX = 1;
    private static final RunnableBase.HowToRun HOW_TO_RUN = RunnableBase.HowToRun.RUN_IN_CURRENT_THREAD;

    public void onInitialization(ServerContext context) throws ServerLifecycleException {
        ApplicationServer.context = context;
        FeatureAvailability.getInstance().waitForMBeanServer();
        ServerLogManager.reInitializeServerLoggers();
        this.printStartupInfo();
        ClassLoader parentOfCommonCL = this.getClass().getClassLoader();
        if (Boolean.getBoolean("com.sun.aas.useNewClassLoader")) {
            parentOfCommonCL = PELaunch.getSharedChain();
        }
        InstanceEnvironment env = ApplicationServer.context.getInstanceEnvironment();
        try {
            String dir = env.getLibClassesPath();
            String jarDir = env.getLibPath();
            this.commonClassLoader = ClassLoaderUtils.getClassLoader(new File[]{new File(dir)}, new File[]{new File(jarDir)}, parentOfCommonCL);
            this.logCommonClassLoaderDetails();
            if (this.commonClassLoader == null) {
                this.commonClassLoader = parentOfCommonCL;
            }
        }
        catch (IOException ioe) {
            _logger.log(Level.WARNING, "server.ioexception", ioe);
            this.commonClassLoader = parentOfCommonCL;
        }
        catch (Throwable th) {
            _logger.log(Level.WARNING, "server.exception", th);
            this.commonClassLoader = parentOfCommonCL;
        }
        this.connectorClassLoader = ConnectorClassLoader.getInstance(this.commonClassLoader);
        if (ApplicationServer.context instanceof ServerContextImpl) {
            ServerContextImpl contextImpl = (ServerContextImpl)ApplicationServer.context;
            contextImpl.setCommonClassLoader(this.commonClassLoader);
            contextImpl.setSharedClassLoader(this.connectorClassLoader);
            contextImpl.setLifecycleParentClassLoader(this.connectorClassLoader);
        }
        final ClassLoader commonCL = this.commonClassLoader;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(commonCL);
                return null;
            }
        });
        InternalServicesList servicesList = context.getPluggableFeatureFactory().getInternalServicesList();
        String[][] servicesByName = servicesList.getServicesByName();
        if (servicesByName == null) {
            _logger.log(Level.SEVERE, "services.null");
            throw new ServerLifecycleException();
        }
        List<ServerLifecycle> temp = this.instantiateRuntimeServices(context, servicesByName);
        this.services.addAll(temp);
        for (ServerLifecycle service : this.services) {
            try {
                service.onInitialization(context);
            }
            catch (ServerLifecycleException e) {
                _logger.log(Level.SEVERE, "service.notinit", new Object[]{service, e.toString()});
                throw e;
            }
        }
        AdminEventListenerRegistry.addAuditModuleEventListener(new AuditModuleEventListenerImpl());
        AdminEventListenerRegistry.addAuthRealmEventListener(new AuthRealmEventListenerImpl());
        AdminEventListenerRegistry.addSecurityServiceEventListener(new SecurityServiceEventListenerImpl());
        AdminEventListenerRegistry.addUserMgmtEventListener(new UserMgmtEventListenerImpl());
        AdminEventListenerRegistry.addEventListener(MessageSecurityConfigEvent.eventType, new MessageSecurityConfigEventListenerImpl());
        try {
            J2EEServer.main(context);
        }
        catch (Exception e) {
            throw new ServerLifecycleException(e);
        }
        final ClassLoader connCL = this.connectorClassLoader;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(connCL);
                return null;
            }
        });
    }

    private void logCommonClassLoaderDetails() {
        Logger _log = LogDomains.getLogger("javax.enterprise.system.core.classloading");
        if (_log.isLoggable(Level.FINE) && this.commonClassLoader instanceof URLClassLoader) {
            URL[] u = ((URLClassLoader)this.commonClassLoader).getURLs();
            StringBuffer sbuf = new StringBuffer();
            for (int i = 0; i < u.length; ++i) {
                sbuf.append(u[i].toExternalForm() + " ,");
            }
            _log.log(Level.FINE, "Common classloader contents: [ " + sbuf.toString() + " ].");
        }
    }

    protected static final ServerLifecycle instantiateOneServerLifecycle(ServerContext serverContext, String classname) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> c = Class.forName(classname);
        ServerLifecycle item = null;
        try {
            Constructor<?> constructor = c.getConstructor(ServerContext.class);
            item = (ServerLifecycle)constructor.newInstance(serverContext);
        }
        catch (Exception e) {
            item = (ServerLifecycle)c.newInstance();
        }
        return item;
    }

    protected List<ServerLifecycle> instantiateRuntimeServices(ServerContext serverContext, String[][] servicesByName) throws ServerLifecycleException {
        ArrayList<String> classnames = new ArrayList<String>();
        for (int i = 0; i < servicesByName.length; ++i) {
            String[] serviceInfo = servicesByName[i];
            String classname = serviceInfo[1];
            classnames.add(classname);
        }
        return this.instantiateRuntimeServices(serverContext, classnames);
    }

    protected List<ServerLifecycle> instantiateRuntimeServices(ServerContext serverContext, List<String> classnames) throws ServerLifecycleException {
        Instantiator[] instantiators = new Instantiator[classnames.size()];
        int idx = 0;
        for (String classname : classnames) {
            instantiators[idx] = new Instantiator(serverContext, classname);
            instantiators[idx].submit();
            ++idx;
        }
        ArrayList<ServerLifecycle> serviceList = new ArrayList<ServerLifecycle>();
        for (int i = 0; i < instantiators.length; ++i) {
            serviceList.add(instantiators[i].getService());
        }
        return serviceList;
    }

    public void onStartup() throws ServerLifecycleException {
        for (ServerLifecycle service : this.services) {
            try {
                service.onStartup(context);
            }
            catch (ServerLifecycleException e) {
                _logger.log(Level.SEVERE, "service.notstarted", new Object[]{service, e.toString()});
                throw e;
            }
        }
        AlertConfigurator.getAlertConfigurator().configure();
    }

    public void onReady() throws ServerLifecycleException {
        try {
            AdminEventListenerRegistry.addResourceDeployEventListener(new ResourceManager(context));
            AdminEventListenerRegistry.addEventListener(JmsServiceEvent.eventType, new JmsServiceEventListener());
            AdminEventListenerRegistry.addEventListener(JmsHostEvent.eventType, new JmsHostEventListener());
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread.currentThread().setContextClassLoader(ApplicationServer.this.commonClassLoader);
                    return null;
                }
            });
            String startupHook = null;
            startupHook = System.getProperty("com.sun.enterprise.server.startupHook");
            if (startupHook != null) {
                try {
                    Class<?> hookClass = Class.forName(startupHook);
                    Method hookMethod = hookClass.getMethod("main", ServerContext.class);
                    hookMethod.invoke(null, context);
                }
                catch (Exception ex) {
                    _logger.log(Level.FINE, "server.exception", ex);
                }
            }
        }
        catch (Exception ee) {
            throw new ServerLifecycleException(ee);
        }
        for (ServerLifecycle service : this.services) {
            try {
                service.onReady(context);
            }
            catch (ServerLifecycleException e) {
                _logger.log(Level.SEVERE, "service.notready", new Object[]{service, e.toString()});
            }
        }
    }

    public void onShutdown() throws ServerLifecycleException {
        for (int i = this.services.size(); i > 0; --i) {
            ServerLifecycle service = this.services.get(i - 1);
            _logger.log(Level.FINE, "service.shutdown", this.services.get(i - 1));
            try {
                service.onShutdown();
                continue;
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "server.exception", e);
            }
        }
    }

    public void onTermination() throws ServerLifecycleException {
        block6: {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Killing all pools in the appserver");
            }
            try {
                Switch.getSwitch().getPoolManager().killAllPools();
            }
            catch (Throwable t) {
                if (!_logger.isLoggable(Level.FINE)) break block6;
                _logger.log(Level.FINE, "exception : " + t);
            }
        }
        for (int i = this.services.size(); i > 0; --i) {
            ServerLifecycle service = this.services.get(i - 1);
            _logger.log(Level.FINE, "service.shutdown", this.services.get(i - 1));
            try {
                service.onTermination();
                continue;
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "server.exception", e);
            }
        }
        this.services.clear();
    }

    public static ServerContext getServerContext() {
        return context;
    }

    protected void setServerContext(ServerContext context) {
        ApplicationServer.context = context;
    }

    private void printStartupInfo() {
        _logger.log(Level.INFO, "j2eerunner.printstartinfo", new Object[]{System.getProperty("java.vm.name"), System.getProperty("java.version"), System.getProperty("java.vm.vendor")});
    }

    private static final class Instantiator
    extends RunnableBase {
        private final String mClassname;
        private final ServerContext mServerContext;
        private volatile ServerLifecycle mService;

        public Instantiator(ServerContext serverContext, String classname) {
            this.mServerContext = serverContext;
            this.mClassname = classname;
            this.mService = null;
        }

        protected void doRun() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
            this.mService = ApplicationServer.instantiateOneServerLifecycle(this.mServerContext, this.mClassname);
        }

        public ServerLifecycle getService() {
            this.waitDoneThrow();
            return this.mService;
        }
    }
}

