/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.appserv.management.util.misc.RunnableBase;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.appserv.server.util.Version;
import com.sun.enterprise.admin.event.AdminEventListenerRegistry;
import com.sun.enterprise.admin.event.AdminEventResult;
import com.sun.enterprise.admin.event.ShutdownEvent;
import com.sun.enterprise.admin.server.core.channel.RMIClient;
import com.sun.enterprise.admin.server.core.channel.RRStateFactory;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.launcher.PELaunchFilter;
import com.sun.enterprise.management.support.SystemInfoData;
import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.security.audit.AuditManagerFactory;
import com.sun.enterprise.security.store.IdentityManager;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.PELaunch;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.ServerContextImpl;
import com.sun.enterprise.server.Shutdown;
import com.sun.enterprise.server.logging.SystemOutandErrHandler;
import com.sun.enterprise.server.logging.stats.ErrorStatistics;
import com.sun.enterprise.server.ondemand.OnDemandServer;
import com.sun.enterprise.server.pluggable.PluggableFeatureFactory;
import com.sun.enterprise.server.pluggable.PluggableFeatureFactoryImpl;
import com.sun.enterprise.util.ASenvPropertyReader;
import com.sun.enterprise.util.FeatureAvailability;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;

public class PEMain {
    private static final long START_TIME_MILLIS = System.currentTimeMillis();
    public static volatile boolean shutdownStarted;
    public static volatile boolean shutdownThreadInvoked;
    private static volatile ApplicationServer _server;
    private static final String STOP = "stop";
    private static volatile PEMain _instance;
    private static final String SERVER_INSTANCE;
    private static StringManager localStrings;
    ServerContext context = null;
    private static Logger _logger;
    private ClassLoader _loader = this.getClass().getClassLoader();
    private boolean isStarted = false;
    private static final String instance_root;
    private static AuditManager auditManager;
    private static final boolean USE_OLD_INSTANCE_STATUS_CHECK = false;

    public static long getStartTimeMillis() {
        return START_TIME_MILLIS;
    }

    public PEMain() {
        Thread.currentThread().setContextClassLoader(this._loader);
        AdminEventListenerRegistry.addShutdownEventListener(new Shutdown());
        _instance = this;
    }

    private static synchronized Logger getLogger() {
        if (_logger == null) {
            _logger = LogDomains.getLogger("javax.enterprise.system.core");
        }
        return _logger;
    }

    public static void main(String[] args) {
        new AtStartup().submit(RunnableBase.HowToRun.RUN_IN_SEPARATE_THREAD);
        new LoadMBeanServer().submit(RunnableBase.HowToRun.RUN_IN_SEPARATE_THREAD);
        boolean verbose = false;
        boolean dbg = false;
        PEMain.setSystemLocale();
        if (args[0].trim().equals(STOP)) {
            if (PEMain.isInstanceRunning()) {
                PEMain.shutdown();
            } else {
                PEMain.getLogger().log(Level.INFO, "instance.notRunning");
            }
            return;
        }
        try {
            String verboseMode = System.getProperty("com.sun.aas.verboseMode", "false");
            try {
                if (IdentityManager.getUser() == null) {
                    IdentityManager.populateFromInputStreamQuietly();
                }
            }
            catch (IOException e) {
                PEMain.getLogger().log(Level.WARNING, "pemain.failureOnReadingSecurityIdentity", e);
            }
            if (PEMain.getLogger().isLoggable(Level.FINE)) {
                PEMain.getLogger().log(Level.FINE, IdentityManager.getFormatedContents());
            }
            ASenvPropertyReader reader = new ASenvPropertyReader(System.getProperty("com.sun.aas.configRoot"));
            reader.setSystemProperties();
            PEMain.getLogger().log(Level.FINE, "instance.start", SERVER_INSTANCE);
            _server = new OnDemandServer();
            String cstr = localStrings.getStringWithDefault("pemain.start", "Sun Java System Application Server", new String[]{Version.getFullVersion()});
            PEMain.getLogger().log(Level.INFO, cstr);
            String debugOptions = System.getProperty("com.sun.aas.jdwpOptions");
            if (debugOptions != null && !debugOptions.equals("")) {
                String transport = PELaunchFilter.getDebugProperty(debugOptions, "transport");
                String addr = PELaunchFilter.getDebugProperty(debugOptions, "address");
                String str = localStrings.getStringWithDefault("pemain.debugger.message", "Application server is listening at address " + addr + " for debugger to attach using transport " + transport, new Object[]{addr, transport});
                System.err.println(str);
            }
            PEMain peMain = new PEMain();
            ShutdownThread shutdownThread = new ShutdownThread();
            Runtime runtime = Runtime.getRuntime();
            runtime.addShutdownHook(shutdownThread);
            peMain.run(System.getProperty("com.sun.aas.instanceRoot"));
            long now = System.currentTimeMillis();
            long pemainMillis = now - PEMain.getStartTimeMillis();
            long pelaunchMillis = now - PELaunch.getStartTimeMillis();
            SystemInfoData.getInstance().addPerformanceMillis("PEMain.startup", pemainMillis);
            SystemInfoData.getInstance().addPerformanceMillis("PELaunch.startup", pelaunchMillis);
            PEMain.getLogger().log(Level.INFO, "pemain.startup.complete");
            if (auditManager.isAuditOn()) {
                auditManager.serverStarted();
            }
        }
        catch (Exception e) {
            PEMain.getLogger().log(Level.SEVERE, "pemain.error", e.getMessage());
            System.exit(1);
        }
    }

    public static ApplicationServer getApplicationServer() {
        return _server;
    }

    public static PEMain getInstance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String rootDir) {
        try {
            RRStateFactory.removeStateFile();
        }
        catch (Exception e) {
            PEMain.getLogger().log(Level.FINE, "Could not remove restart required state file", e);
        }
        try {
            this.context = this.createServerContext(rootDir);
        }
        catch (ConfigException ce) {
            PEMain.getLogger().log(Level.SEVERE, "j2eerunner.cannotCreateServerContext", ce);
        }
        new SystemOutandErrHandler();
        _server.setServerContext(this.context);
        try {
            _server.onInitialization(this.context);
            if (PEMain.getLogger().isLoggable(Level.FINE)) {
                PEMain.getLogger().log(Level.FINE, "application.config_file" + this.context.getServerConfigURL());
                PEMain.getLogger().log(Level.FINE, "application.default_locale" + Locale.getDefault());
            }
            _server.onStartup();
            _server.onReady();
            try {
                FeatureAvailability.getInstance().getMBeanServer().queryNames(null, null);
            }
            catch (Exception ex) {
                // empty catch block
            }
            FeatureAvailability.getInstance().registerFeature("ServerStarted", "");
        }
        catch (Exception ee) {
            PEMain.getLogger().log(Level.SEVERE, "j2eerunner.initError", ee);
            PEMain.getLogger().log(Level.SEVERE, "pemain.startup.failed");
            PEMain.getLogger().log(Level.INFO, "shutdown.started");
            try {
                _server.onShutdown();
            }
            catch (ServerLifecycleException e) {
                PEMain.getLogger().log(Level.SEVERE, "j2eerunner.initError", e);
            }
            try {
                _server.onTermination();
            }
            catch (ServerLifecycleException e) {
                PEMain.getLogger().log(Level.SEVERE, "j2eerunner.initError", e);
            }
            PEMain.getLogger().log(Level.SEVERE, "pemain.server.startup.failed.exit");
            System.exit(1);
        }
        PEMain pEMain = this;
        synchronized (pEMain) {
            this.isStarted = true;
            this.notifyAll();
        }
    }

    public boolean isStartingUp() {
        return !this.isStarted;
    }

    public static void shutdown() {
        try {
            RMIClient rmiClient = new RMIClient(true, PEMain.getStubFilePath(), PEMain.getSeedFilePath());
            ShutdownEvent shutdownEvent = new ShutdownEvent(SERVER_INSTANCE);
            PEMain.getLogger().log(Level.INFO, "sending notification to server..." + SERVER_INSTANCE);
            AdminEventResult result = rmiClient.sendNotification(shutdownEvent);
            PEMain.getLogger().log(Level.INFO, "server.shutdown_complete");
        }
        catch (Exception e) {
            PEMain.getLogger().log(Level.SEVERE, "j2eerunner.initError", e);
        }
    }

    public static String getStubFilePath() {
        return instance_root + File.separatorChar + "config" + File.separatorChar + "admch";
    }

    public static String getSeedFilePath() {
        return instance_root + File.separatorChar + "config" + File.separatorChar + "admsn";
    }

    private static int getInstanceStatus() {
        String stubFile = PEMain.getStubFilePath();
        String seedFile = PEMain.getSeedFilePath();
        RMIClient rmiClient = new RMIClient(true, stubFile, seedFile);
        return rmiClient.getInstanceStatusCode();
    }

    private static boolean isInstanceRunning() {
        return PEMain.getInstanceStatus() == 0;
    }

    private static boolean isInstanceStartingOrRunning() {
        int statusCode = PEMain.getInstanceStatus();
        return statusCode == 1 || statusCode == 0;
    }

    public static boolean isInstanceAlreadyStarted() {
        return PEMain.isInstanceStartingOrRunning();
    }

    private ServerContext createServerContext(String rootDir) throws ConfigException {
        String[] args = new String[]{};
        ServerContextImpl context = new ServerContextImpl();
        context.setCmdLineArgs(args);
        context.setInstallRoot(rootDir);
        context.setInstanceName(SERVER_INSTANCE);
        try {
            String serverXml = context.getServerConfigURL();
            ConfigContext cfgContext = ConfigFactory.createConfigContext(serverXml, true, false, true);
            context.setConfigContext(cfgContext);
        }
        catch (Exception ex) {
            if (!(ex instanceof ConfigException)) {
                PEMain.getLogger().log(Level.SEVERE, "j2eerunner.server_context_excp", ex);
                if (_logger == null) {
                    System.err.println("Exception in creating server context");
                    ex.printStackTrace();
                }
            }
            throw new ConfigException(ex.getMessage());
        }
        PluggableFeatureFactory ff = PluggableFeatureFactoryImpl.getFactory();
        context.setPluggableFeatureFactory(ff);
        return context;
    }

    static void setSystemLocale() {
        String locale = System.getProperty("com.sun.aas.defaultLocale");
        if (locale != null && !"".equals(locale)) {
            try {
                String[] tokens = locale.split("_", 3);
                switch (tokens.length) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        Locale.setDefault(new Locale(tokens[0]));
                        break;
                    }
                    case 2: {
                        Locale.setDefault(new Locale(tokens[0], tokens[1]));
                        break;
                    }
                    default: {
                        Locale.setDefault(new Locale(tokens[0], tokens[1], tokens[2]));
                        break;
                    }
                }
            }
            catch (Exception e) {
                PEMain.getLogger().log(Level.WARNING, "locale.setdefault.error", locale);
            }
        }
    }

    static {
        ErrorStatistics.registerStartupTime();
        shutdownStarted = false;
        shutdownThreadInvoked = false;
        _server = null;
        _instance = null;
        SERVER_INSTANCE = System.getProperty("com.sun.aas.instanceName");
        localStrings = StringManager.getManager(PEMain.class);
        _logger = null;
        instance_root = System.getProperty("com.sun.aas.instanceRoot");
        auditManager = AuditManagerFactory.getAuditManagerInstance();
    }

    private static class ShutdownThread
    extends Thread {
        public void run() {
            shutdownThreadInvoked = true;
            if (!shutdownStarted) {
                PEMain.shutdown();
            }
        }
    }

    private static final class LoadMBeanServer
    extends RunnableBase {
        LoadMBeanServer() {
            super("PEMain-LoadMBeanServer");
        }

        protected void doRun() {
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            FeatureAvailability.getInstance().registerFeature("MBeanServer", mbeanServer);
            PEMain.getLogger().log(Level.INFO, "pemain.mbeanserver_started", mbeanServer.getClass().getName());
        }
    }

    private static final class AtStartup
    extends RunnableBase {
        AtStartup() {
            super("PEMain-AtStartup");
        }

        private void callAMXPreload() {
            try {
                Class<?> c = Class.forName("com.sun.enterprise.management.support.Preload");
                Method m = c.getMethod("preload", null);
                m.invoke((Object)null, new Object[0]);
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }

        protected void doRun() {
            Thread thisThread = Thread.currentThread();
            thisThread.setPriority(1);
            this.callAMXPreload();
        }
    }
}

