/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.LogLevelChangeEvent;
import com.sun.enterprise.admin.event.LogLevelChangeEventListener;
import com.sun.enterprise.config.ConfigAdd;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigChange;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigUpdate;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.server.logging.LogMBean;
import java.util.logging.ErrorManager;
import java.util.logging.Logger;

public class LogLevelChangeEventListenerImpl
implements LogLevelChangeEventListener {
    public void logLevelChanged(LogLevelChangeEvent event) throws AdminEventListenerException {
        try {
            if (event.isPropertyChanged()) {
                ConfigContext newConfig = event.getConfigContext();
                for (Object change : event.getConfigChangeList()) {
                    ConfigBean item;
                    String xpath;
                    if (!(change instanceof ConfigAdd) && !(change instanceof ConfigUpdate) || (xpath = ((ConfigChange)change).getXPath()) == null || !((item = newConfig.exactLookup(xpath)) instanceof ElementProperty)) continue;
                    ElementProperty elementProperty = (ElementProperty)item;
                    String loggerName = elementProperty.getName();
                    String logLevel = elementProperty.getValue();
                    boolean logExists = LogMBean.getInstance().findLogger(loggerName);
                    if (!logExists) {
                        Logger.getLogger(loggerName);
                    }
                    LogMBean.getInstance().setLogLevel(loggerName, logLevel);
                }
            } else {
                LogMBean.getInstance().setLogLevelForModule(event.getModuleName(), event.getNewLogLevel());
            }
        }
        catch (Exception e) {
            new ErrorManager().error("Error In LogLevelChanged event", e, 0);
        }
    }
}

