/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.monitor.callflow.Agent;
import com.sun.enterprise.admin.monitor.callflow.ThreadLocalData;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.ErrorManager;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import sun.security.action.GetPropertyAction;

public class UniformLogFormatter
extends Formatter {
    private HashMap loggerResourceBundleTable;
    private LogManager logManager;
    private Date date = new Date();
    private static String PRODUCTID_CONTEXTID;
    private static final String PRODUCT_VERSION;
    private static final int FINE_LEVEL_INT_VALUE;
    private static boolean LOG_SOURCE_IN_KEY_VALUE;
    private static boolean RECORD_NUMBER_IN_KEY_VALUE;
    private long recordNumber = 0L;
    private static final String LINE_SEPARATOR;
    private static final String RECORD_BEGIN_MARKER = "[#|";
    private static final String RECORD_END_MARKER;
    private static final char FIELD_SEPARATOR = '|';
    private static final char NVPAIR_SEPARATOR = ';';
    private static final char NV_SEPARATOR = '=';
    private static final String RFC_3339_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final SimpleDateFormat dateFormatter;

    public UniformLogFormatter() {
        this.loggerResourceBundleTable = new HashMap();
        this.logManager = LogManager.getLogManager();
    }

    public String format(LogRecord record) {
        return this.uniformLogFormat(record);
    }

    public String formatMessage(LogRecord record) {
        return this.uniformLogFormat(record);
    }

    protected String getProductId() {
        return PRODUCT_VERSION;
    }

    protected void getNameValuePairs(StringBuilder buf, LogRecord record) {
        Object[] parameters = record.getParameters();
        if (parameters == null || parameters.length == 0) {
            return;
        }
        try {
            for (Object obj : parameters) {
                if (obj == null) continue;
                if (obj instanceof Map) {
                    Map map = (Map)obj;
                    for (Object key : map.keySet()) {
                        buf.append(key.toString()).append('=').append(map.get(key).toString()).append(';');
                    }
                    continue;
                }
                if (obj instanceof Collection) {
                    for (Object entry : (Collection)obj) {
                        buf.append(entry.toString()).append(';');
                    }
                    continue;
                }
                buf.append(obj.toString()).append(';');
            }
        }
        catch (Exception e) {
            new ErrorManager().error("Error in extracting Name Value Pairs", e, 5);
        }
    }

    private void uniformLogFormat(StringBuilder buf, ThreadLocalData tld, Level level) {
        if (level.equals(Level.INFO) || level.equals(Level.CONFIG)) {
            if (tld.getApplicationName() != null) {
                buf.append("_ApplicationName").append('=').append(tld.getApplicationName()).append(';');
            }
        } else {
            if (tld.getRequestId() != null) {
                buf.append("_RequestID").append('=').append(tld.getRequestId()).append(';');
            }
            if (tld.getApplicationName() != null) {
                buf.append("_ApplicationName").append('=').append(tld.getApplicationName()).append(';');
            }
            if (tld.getModuleName() != null) {
                buf.append("_ModuleName").append('=').append(tld.getModuleName()).append(';');
            }
            if (tld.getComponentName() != null) {
                buf.append("_ComponentName").append('=').append(tld.getComponentName()).append(';');
            }
            if (tld.getComponentType() != null) {
                buf.append("_ComponentType").append('=').append(tld.getComponentType()).append(';');
            }
            if (tld.getMethodName() != null) {
                buf.append("_MethodName").append('=').append(tld.getMethodName()).append(';');
            }
            if (tld.getTransactionId() != null) {
                buf.append("_TransactionId").append('=').append(tld.getTransactionId()).append(';');
            }
            if (tld.getSecurityId() != null) {
                buf.append("_CallerId").append('=').append(tld.getSecurityId()).append(';');
            }
        }
    }

    private String uniformLogFormat(LogRecord record) {
        try {
            ThreadLocalData tld;
            StringBuilder recordBuffer = new StringBuilder(RECORD_BEGIN_MARKER);
            this.date.setTime(record.getMillis());
            recordBuffer.append(dateFormatter.format(this.date));
            recordBuffer.append('|');
            recordBuffer.append(record.getLevel()).append('|');
            recordBuffer.append(this.getProductId()).append('|');
            recordBuffer.append(record.getLoggerName()).append('|');
            recordBuffer.append("_ThreadID").append('=');
            recordBuffer.append(record.getThreadID()).append(';');
            recordBuffer.append("_ThreadName").append('=');
            recordBuffer.append(Thread.currentThread().getName());
            recordBuffer.append(';');
            Level level = record.getLevel();
            if (LOG_SOURCE_IN_KEY_VALUE || level.intValue() <= Level.FINE.intValue()) {
                recordBuffer.append("ClassName").append('=');
                recordBuffer.append(record.getSourceClassName());
                recordBuffer.append(';');
                recordBuffer.append("MethodName").append('=');
                recordBuffer.append(record.getSourceMethodName());
                recordBuffer.append(';');
            }
            if (RECORD_NUMBER_IN_KEY_VALUE) {
                recordBuffer.append("RecordNumber").append('=');
                recordBuffer.append(this.recordNumber++).append(';');
            }
            this.getNameValuePairs(recordBuffer, record);
            Agent callFlowAgent = Switch.getSwitch().getCallFlowAgent();
            if (callFlowAgent != null && (tld = callFlowAgent.getThreadLocalData()) != null) {
                this.uniformLogFormat(recordBuffer, tld, level);
            }
            recordBuffer.append('|');
            String logMessage = record.getMessage();
            if (logMessage == null) {
                logMessage = "The log message is null.";
            }
            if (logMessage.indexOf("{0}") >= 0) {
                logMessage = MessageFormat.format(logMessage, record.getParameters());
            } else {
                ResourceBundle rb = this.getResourceBundle(record.getLoggerName());
                if (rb != null) {
                    try {
                        logMessage = MessageFormat.format(rb.getString(logMessage), record.getParameters());
                    }
                    catch (MissingResourceException e) {
                        // empty catch block
                    }
                }
            }
            recordBuffer.append(logMessage);
            if (record.getThrown() != null) {
                recordBuffer.append(LINE_SEPARATOR);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                recordBuffer.append(sw.toString());
            }
            recordBuffer.append(RECORD_END_MARKER);
            return recordBuffer.toString();
        }
        catch (Exception ex) {
            new ErrorManager().error("Error in formatting Logrecord", ex, 5);
            return new String("");
        }
    }

    private synchronized ResourceBundle getResourceBundle(String loggerName) {
        if (loggerName == null) {
            return null;
        }
        ResourceBundle rb = (ResourceBundle)this.loggerResourceBundleTable.get(loggerName);
        if (rb == null) {
            rb = this.logManager.getLogger(loggerName).getResourceBundle();
            this.loggerResourceBundleTable.put(loggerName, rb);
        }
        return rb;
    }

    static {
        String recordCount;
        PRODUCTID_CONTEXTID = null;
        PRODUCT_VERSION = Version.getAbbreviatedVersion();
        FINE_LEVEL_INT_VALUE = Level.FINE.intValue();
        LOG_SOURCE_IN_KEY_VALUE = false;
        RECORD_NUMBER_IN_KEY_VALUE = false;
        String logSource = System.getProperty("com.sun.aas.logging.keyvalue.logsource");
        if (logSource != null && logSource.equals("true")) {
            LOG_SOURCE_IN_KEY_VALUE = true;
        }
        if ((recordCount = System.getProperty("com.sun.aas.logging.keyvalue.recordnumber")) != null && recordCount.equals("true")) {
            RECORD_NUMBER_IN_KEY_VALUE = true;
        }
        LINE_SEPARATOR = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        RECORD_END_MARKER = "|#]" + LINE_SEPARATOR + LINE_SEPARATOR;
        dateFormatter = new SimpleDateFormat(RFC_3339_DATE_FORMAT);
    }
}

