/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.diagnostics;

import com.sun.enterprise.server.logging.diagnostics.Diagnostics;
import com.sun.enterprise.server.logging.diagnostics.ResourceBundleLocator;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageIdCatalog {
    private static final MessageIdCatalog instance = new MessageIdCatalog();

    public static MessageIdCatalog getInstance() {
        return instance;
    }

    public ArrayList getDiagnosticCausesForMessageId(String messageId) {
        ResourceBundle rb = ResourceBundleLocator.getResourceBundleForMessageId(messageId);
        String cause = null;
        ArrayList<String> causes = null;
        if (rb != null) {
            for (int i = 1; i < 5; ++i) {
                try {
                    cause = rb.getString(messageId + ".diag.cause." + i);
                }
                catch (MissingResourceException e) {
                    break;
                }
                if (cause == null) break;
                if (causes == null) {
                    causes = new ArrayList<String>();
                }
                causes.add(cause);
            }
        }
        return causes;
    }

    public ArrayList getDiagnosticChecksForMessageId(String messageId) {
        ResourceBundle rb = ResourceBundleLocator.getResourceBundleForMessageId(messageId);
        String check = null;
        ArrayList<String> checks = null;
        if (rb != null) {
            for (int i = 1; i < 5; ++i) {
                try {
                    check = rb.getString(messageId + ".diag.check." + i);
                }
                catch (MissingResourceException e) {
                    break;
                }
                if (check == null) break;
                if (checks == null) {
                    checks = new ArrayList<String>();
                }
                checks.add(check);
            }
        }
        return checks;
    }

    public String getDiagnosticURIForMessageId(String messageId) {
        String moduleId = ResourceBundleLocator.getModuleId(messageId);
        if (moduleId == null) {
            return null;
        }
        return "http://docs.sun.com/diagnostics/jes/appserver/" + moduleId + "/" + messageId;
    }

    public Diagnostics getDiagnosticsForMessageId(String messageId) {
        ArrayList causes = this.getDiagnosticCausesForMessageId(messageId);
        ArrayList checks = this.getDiagnosticChecksForMessageId(messageId);
        if (causes == null && checks == null) {
            return null;
        }
        Diagnostics diagnostics = new Diagnostics(messageId);
        diagnostics.setPossibleCauses(causes);
        diagnostics.setDiagnosticChecks(checks);
        diagnostics.setURI(this.getDiagnosticURIForMessageId(messageId));
        return diagnostics;
    }
}

