/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.ondemand;

import com.sun.appserv.server.ServerLifecycle;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.ondemand.ServiceGroupException;
import com.sun.enterprise.server.ondemand.ServiceGroupListener;
import com.sun.enterprise.server.ondemand.entry.EntryContext;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ServiceGroup {
    protected static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");
    private final ArrayList sgList = new ArrayList();
    public static final int NOTSTARTED = 0;
    public static final int STARTING = 1;
    public static final int STARTED = 2;
    public static final int STOPPING = 8;
    public static final int STOPPED = 9;
    private int state = 0;
    private ServerLifecycle[] services = new ServerLifecycle[0];
    private static final ArrayList<ServiceGroupListener> listeners = new ArrayList();

    private void notifyListener(int state, ServiceGroup sg) {
        for (ServiceGroupListener l : listeners) {
            try {
                switch (state) {
                    case 1: {
                        l.beforeStart(sg.getClass().getName());
                        break;
                    }
                    case 2: {
                        l.afterStart(sg.getClass().getName());
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static void addServiceGroupListener(ServiceGroupListener listener) {
        listeners.add(listener);
    }

    public static void removeServiceGroupListener(ServiceGroupListener listener) {
        listeners.remove(listener);
    }

    public void addServiceGroup(ServiceGroup group) {
        this.sgList.add(group);
    }

    public void removeServiceGroup(ServiceGroup group) {
        this.sgList.remove(group);
    }

    public Iterator serviceGroupIterator() {
        return this.sgList.iterator();
    }

    public boolean isNotified(EntryContext context) {
        Iterator it = this.serviceGroupIterator();
        while (it.hasNext()) {
            ServiceGroup sg = (ServiceGroup)it.next();
            if (sg.getState() == 2 || !sg.analyseEntryContext(context)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startChildren(final EntryContext context) throws ServiceGroupException {
        Iterator it = this.serviceGroupIterator();
        while (it.hasNext()) {
            final ServiceGroup sg = (ServiceGroup)it.next();
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("Trying " + sg + " servicegroup");
            }
            if (sg.getState() == 2 || !sg.analyseEntryContext(context)) continue;
            ServiceGroup serviceGroup = sg;
            synchronized (serviceGroup) {
                if (sg.getState() == 0) {
                    sg.setState(1);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("Starting " + sg + " servicegroup with context :" + context);
                    }
                    this.notifyListener(1, sg);
                    ComponentInvocation dummy = this.preInvoke();
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                sg.start(context);
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        throw new ServiceGroupException(pae.getException());
                    }
                    finally {
                        this.postInvoke(dummy);
                    }
                    this.notifyListener(2, sg);
                    sg.setState(2);
                }
            }
        }
    }

    private ComponentInvocation preInvoke() {
        InvocationManager im = Switch.getSwitch().getInvocationManager();
        ComponentInvocation dummy = new ComponentInvocation(4);
        im.preInvoke(dummy);
        return dummy;
    }

    private void postInvoke(ComponentInvocation dummy) {
        InvocationManager im = Switch.getSwitch().getInvocationManager();
        im.postInvoke(dummy);
    }

    public void stopChildren(EntryContext context) throws ServiceGroupException {
        Iterator it = this.serviceGroupIterator();
        while (it.hasNext()) {
            ServiceGroup sg = (ServiceGroup)it.next();
            if (sg.getState() == 9 || sg.getState() == 0) continue;
            sg.stop(context);
        }
    }

    public void abortChildren(EntryContext context) {
        Iterator it = this.serviceGroupIterator();
        while (it.hasNext()) {
            ServiceGroup sg = (ServiceGroup)it.next();
            if (sg.getState() == 9) continue;
            sg.abort(context);
        }
    }

    protected void startLifecycleServices(String[][] s, ServerContext sc) {
        this.services = new ServerLifecycle[s.length];
        for (int i = 0; i < s.length; ++i) {
            try {
                ServerLifecycle slc;
                String service = s[i][1];
                this.services[i] = slc = (ServerLifecycle)Class.forName(service).newInstance();
                slc.onInitialization(sc);
                continue;
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        for (ServerLifecycle slc : this.services) {
            try {
                slc.onStartup(sc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (ServerLifecycle slc : this.services) {
            try {
                slc.onReady(sc);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    protected void stopLifecycleServices() {
        for (ServerLifecycle slc : this.services) {
            try {
                slc.onShutdown();
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        for (ServerLifecycle slc : this.services) {
            try {
                slc.onTermination();
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public abstract void start(EntryContext var1) throws ServiceGroupException;

    public abstract boolean analyseEntryContext(EntryContext var1);

    public abstract void stop(EntryContext var1) throws ServiceGroupException;

    public abstract void abort(EntryContext var1);

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    static {
        String extListener = System.getProperty("com.sun.enterprise.server.ondemand.ExternalListener");
        if (extListener != null) {
            try {
                ServiceGroupListener servicegrouplistener = (ServiceGroupListener)Class.forName(extListener).newInstance();
                listeners.add(servicegrouplistener);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

