/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.common.util.diagnostics;

import com.sun.enterprise.tools.common.util.Assertion;
import com.sun.enterprise.tools.common.util.ObjectAnalyzer;
import com.sun.enterprise.tools.common.util.diagnostics.CallerInfo;
import com.sun.enterprise.tools.common.util.diagnostics.CallerInfoException;
import com.sun.enterprise.tools.common.util.diagnostics.IReporterEnum;
import com.sun.enterprise.tools.common.util.diagnostics.ReporterWriter;
import com.sun.enterprise.tools.common.util.diagnostics.StackTrace;

public class ReporterImpl
implements IReporterEnum {
    private int severityLevel = 1000;
    private String name = "Main";
    private ReporterWriter writer;
    private String className;
    private static final boolean doDebug = false;

    public ReporterImpl() {
        this.ctor(null, -1);
    }

    ReporterImpl(int theSeverityLevel) {
        this.ctor(null, theSeverityLevel);
    }

    public ReporterImpl(String sid) {
        this.ctor(sid, -1);
    }

    ReporterImpl(String sid, int theSeverityLevel) {
        this.ctor(sid, theSeverityLevel);
    }

    public void setSeverityLevel(int level) {
        this.debug("setSeverityLevel(" + level + ")");
        if (level < 0) {
            level = 0;
        }
        this.severityLevel = level;
    }

    public void setSeverityLevel(String level) {
        this.debug("setSeverityLevel(" + level + ")");
        this.severityLevel = this.calcSeverityLevel(level);
    }

    public int getSeverityLevel() {
        return this.severityLevel;
    }

    public void setName(String theName) {
        Assertion.check(theName);
        this.name = theName;
    }

    public String getName() {
        return this.name;
    }

    public void verbose(Object o) {
        if (this.checkSeverity(1)) {
            this.pr(1, o);
        }
    }

    public void info(Object o) {
        if (this.checkSeverity(2)) {
            this.pr(2, o);
        }
    }

    public void warn(Object o) {
        if (this.checkSeverity(3)) {
            this.pr(3, o);
        }
    }

    public void warning(Object o) {
        if (this.checkSeverity(3)) {
            this.pr(3, o);
        }
    }

    public void error(Object o) {
        if (this.checkSeverity(4)) {
            this.pr(4, o);
        }
    }

    public void critical(Object o) {
        if (this.checkSeverity(5)) {
            this.pr(5, o);
        }
    }

    public void crit(Object o) {
        if (this.checkSeverity(5)) {
            this.pr(5, o);
        }
    }

    public void dump(Object o, String s) {
        if (this.checkSeverity(0) && o != null) {
            if (s == null) {
                s = "";
            }
            String s2 = s + "\n**********  Object Dump Start  ***********\n" + ObjectAnalyzer.toStringWithSuper(o) + "\n**********  Object Dump End  ***********";
            this.pr(0, s2);
        }
    }

    public void dump(String s) {
        if (this.checkSeverity(0)) {
            this.pr(0, s);
        }
    }

    public void dump(Object o) {
        this.dump(o, null);
    }

    public void assertIt(String s) {
        if (this.checkSeverity(6)) {
            try {
                Assertion.check(s);
            }
            catch (Assertion.Failure f) {
                this.pr(6, new StackTrace().toString() + f);
                throw f;
            }
        }
    }

    public void assertIt(String checkme, String s) {
        if (this.checkSeverity(6)) {
            try {
                Assertion.check(checkme, s);
            }
            catch (Assertion.Failure f) {
                this.pr(6, new StackTrace().toString() + f);
                throw f;
            }
        }
    }

    public void assertIt(boolean b) {
        if (this.checkSeverity(6)) {
            try {
                Assertion.check(b);
            }
            catch (Assertion.Failure f) {
                this.pr(6, new StackTrace().toString() + f);
                throw f;
            }
        }
    }

    public void assertIt(boolean b, String s) {
        if (this.checkSeverity(6)) {
            try {
                Assertion.check(b, s);
            }
            catch (Assertion.Failure f) {
                this.pr(6, new StackTrace().toString() + f);
                throw f;
            }
        }
    }

    public void assertIt(Object o) {
        if (this.checkSeverity(6)) {
            try {
                Assertion.check(o);
            }
            catch (Assertion.Failure f) {
                this.pr(6, new StackTrace().toString() + f);
                throw f;
            }
        }
    }

    public void assertIt(Object o, String s) {
        if (this.checkSeverity(6)) {
            try {
                Assertion.check(o, s);
            }
            catch (Assertion.Failure f) {
                this.pr(6, new StackTrace().toString() + f);
                throw f;
            }
        }
    }

    public void assertIt(double z) {
        if (this.checkSeverity(6)) {
            try {
                Assertion.check(z);
            }
            catch (Assertion.Failure f) {
                this.pr(6, new StackTrace().toString() + f);
                throw f;
            }
        }
    }

    public void assertIt(double z, String s) {
        if (this.checkSeverity(6)) {
            try {
                Assertion.check(z, s);
            }
            catch (Assertion.Failure f) {
                this.pr(6, new StackTrace().toString() + f);
                throw f;
            }
        }
    }

    public void assertIt(long l) {
        if (this.checkSeverity(6)) {
            try {
                Assertion.check(l);
            }
            catch (Assertion.Failure f) {
                this.pr(6, new StackTrace().toString() + f);
                throw f;
            }
        }
    }

    public void assertIt(long l, String s) {
        if (this.checkSeverity(6)) {
            try {
                Assertion.check(l, s);
            }
            catch (Assertion.Failure f) {
                this.pr(6, new StackTrace().toString() + f);
                throw f;
            }
        }
    }

    public ReporterWriter setWriter(ReporterWriter lwriter) {
        ReporterWriter retVal = null;
        if (null != lwriter) {
            retVal = this.writer;
            this.writer = lwriter;
        }
        return retVal;
    }

    private void ctor(String theName, int theSeverityLevel) {
        if (theName != null && theName.length() > 0) {
            this.setName(theName);
        }
        if (theSeverityLevel >= 0) {
            this.setSeverityLevel(theSeverityLevel);
        } else {
            String sl = System.getProperty("ForteReporterDebugLevel");
            if (sl != null && sl.length() > 0) {
                int sli = Integer.parseInt(sl);
                this.setSeverityLevel(sli);
            }
        }
        this.className = this.getClass().getName();
        this.writer = new ReporterWriter(this.getName());
        this.debug("Ctor called");
        this.debug("ReporterImpl Severity Level:  " + this.getSeverityLevel());
    }

    private boolean checkSeverity(int severity) {
        return severity >= this.severityLevel;
    }

    private CallerInfo getCallerInfo() {
        try {
            return new CallerInfo(new Object[]{this});
        }
        catch (CallerInfoException e) {
            this.debug(e.toString());
            return null;
        }
    }

    private void pr(int severity, Object o) {
        try {
            String s;
            CallerInfo ci = this.getCallerInfo();
            if (o == null) {
                s = "null Object argument";
            } else {
                s = o.toString();
                if (s == null) {
                    s = "null toString result from Object";
                }
            }
            if (ci != null) {
                s = ci.toString() + ": " + s;
            }
            this.writer.println(severity, s);
        }
        catch (Throwable e) {
            System.out.println("Got exception in ReporterImpl.pr():  " + e);
        }
    }

    private String getClassName() {
        Assertion.check(this.className);
        return this.className;
    }

    private int calcSeverityLevel(String original) {
        if (original == null || original.length() <= 0) {
            return 1000;
        }
        String s = original.toUpperCase();
        try {
            int ret = Integer.parseInt(s);
            if (ret < 0) {
                ret = 0;
            }
            return ret;
        }
        catch (NumberFormatException e) {
            if (s.equals("ALL") || s.equals("NOISY") || s.equals("EVERYTHING") || s.equals("ON") || s.equals("MONDO") || s.equals("YES") || s.equals("TRUE") || s.equals("DUMP") || s.startsWith("MAX")) {
                return 0;
            }
            if (s.startsWith("NO") || s.equals("OFF") || s.equals("FALSE") || s.equals("QUIET") || s.startsWith("MIN")) {
                return 1000;
            }
            char first = s.charAt(0);
            for (int i = 0; i < severityNames.length; ++i) {
                if (severityNames[i].toUpperCase().charAt(0) != first) continue;
                return i;
            }
            this.debug("Unknown value for commandline argument \"-DIABDebug=" + original + "\"");
            return 1000;
        }
    }

    private void debug(String s) {
    }
}

