/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.ejb;

import com.sun.ejb.codegen.GeneratorException;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.IASEjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.io.EjbDeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.EjbBundleValidator;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.tools.verifier.CheckMgr;
import com.sun.enterprise.tools.verifier.FrameworkContext;
import com.sun.enterprise.tools.verifier.JarCheck;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.TestInformation;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.dd.ParseDD;
import com.sun.enterprise.tools.verifier.wsclient.WebServiceClientCheckMgrImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.JDOCodeGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.util.Iterator;
import java.util.Set;

public class EjbCheckMgrImpl
extends CheckMgr
implements JarCheck {
    private static final String testsListFileName = "TestNamesEjb.xml";
    private static final String sunONETestsListFileName = EjbCheckMgrImpl.getSunPrefix().concat("TestNamesEjb.xml");
    private JDOCodeGenerator jdc = new JDOCodeGenerator();

    public EjbCheckMgrImpl(FrameworkContext frameworkContext) {
        this.frameworkContext = frameworkContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(Descriptor descriptor) throws Exception {
        this.checkPersistenceUnits((RootDeploymentDescriptor)EjbBundleDescriptor.class.cast(descriptor));
        this.checkWebServices(descriptor);
        this.checkWebServicesClient(descriptor);
        if (this.frameworkContext.isPartition() && !this.frameworkContext.isEjb()) {
            return;
        }
        EjbBundleDescriptor bundleDescriptor = (EjbBundleDescriptor)descriptor;
        this.setDescClassLoader(bundleDescriptor);
        try {
            EjbBundleValidator validator = new EjbBundleValidator();
            validator.accept(bundleDescriptor);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (bundleDescriptor.containsCMPEntity()) {
            try {
                this.jdc.init(bundleDescriptor, this.context.getClassLoader(), this.getAbstractArchiveUri(bundleDescriptor), this.frameworkContext.isPortabilityMode());
            }
            catch (Throwable ex) {
                this.context.setJDOException(ex);
            }
        }
        this.context.setJDOCodeGenerator(this.jdc);
        if (bundleDescriptor.getSpecVersion().compareTo("2.1") < 0) {
            EjbDeploymentDescriptorFile ddf = new EjbDeploymentDescriptorFile();
            File file = new File(this.getAbstractArchiveUri(bundleDescriptor), ddf.getDeploymentDescriptorPath());
            FileInputStream is = new FileInputStream(file);
            try {
                if (is != null) {
                    Result result = new ParseDD().validateEJBDescriptor(is);
                    result.setComponentName(new File(bundleDescriptor.getModuleDescriptor().getArchiveUri()).getName());
                    this.setModuleName(result);
                    this.frameworkContext.getResultManager().add(result);
                }
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        for (EjbDescriptor ejbDescriptor : bundleDescriptor.getEjbs()) {
            super.check(ejbDescriptor);
        }
        if (bundleDescriptor.containsCMPEntity() && this.context.getJDOException() == null) {
            try {
                this.jdc.cleanup();
            }
            catch (GeneratorException generatorException) {
                // empty catch block
            }
            this.context.setJDOCodeGenerator(null);
        }
    }

    protected String getTestsListFileName() {
        return testsListFileName;
    }

    protected String getSunONETestsListFileName() {
        return sunONETestsListFileName;
    }

    protected void checkWebServicesClient(Descriptor descriptor) throws Exception {
        if (this.frameworkContext.isPartition() && !this.frameworkContext.isWebServicesClient()) {
            return;
        }
        EjbBundleDescriptor desc = (EjbBundleDescriptor)descriptor;
        WebServiceClientCheckMgrImpl webServiceClientCheckMgr = new WebServiceClientCheckMgrImpl(this.frameworkContext);
        if (desc.hasWebServiceClients()) {
            Set ejbdescs = desc.getEjbs();
            for (EjbDescriptor ejbDesc : ejbdescs) {
                this.context.setEjbDescriptorForServiceRef(ejbDesc);
                Set<ServiceReferenceDescriptor> serviceRefDescriptors = ejbDesc.getServiceReferenceDescriptors();
                Iterator<ServiceReferenceDescriptor> it = serviceRefDescriptors.iterator();
                while (it.hasNext()) {
                    webServiceClientCheckMgr.setVerifierContext(this.context);
                    webServiceClientCheckMgr.check(it.next());
                }
            }
            this.context.setEjbDescriptorForServiceRef(null);
        }
    }

    protected String getSchemaVersion(Descriptor descriptor) {
        return this.getBundleDescriptor(descriptor).getSpecVersion();
    }

    protected void setModuleName(Result r) {
        r.setModuleName("ejb");
    }

    protected EjbBundleDescriptor getBundleDescriptor(Descriptor descriptor) {
        return ((EjbDescriptor)descriptor).getEjbBundleDescriptor();
    }

    protected boolean isApplicable(TestInformation test, Descriptor descriptor) {
        String testName = test.getClassName();
        if (descriptor instanceof EjbSessionDescriptor && (testName.indexOf("tests.ejb.entity") >= 0 || testName.indexOf("tests.ejb.messagebean") >= 0)) {
            return false;
        }
        if (descriptor instanceof EjbEntityDescriptor && (testName.indexOf("tests.ejb.session") >= 0 || testName.indexOf("tests.ejb.messagebean") >= 0)) {
            return false;
        }
        return !(descriptor instanceof EjbMessageBeanDescriptor) || testName.indexOf("tests.ejb.session") < 0 && testName.indexOf("tests.ejb.entity") < 0;
    }

    private String getAbstractArchiveUri(EjbBundleDescriptor desc) {
        String archBase = this.context.getAbstractArchive().getArchiveUri();
        ModuleDescriptor mdesc = desc.getModuleDescriptor();
        if (mdesc.isStandalone()) {
            return archBase;
        }
        return archBase + File.separator + FileUtils.makeFriendlyFileName(mdesc.getArchiveUri());
    }

    private void setDescClassLoader(EjbBundleDescriptor bundleDescriptor) {
        for (EjbDescriptor descriptor : bundleDescriptor.getEjbs()) {
            if (!(descriptor instanceof IASEjbCMPEntityDescriptor)) continue;
            ((IASEjbCMPEntityDescriptor)descriptor).setClassLoader(this.context.getClassLoader());
        }
    }

    protected ComponentNameConstructor getComponentNameConstructor(Descriptor descriptor) {
        return new ComponentNameConstructor((EjbDescriptor)descriptor);
    }
}

