/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.VerifierCheck;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InjectionTargetTest
extends VerifierTest
implements VerifierCheck {
    private Descriptor descriptor;
    Result result;
    ComponentNameConstructor compName;

    protected abstract List<InjectionCapable> getInjectables(String var1);

    protected abstract String getClassName();

    @Override
    public Result check(Descriptor descriptor) {
        this.descriptor = descriptor;
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        ClassLoader cl = this.getVerifierContext().getClassLoader();
        List<InjectionCapable> injectables = this.getInjectables(this.getClassName());
        for (InjectionCapable injectionCapable : injectables) {
            Set<InjectionTarget> iTargets = injectionCapable.getInjectionTargets();
            for (InjectionTarget target : iTargets) {
                try {
                    Method method;
                    Class<?> classObj;
                    if (target.isFieldInjectable()) {
                        classObj = Class.forName(this.getClassName(), false, cl);
                        Field field = classObj.getDeclaredField(target.getFieldName());
                        this.testMethodModifiers(field.getModifiers(), "field", field);
                    }
                    if (!target.isMethodInjectable() || (method = this.getInjectedMethod(classObj = Class.forName(this.getClassName(), false, cl), target.getMethodName())) == null) continue;
                    this.testMethodModifiers(method.getModifiers(), "method", method);
                }
                catch (Exception e) {}
            }
        }
        if (this.result.getStatus() != 1) {
            this.addGoodDetails(this.result, this.compName);
            this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Valid injection method(s)."));
        }
        return this.result;
    }

    protected Descriptor getDescriptor() {
        return this.descriptor;
    }

    private void testMethodModifiers(int modifier, String targetType, Object fieldOrMethod) {
        if (Modifier.isStatic(modifier) || Modifier.isFinal(modifier)) {
            this.addErrorDetails(this.result, this.compName);
            this.result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.InjectionTargetTest.failed", "Invalid annotation in {0} [ {1} ].", new Object[]{targetType, fieldOrMethod}));
        }
    }

    private Method getInjectedMethod(Class classObj, String methodName) {
        for (Method method : classObj.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }
}

