/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;

public class TransactionSupport
extends ConnectorTest
implements ConnectorCheck {
    private final String[] acceptableValues = new String[]{"NoTransaction", "LocalTransaction", "XATransaction"};

    public Result check(ConnectorDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (!descriptor.getOutBoundDefined()) {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.managed.notApplicableForInboundRA", "Resource Adapter does not provide outbound communication"));
            return result;
        }
        String connectorTransactionSupport = descriptor.getOutboundResourceAdapter().getTransSupport();
        if (connectorTransactionSupport == null) {
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".nonexist", "Error: No Transaction support specified for ressource adapter", new Object[]{connectorTransactionSupport}));
            return result;
        }
        for (int i = 0; i < this.acceptableValues.length; ++i) {
            if (!connectorTransactionSupport.equals(this.acceptableValues[i])) continue;
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Transaction support [ {0} ] for ressource adapter is supported", new Object[]{connectorTransactionSupport}));
            return result;
        }
        result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
        result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: Deployment descriptor transaction-support [ {0} ] for ressource adapter is not valid", new Object[]{connectorTransactionSupport}));
        return result;
    }
}

