/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector.cci;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.tests.connector.cci.ConnectionFactoryTest;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;

public class InteractionSpecJavaBeansCompliance
extends ConnectionFactoryTest
implements ConnectorCheck {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result check(ConnectorDescriptor descriptor) {
        boolean oneFailed = false;
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (!this.isCCIImplemented(descriptor, result)) {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.cci.InteractionExistence.notapp", "NotApplicable : The CCI interfaces do not seem to be implemented by this resource adapter"));
            return result;
        }
        Class mcf = this.findImplementorOf(descriptor, "javax.resource.cci.InteractionSpec");
        if (mcf == null) {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".nonexist", "Error: While the CCI interfaces are implemented, the javax.resource.cci.InteractionSpec is not"));
            return result;
        }
        try {
            BeanInfo bi = Introspector.getBeanInfo(mcf, Object.class);
            PropertyDescriptor[] properties = bi.getPropertyDescriptors();
            for (int i = 0; i < properties.length; ++i) {
                if (properties[i].getReadMethod() == null || properties[i].getWriteMethod() == null) {
                    oneFailed = true;
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: The javax.resource.cci.InteractionSpec implementation [ {0} ] of the property [ {1} ] is not JavaBeans compliant", new Object[]{mcf.getName(), properties[i].getName()}));
                }
                if (properties[i].isConstrained() || properties[i].isBound()) continue;
                oneFailed = true;
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "Error: The property [ {0} ] of the javax.resource.cci.InteractionSpec implementation [ {1} ] is not bound or constrained", new Object[]{properties[i].getName(), mcf.getName()}));
            }
        }
        catch (IntrospectionException ie) {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".failed", "Error: The javax.resource.cci.InteractionSpec implementation [ {0} ] is not JavaBeans compliant", new Object[]{mcf.getName()}));
            return result;
        }
        if (!oneFailed) {
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "The javax.resource.cci.InteractionSpec implementation is JavaBeans compliant"));
        }
        return result;
    }
}

