/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.beanclass;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;

public class EjbClassExposed
extends EjbTest {
    Result result = null;
    ComponentNameConstructor compName = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
            if (descriptor.getRemoteClassName() != null && !descriptor.getRemoteClassName().equals("")) {
                this.commonToBothInterfaces(descriptor.getRemoteClassName(), descriptor);
            }
            if (descriptor.getLocalClassName() != null && !descriptor.getLocalClassName().equals("")) {
                this.commonToBothInterfaces(descriptor.getLocalClassName(), descriptor);
            }
        }
        if (this.result.getStatus() != 1) {
            this.addGoodDetails(this.result, this.compName);
            this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Ejb Bean Class [{0}] is valid.", new Object[]{descriptor.getEjbClassName()}));
        }
        return this.result;
    }

    private void commonToBothInterfaces(String remote, EjbDescriptor descriptor) {
        try {
            Class<?> c = Class.forName(remote, false, this.getVerifierContext().getClassLoader());
            for (Method method : c.getDeclaredMethods()) {
                String ejbClassName = descriptor.getEjbClassName();
                if (!method.getReturnType().getName().equals(ejbClassName)) continue;
                this.addErrorDetails(this.result, this.compName);
                this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: Ejb Bean Class [{0}] is exposed through interface [{1}]", new Object[]{ejbClassName, remote}));
            }
        }
        catch (ClassNotFoundException e) {
            this.addErrorDetails(this.result, this.compName);
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: interface class [{0}] not found", new Object[]{remote}));
        }
    }
}

