/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.ejb30;

import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ejb.MethodUtils;
import com.sun.enterprise.tools.verifier.tests.ejb.ejb30.MessageBeanTest;
import java.lang.reflect.Method;

public class MDBImplementsListenerMethods
extends MessageBeanTest {
    public Result check(EjbMessageBeanDescriptor descriptor) {
        try {
            ClassLoader cl = this.getVerifierContext().getClassLoader();
            Class<?> intfCls = Class.forName(descriptor.getMessageListenerType(), false, cl);
            Class<?> ejbCls = Class.forName(descriptor.getEjbClassName(), false, cl);
            if (!intfCls.isAssignableFrom(ejbCls)) {
                Method[] methods;
                for (Method method : methods = intfCls.getMethods()) {
                    boolean foundOne = false;
                    for (Method ejbMethod : ejbCls.getMethods()) {
                        if (!MethodUtils.methodEquals(ejbMethod, method)) continue;
                        foundOne = true;
                        break;
                    }
                    if (foundOne) continue;
                    this.addErrorDetails(this.result, this.compName);
                    this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Message bean [ {0} ] neither implements listener interface [ {1} ] nor implements listener interface method [ {2} ]", new Object[]{ejbCls.getSimpleName(), intfCls.getName(), method}));
                }
            }
        }
        catch (ClassNotFoundException e) {
            this.logger.fine(descriptor.getEjbClassName() + " Not found");
        }
        if (this.result.getStatus() != 1) {
            this.addGoodDetails(this.result, this.compName);
            this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Valid Message bean [ {0} ]", new Object[]{descriptor.getEjbClassName()}));
        }
        return this.result;
    }
}

