/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp;

import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class CmpFieldsTransient
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbEntityDescriptor) {
            String persistence = ((EjbEntityDescriptor)descriptor).getPersistenceType();
            if ("Container".equals(persistence)) {
                if (1 != ((EjbCMPEntityDescriptor)descriptor).getCMPVersion()) {
                    result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest.notApplicable3", "Test do not apply to this cmp-version of container managed persistence EJBs"));
                    return result;
                }
                boolean oneFailed = false;
                boolean badField = false;
                for (FieldDescriptor nextPersistentField : ((EjbCMPEntityDescriptor)descriptor).getPersistenceDescriptor().getCMPFields()) {
                    badField = false;
                    boolean foundField = false;
                    Class<?> c1 = null;
                    try {
                        Class<?> c = Class.forName(((EjbEntityDescriptor)descriptor).getEjbClassName(), false, this.getVerifierContext().getClassLoader());
                        do {
                            try {
                                c1 = c;
                                Field f = c.getDeclaredField(nextPersistentField.getName());
                                foundField = true;
                                int modifiers = f.getModifiers();
                                if (!Modifier.isTransient(modifiers)) continue;
                                if (!oneFailed) {
                                    oneFailed = true;
                                }
                                if (!(badField = true)) continue;
                                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: Field [ {0} ] defined within entity bean class [ {1} ] is defined as transient.  Container managed field must not be defined in the entity bean class as transient.", new Object[]{nextPersistentField.getName(), c.getName()}));
                            }
                            catch (NoSuchFieldException e) {
                                foundField = false;
                            }
                        } while ((c = c.getSuperclass()) != null && !foundField);
                        if (!foundField) {
                            if (!oneFailed) {
                                oneFailed = true;
                            }
                            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                            result.failed(smh.getLocalString(this.getClass().getName() + ".failedException1", "Error: [ {0} ] field not found within class [ {1} ]", new Object[]{nextPersistentField.getName(), ((EjbEntityDescriptor)descriptor).getEjbClassName()}));
                        }
                    }
                    catch (ClassNotFoundException e) {
                        Verifier.debug(e);
                        if (!oneFailed) {
                            oneFailed = true;
                        }
                        result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: [ {0} ] class not found.", new Object[]{((EjbEntityDescriptor)descriptor).getEjbClassName()}));
                    }
                    if (oneFailed) continue;
                    result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "This entity bean class [ {0} ] has defined [ {1} ] container managed field as non-transient field.", new Object[]{c1.getName(), nextPersistentField.getName()}));
                }
                if (oneFailed) {
                    result.setStatus(1);
                } else {
                    result.setStatus(0);
                }
                return result;
            }
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "Expected [ {0} ] managed persistence, but [ {1} ] bean has [ {2} ] managed persistence.", new Object[]{"Container", descriptor.getName(), persistence}));
            return result;
        }
        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "{0} expected {1} bean, but called with {2}.", new Object[]{this.getClass(), "Entity", "Session"}));
        return result;
    }
}

