/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.runtime;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;

public class ASEjbIORSecurityConfig
extends EjbTest
implements EjbCheck {
    boolean oneFailed = false;

    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        int count = 0;
        try {
            count = this.getCountNodeSet("sun-ejb-jar/enterprise-beans/ejb[ejb-name=\"" + descriptor.getName() + "\"]/ior-security-config");
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    this.testTranConfig(i, descriptor, compName, result);
                    this.testAsContext(i, descriptor, compName, result);
                    this.testSasContext(i, descriptor, compName, result);
                }
            } else {
                this.addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-EJB ior-security-config] : ior-security-config Element not defined"));
            }
            if (this.oneFailed) {
                result.setStatus(1);
            }
        }
        catch (Exception ex) {
            this.addErrorDetails(result, compName);
            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".notRun", "NOT RUN [AS-EJB] : Could not create a descriptor object"));
        }
        return result;
    }

    protected void testTranConfig(int i, EjbDescriptor descriptor, ComponentNameConstructor compName, Result result) {
        try {
            int counter = this.getCountNodeSet("sun-ejb-jar/enterprise-beans/ejb[ejb-name=\"" + descriptor.getName() + "\"]/ior-security-config/transport-config");
            if (counter > 0) {
                String trustClient;
                String trustTarget;
                String confdn;
                String integrity = this.getXPathValue("sun-ejb-jar/enterprise-beans/ejb[ejb-name=\"" + descriptor.getName() + "\"]/ior-security-config[\"" + i + "\"]/transport-config/integrity");
                if (integrity != null) {
                    this.testMsgs(integrity, result, "transport-config", "integrity", compName);
                }
                if ((confdn = this.getXPathValue("sun-ejb-jar/enterprise-beans/ejb[ejb-name=\"" + descriptor.getName() + "\"]/ior-security-config[\"" + i + "\"]/transport-config/confidentiality")) != null) {
                    this.testMsgs(confdn, result, "transport-config", "confidentiality", compName);
                }
                if ((trustTarget = this.getXPathValue("sun-ejb-jar/enterprise-beans/ejb[ejb-name=\"" + descriptor.getName() + "\"]/ior-security-config[\"" + i + "\"]/transport-config/establish-trust-in-target")) != null) {
                    this.testMsgs1(trustTarget, result, "transport-config", "extablish-trust-in-target", compName);
                }
                if ((trustClient = this.getXPathValue("sun-ejb-jar/enterprise-beans/ejb[ejb-name=\"" + descriptor.getName() + "\"]/ior-security-config[\"" + i + "\"]/transport-config/establish-trust-in-client")) != null) {
                    this.testMsgs(trustClient, result, "transport-config", "establish-trust-in-client", compName);
                }
            } else {
                this.addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "NOT APPLICABLE [AS-EJB ior-security-config] : transport-config Element not defined"));
            }
        }
        catch (Exception ex) {
            this.oneFailed = true;
            this.addErrorDetails(result, compName);
            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".notRun", "NOT RUN [AS-EJB] : Could not create a descriptor object"));
        }
    }

    protected void testAsContext(int i, EjbDescriptor descriptor, ComponentNameConstructor compName, Result result) {
        try {
            int counter = this.getCountNodeSet("sun-ejb-jar/enterprise-beans/ejb[ejb-name=\"" + descriptor.getName() + "\"]/ior-security-config/as-context");
            if (counter > 0) {
                String value = this.getXPathValue("sun-ejb-jar/enterprise-beans/ejb[ejb-name=\"" + descriptor.getName() + "\"]/ior-security-config[\"" + i + "\"]/as-context/auth-method");
                if (value == null || value.length() == 0) {
                    this.oneFailed = true;
                    this.addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failedAsContextAuthMethod", "FAILED [AS-EJB as-context] : auth-method cannot be an empty string"));
                } else if (value.equals("USERNAME_PASSWORD")) {
                    this.addGoodDetails(result, compName);
                    result.passed(smh.getLocalString(this.getClass().getName() + ".passedAsContextAuthMethod", "PASSED [AS-EJB as-context] : auth-method is {0}", new Object[]{value}));
                } else {
                    this.oneFailed = true;
                    this.addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failedAsContextAuthMethod1", "FAILED [AS-EJB as-context] : auth-method cannot be {0}. It can only be USERNAME_PASSWORD", new Object[]{value}));
                }
                value = this.getXPathValue("sun-ejb-jar/enterprise-beans/ejb[ejb-name=\"" + descriptor.getName() + "\"]/ior-security-config[\"" + i + "\"]/as-context/realm");
                if (value != null) {
                    if (value.length() == 0) {
                        this.oneFailed = true;
                        this.addErrorDetails(result, compName);
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failedAsContextRealm", "FAILED [AS-EJB as-context] : realm cannot be an empty string"));
                    } else {
                        this.addGoodDetails(result, compName);
                        result.passed(smh.getLocalString(this.getClass().getName() + ".passedAsContextRealm", "PASSED [AS-EJB as-context] : realm is {0}", new Object[]{value}));
                    }
                } else {
                    this.oneFailed = true;
                    this.addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failedAsContextRealm1", "FAILED [AS-EJB as-context] : realm cannot be null"));
                }
                value = this.getXPathValue("sun-ejb-jar/enterprise-beans/ejb[ejb-name=\"" + descriptor.getName() + "\"]/ior-security-config[\"" + i + "\"]/as-context/required");
                if (value == null || value.length() == 0) {
                    this.oneFailed = true;
                    this.addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failedAsContextRequired1", "FAILED [AS-EJB as-context] : required cannot be an empty string"));
                } else if (value.equals("true") || value.equals("false")) {
                    this.addGoodDetails(result, compName);
                    result.passed(smh.getLocalString(this.getClass().getName() + ".passedAsContextRequired", "PASSED [AS-EJB as-context] : required is {0}", new Object[]{new Boolean(value)}));
                } else {
                    this.oneFailed = true;
                    this.addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failedAsContextRequired2", "FAILED [AS-EJB as-context] : required cannot be {0}. It can only be USERNAME_PASSWORD", new Object[]{value}));
                }
            } else {
                this.addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable2", "NOT APPLICABLE [AS-EJB ior-security-config] :  Element not defined"));
            }
        }
        catch (Exception ex) {
            this.oneFailed = true;
            this.addErrorDetails(result, compName);
            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".notRun", "NOT RUN [AS-EJB] : Could not create a descriptor object"));
        }
    }

    protected void testSasContext(int i, EjbDescriptor descriptor, ComponentNameConstructor compName, Result result) {
        try {
            String caller;
            int counter = this.getCountNodeSet("sun-ejb-jar/enterprise-beans/ejb[ejb-name=\"" + descriptor.getName() + "\"]/ior-security-config/sas-context");
            if (counter > 0 && (caller = this.getXPathValue("sun-ejb-jar/enterprise-beans/ejb[ejb-name=\"" + descriptor.getName() + "\"]/ior-security-config[\"" + i + "\"]/sas-context/caller-propagation")) != null) {
                this.testMsgs1(caller, result, "sas-context", "caller-propagation", compName);
            }
        }
        catch (Exception ex) {
            this.oneFailed = true;
            this.addErrorDetails(result, compName);
            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".notRun", "NOT RUN [AS-EJB] : Could not create a descriptor object"));
        }
    }

    private void testMsgs(String tCase, Result result, String parentElement, String testElement, ComponentNameConstructor compName) {
        if (tCase.length() == 0) {
            this.oneFailed = true;
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failedTestMsg", "FAILED [AS-EJB {1}] : {2} cannot be an empty String", new Object[]{tCase, parentElement, testElement}));
        } else if (!(tCase.equals("NONE") || tCase.equals("SUPPORTED") || tCase.equals("REQUIRED"))) {
            this.oneFailed = true;
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failedTestMsg1", "FAILED [AS-EJB {1}] : {2} cannot be {0}. It can be either NONE, SUPPORTED or REQUIRED", new Object[]{tCase, parentElement, testElement}));
        } else {
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passedTestMsg", "PASSED [AS-EJB " + parentElement + "] : " + testElement + " is {0}", new Object[]{tCase}));
        }
    }

    private void testMsgs1(String tCase, Result result, String parentElement, String testElement, ComponentNameConstructor compName) {
        if (tCase.length() == 0) {
            this.oneFailed = true;
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failedTestMsg", "FAILED [AS-EJB {1}] : {2} cannot be an empty String", new Object[]{tCase, parentElement, testElement}));
        } else if (!tCase.equals("NONE") && !tCase.equals("SUPPORTED")) {
            this.oneFailed = true;
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failedTestMsg2", "FAILED [AS-EJB {1}] : {2} cannot be {0}. It can be either NONE or SUPPORTED.", new Object[]{tCase, parentElement, testElement}));
        } else {
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passedTestMsg", "PASSED [AS-EJB " + parentElement + "] : " + testElement + " is {0}", new Object[]{tCase}));
        }
    }
}

