/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session.stateless;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;

public class StatelessCreateOnlyOne
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;

    public Result check(EjbDescriptor descriptor) {
        String stateType;
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbSessionDescriptor && "Stateless".equals(stateType = ((EjbSessionDescriptor)descriptor).getSessionType())) {
            if (descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName())) {
                this.commonToBothInterfaces(descriptor.getHomeClassName(), (EjbSessionDescriptor)descriptor);
            }
            if (descriptor.getLocalHomeClassName() != null && !"".equals(descriptor.getLocalHomeClassName())) {
                this.commonToBothInterfaces(descriptor.getLocalHomeClassName(), (EjbSessionDescriptor)descriptor);
            }
        }
        if (this.result.getStatus() != 1) {
            this.addGoodDetails(this.result, this.compName);
            this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "The bean's Home Interface has exactly one create Method defined"));
        }
        return this.result;
    }

    private void commonToBothInterfaces(String home, EjbSessionDescriptor descriptor) {
        try {
            int count = 0;
            Class<?> c = Class.forName(home, false, this.getVerifierContext().getClassLoader());
            for (Method methods : c.getDeclaredMethods()) {
                if (!methods.getName().equals("create")) continue;
                ++count;
            }
            if (count != 1) {
                this.addErrorDetails(this.result, this.compName);
                this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] Create methods exists within bean [ {1} ]. The home interface must have only one create method for stateless session bean.", new Object[]{new Integer(count), home}));
            }
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Class [ {0} ] not found within bean [ {1} ]", new Object[]{home, descriptor.getName()}));
        }
    }
}

