/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.web.ListenerClass;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.logging.Level;

public class ListenerClassHasValidConstructor
extends ListenerClass
implements WebCheck {
    protected boolean runIndividualListenerTest(Result result, Class listenerClass) {
        boolean validConstructor = false;
        boolean foundIt = false;
        if (listenerClass == null) {
            return false;
        }
        block0: do {
            Constructor<?>[] constructors = listenerClass.getDeclaredConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                this.logger.log(Level.FINE, this.getClass().getName() + ".debug", new Object[]{constructors[i].toString()});
                Class<?>[] parameters = constructors[i].getParameterTypes();
                if (parameters.length != 0) continue;
                validConstructor = Modifier.isPublic(constructors[i].getModifiers());
                foundIt = true;
                continue block0;
            }
        } while (!foundIt && (listenerClass = listenerClass.getSuperclass()) != null);
        if (validConstructor) {
            result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "Listener class [ {0} ] implements a valid constructor.", new Object[]{listenerClass.getName()}));
        } else {
            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: Listener class [ {0} ] does not implement a valid constructor.", new Object[]{listenerClass.getName()}));
        }
        return validConstructor;
    }
}

