/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import java.text.MessageFormat;
import java.util.ResourceBundle;

public class LocalStringsImpl {
    private ResourceBundle bundle;
    private static final String thisPackage = "com.sun.enterprise.util";
    private String propsFilename = "LocalStrings";

    public LocalStringsImpl() {
        this.setBundle();
    }

    public LocalStringsImpl(Class clazz) {
        this.setBundle(clazz);
    }

    public String get(String indexString) {
        try {
            return this.getBundle().getString(indexString);
        }
        catch (Exception e) {
            return indexString;
        }
    }

    public String get(String indexString, Object ... objects) {
        indexString = this.get(indexString);
        try {
            MessageFormat mf = new MessageFormat(indexString);
            return mf.format(objects);
        }
        catch (Exception e) {
            return indexString;
        }
    }

    public String getString(String indexString, String defaultValue) {
        try {
            return this.getBundle().getString(indexString);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int getInt(String indexString, int defaultValue) {
        try {
            String s = this.getBundle().getString(indexString);
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String indexString, boolean defaultValue) {
        try {
            return Boolean.valueOf(this.getBundle().getString(indexString));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private ResourceBundle getBundle() {
        return this.bundle;
    }

    private void setBundle() {
        try {
            StackTraceElement[] items = Thread.currentThread().getStackTrace();
            int lastMeOnStack = -1;
            for (int i = 0; i < items.length; ++i) {
                StackTraceElement item = items[i];
                if (!item.getClassName().startsWith(thisPackage)) continue;
                lastMeOnStack = i;
            }
            String className = items[lastMeOnStack + 1].getClassName();
            this.setBundle(className);
        }
        catch (Exception e) {
            this.bundle = null;
        }
    }

    private void setBundle(Class clazz) {
        this.setBundle(clazz.getName());
    }

    private void setBundle(String className) {
        try {
            String props = className.indexOf(46) < 0 ? this.propsFilename : className.substring(0, className.lastIndexOf(46)) + '.' + this.propsFilename;
            this.bundle = ResourceBundle.getBundle(props);
        }
        catch (Exception e) {
            this.bundle = null;
        }
    }
}

