/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.handlers;

import com.sun.enterprise.web.connector.grizzly.Constants;
import com.sun.enterprise.web.connector.grizzly.FileCache;
import com.sun.enterprise.web.connector.grizzly.FileCacheFactory;
import com.sun.enterprise.web.connector.grizzly.Handler;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.coyote.tomcat5.CoyoteConnector;
import org.apache.coyote.tomcat5.CoyoteRequest;
import org.apache.tomcat.util.buf.Ascii;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoParsingHandler
implements Handler<Request> {
    private SocketChannel socketChannel;
    protected FileCache fileCache;

    @Override
    public void attachChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
        if (this.fileCache == null && socketChannel != null) {
            this.fileCache = FileCacheFactory.getFactory(socketChannel.socket().getLocalPort()).getFileCache();
        }
    }

    @Override
    public int handle(Request request, int handlerCode) throws IOException {
        ByteChunk bc;
        if (this.socketChannel == null || !FileCacheFactory.isEnabled()) {
            return 0;
        }
        if (this.fileCache == null && handlerCode != 1) {
            return 0;
        }
        if (handlerCode == 1) {
            CoyoteRequest cr = (CoyoteRequest)request.getNote(1);
            if (cr != null && cr.getWrapper() != null) {
                String mappedServlet = cr.getWrapper().getName();
                if (!mappedServlet.equals("default")) {
                    return 0;
                }
                if (cr.getContext().findConstraints().length == 0 && cr.getContext().findFilterDefs().length == 0) {
                    if (!this.fileCache.isEnabled()) {
                        return 0;
                    }
                    String docroot = cr.getContextPath().equals("") ? cr.getContext().getDocBase() : SelectorThread.getWebAppRootPath();
                    String requestURI = cr.getRequestURI();
                    Response response = cr.getCoyoteRequest().getResponse();
                    MimeHeaders headers = response.getMimeHeaders();
                    boolean xPoweredBy = ((CoyoteConnector)cr.getConnector()).isXpoweredBy();
                    this.fileCache.add(mappedServlet, docroot, requestURI, headers, xPoweredBy);
                }
            }
        } else if (handlerCode == 0 && this.fileCache.sendCache((bc = request.requestURI().getByteChunk()).getBytes(), bc.getStart(), bc.getLength(), this.socketChannel, this.keepAlive(request))) {
            return 1;
        }
        return 0;
    }

    private boolean keepAlive(Request request) {
        MimeHeaders headers = request.getMimeHeaders();
        MessageBytes connectionValueMB = headers.getValue("connection");
        if (connectionValueMB != null) {
            ByteChunk connectionValueBC = connectionValueMB.getByteChunk();
            if (this.findBytes(connectionValueBC, Constants.CLOSE_BYTES) != -1) {
                return false;
            }
            if (this.findBytes(connectionValueBC, Constants.KEEPALIVE_BYTES) != -1) {
                return true;
            }
        }
        return true;
    }

    protected int findBytes(ByteChunk bc, byte[] b) {
        byte first = b[0];
        byte[] buff = bc.getBuffer();
        int start = bc.getStart();
        int end = bc.getEnd();
        int srcEnd = b.length;
        for (int i = start; i <= end - srcEnd; ++i) {
            if (Ascii.toLower(buff[i]) != first) continue;
            int myPos = i + 1;
            int srcPos = 1;
            while (srcPos < srcEnd && Ascii.toLower(buff[myPos++]) == b[srcPos++]) {
                if (srcPos != srcEnd) continue;
                return i - start;
            }
        }
        return -1;
    }
}

