/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.reconfig;

import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.http.HSAccessLogEvent;
import com.sun.enterprise.admin.event.http.HSAccessLogEventListener;
import com.sun.enterprise.admin.event.http.HSConnectionPoolEvent;
import com.sun.enterprise.admin.event.http.HSConnectionPoolEventListener;
import com.sun.enterprise.admin.event.http.HSHttpFileCacheEvent;
import com.sun.enterprise.admin.event.http.HSHttpFileCacheEventListener;
import com.sun.enterprise.admin.event.http.HSHttpListenerEvent;
import com.sun.enterprise.admin.event.http.HSHttpListenerEventListener;
import com.sun.enterprise.admin.event.http.HSHttpProtocolEvent;
import com.sun.enterprise.admin.event.http.HSHttpProtocolEventListener;
import com.sun.enterprise.admin.event.http.HSKeepAliveEvent;
import com.sun.enterprise.admin.event.http.HSKeepAliveEventListener;
import com.sun.enterprise.admin.event.http.HSRequestProcessingEvent;
import com.sun.enterprise.admin.event.http.HSRequestProcessingEventListener;
import com.sun.enterprise.admin.event.http.HSServiceEvent;
import com.sun.enterprise.admin.event.http.HSServiceEventListener;
import com.sun.enterprise.admin.event.http.HSVirtualServerEvent;
import com.sun.enterprise.admin.event.http.HSVirtualServerEventListener;
import com.sun.enterprise.config.ConfigAdd;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigChange;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.web.PEWebContainer;
import java.util.ArrayList;

public class ReconfigListener
implements HSAccessLogEventListener,
HSHttpListenerEventListener,
HSServiceEventListener,
HSVirtualServerEventListener,
HSHttpProtocolEventListener,
HSHttpFileCacheEventListener,
HSConnectionPoolEventListener,
HSKeepAliveEventListener,
HSRequestProcessingEventListener {
    private PEWebContainer webContainer;

    public ReconfigListener(PEWebContainer webContainer) {
        this.webContainer = webContainer;
    }

    public void handleDelete(HSAccessLogEvent event) throws AdminEventListenerException {
    }

    public void handleUpdate(HSAccessLogEvent event) throws AdminEventListenerException {
        if (this.webContainer == null || event == null) {
            return;
        }
        try {
            ConfigContext configContext = event.getConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
            if (config == null) {
                return;
            }
            this.webContainer.updateAccessLog(config.getHttpService());
        }
        catch (Exception e) {
            throw new AdminEventListenerException(e);
        }
    }

    public void handleCreate(HSAccessLogEvent event) throws AdminEventListenerException {
    }

    public void handleCreate(HSHttpListenerEvent event) throws AdminEventListenerException {
        if (this.webContainer == null || event == null) {
            return;
        }
        try {
            ConfigContext configContext = event.getConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
            if (config == null) {
                return;
            }
            ConfigAdd configAdd = null;
            ArrayList configChangeList = event.getConfigChangeList();
            HttpListener httpBean = null;
            String xpath = null;
            for (int i = 0; i < configChangeList.size(); ++i) {
                ConfigBean object;
                Object configObject = configChangeList.get(i);
                if (!(configObject instanceof ConfigAdd) || (xpath = (configAdd = (ConfigAdd)configObject).getXPath()) == null || !((object = configContext.exactLookup(xpath)) instanceof HttpListener)) continue;
                httpBean = (HttpListener)object;
                this.webContainer.createConnector(httpBean, config.getHttpService());
            }
        }
        catch (Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }

    public void handleUpdate(HSHttpListenerEvent event) throws AdminEventListenerException {
        if (this.webContainer == null || event == null) {
            return;
        }
        try {
            ConfigContext configContext = event.getConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
            if (config == null) {
                return;
            }
            ConfigChange configChange = null;
            ArrayList configChangeList = event.getConfigChangeList();
            HttpListener httpBean = null;
            String xpath = null;
            String parentXpath = null;
            Object elementProperty = null;
            for (int i = 0; i < configChangeList.size(); ++i) {
                configChange = (ConfigChange)configChangeList.get(i);
                xpath = configChange.getXPath();
                if (xpath == null) continue;
                ConfigBean object = configContext.exactLookup(xpath);
                if (object != null) {
                    if (object instanceof HttpListener) {
                        if (((HttpListener)object).getDefaultVirtualServer().equals("__asadmin")) {
                            if (configChangeList.size() != 1) continue;
                            throw new AdminEventListenerException("Restart required");
                        }
                        this.webContainer.updateConnector((HttpListener)object, config.getHttpService());
                        continue;
                    }
                    if (!(object instanceof ElementProperty)) continue;
                    parentXpath = configChange.getParentXPath();
                    if (parentXpath == null) {
                        parentXpath = xpath.substring(0, xpath.lastIndexOf("/"));
                    }
                    httpBean = (HttpListener)configContext.exactLookup(parentXpath);
                    this.webContainer.updateConnector(httpBean, config.getHttpService());
                    continue;
                }
                parentXpath = xpath.substring(0, xpath.lastIndexOf("/"));
                httpBean = (HttpListener)configContext.exactLookup(parentXpath);
                this.webContainer.updateConnector(httpBean, config.getHttpService());
            }
        }
        catch (Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }

    public void handleDelete(HSHttpListenerEvent event) throws AdminEventListenerException {
        if (this.webContainer == null || event == null) {
            return;
        }
        try {
            ConfigContext configContext = event.getConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
            if (config == null) {
                return;
            }
            this.webContainer.deleteConnector(config.getHttpService());
        }
        catch (Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }

    public void handleDelete(HSServiceEvent event) throws AdminEventListenerException {
    }

    public void handleUpdate(HSServiceEvent event) throws AdminEventListenerException {
        if (this.webContainer == null || event == null) {
            return;
        }
        try {
            ConfigContext configContext = event.getConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
            if (config == null) {
                return;
            }
            this.webContainer.updateHttpService(config.getHttpService());
        }
        catch (Exception e) {
            throw new AdminEventListenerException(e);
        }
    }

    public void handleCreate(HSServiceEvent event) throws AdminEventListenerException {
    }

    public void handleCreate(HSVirtualServerEvent event) throws AdminEventListenerException {
        if (this.webContainer == null || event == null) {
            return;
        }
        try {
            ConfigContext configContext = event.getConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
            if (config == null) {
                return;
            }
            ConfigAdd configAdd = null;
            ArrayList configChangeList = event.getConfigChangeList();
            VirtualServer vsBean = null;
            String xpath = null;
            Server serverBean = ServerBeansFactory.getServerBean(configContext);
            ElementProperty elementProperty = null;
            for (int i = 0; i < configChangeList.size(); ++i) {
                Object configObject = configChangeList.get(i);
                if (!(configObject instanceof ConfigAdd) || (xpath = (configAdd = (ConfigAdd)configObject).getXPath()) == null) continue;
                ConfigBean object = configContext.exactLookup(xpath);
                if (object instanceof VirtualServer) {
                    vsBean = (VirtualServer)object;
                    this.webContainer.createHost(vsBean, configContext, true);
                    continue;
                }
                if (!(object instanceof ElementProperty)) continue;
                xpath = xpath.substring(0, xpath.lastIndexOf("/"));
                vsBean = (VirtualServer)configContext.exactLookup(xpath);
                elementProperty = (ElementProperty)object;
                this.webContainer.updateHostProperties(vsBean, elementProperty.getName(), elementProperty.getValue(), config.getHttpService(), config.getSecurityService());
            }
        }
        catch (Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }

    public void handleUpdate(HSVirtualServerEvent event) throws AdminEventListenerException {
        if (this.webContainer == null || event == null) {
            return;
        }
        try {
            ConfigContext configContext = event.getConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
            if (config == null) {
                return;
            }
            ConfigChange configChange = null;
            ArrayList configChangeList = event.getConfigChangeList();
            VirtualServer vsBean = null;
            String xpath = null;
            String parentXpath = null;
            Server serverBean = ServerBeansFactory.getServerBean(configContext);
            ElementProperty elementProperty = null;
            for (int i = 0; i < configChangeList.size(); ++i) {
                configChange = (ConfigChange)configChangeList.get(i);
                xpath = configChange.getXPath();
                if (xpath == null) continue;
                ConfigBean object = configContext.exactLookup(xpath);
                if (object != null) {
                    if (object instanceof VirtualServer) {
                        this.webContainer.updateHost((VirtualServer)object, config.getHttpService(), serverBean);
                        continue;
                    }
                    if (!(object instanceof ElementProperty)) continue;
                    parentXpath = configChange.getParentXPath();
                    if (parentXpath == null) {
                        parentXpath = xpath.substring(0, xpath.lastIndexOf("/"));
                    }
                    vsBean = (VirtualServer)configContext.exactLookup(parentXpath);
                    elementProperty = (ElementProperty)object;
                    this.webContainer.updateHostProperties(vsBean, elementProperty.getName(), elementProperty.getValue(), config.getHttpService(), config.getSecurityService());
                    continue;
                }
                int lastSlash = xpath.lastIndexOf("/");
                parentXpath = xpath.substring(0, lastSlash);
                String propName = xpath.substring(lastSlash);
                if (propName == null) continue;
                int beginQuote = propName.indexOf("'");
                int endQuote = propName.lastIndexOf("'");
                if (endQuote <= beginQuote) continue;
                propName = propName.substring(beginQuote + 1, endQuote);
                vsBean = (VirtualServer)configContext.exactLookup(parentXpath);
                this.webContainer.updateHostProperties(vsBean, propName, null, config.getHttpService(), config.getSecurityService());
            }
        }
        catch (Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }

    public void handleDelete(HSVirtualServerEvent event) throws AdminEventListenerException {
        if (this.webContainer == null || event == null) {
            return;
        }
        try {
            ConfigContext configContext = event.getConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
            if (config != null) {
                this.webContainer.deleteHost(config.getHttpService());
            }
        }
        catch (Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }

    public void handleDelete(HSHttpProtocolEvent event) throws AdminEventListenerException {
    }

    public void handleUpdate(HSHttpProtocolEvent event) throws AdminEventListenerException {
        if (this.webContainer == null) {
            return;
        }
        try {
            ConfigContext configContext = event.getConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
            if (config == null) {
                return;
            }
            this.webContainer.updateHttpService(config.getHttpService());
        }
        catch (Exception e) {
            throw new AdminEventListenerException(e);
        }
    }

    public void handleCreate(HSHttpProtocolEvent event) throws AdminEventListenerException {
    }

    public void handleDelete(HSHttpFileCacheEvent event) throws AdminEventListenerException {
    }

    public void handleUpdate(HSHttpFileCacheEvent event) throws AdminEventListenerException {
        if (this.webContainer == null) {
            return;
        }
        try {
            ConfigContext configContext = event.getConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
            if (config == null) {
                return;
            }
            this.webContainer.updateHttpService(config.getHttpService());
        }
        catch (Exception e) {
            throw new AdminEventListenerException(e);
        }
    }

    public void handleCreate(HSHttpFileCacheEvent event) throws AdminEventListenerException {
    }

    public void handleDelete(HSConnectionPoolEvent event) throws AdminEventListenerException {
    }

    public void handleUpdate(HSConnectionPoolEvent event) throws AdminEventListenerException {
        if (this.webContainer == null) {
            return;
        }
        try {
            ConfigContext configContext = event.getConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
            if (config == null) {
                return;
            }
            this.webContainer.updateHttpService(config.getHttpService());
        }
        catch (Exception e) {
            throw new AdminEventListenerException(e);
        }
    }

    public void handleCreate(HSConnectionPoolEvent event) throws AdminEventListenerException {
    }

    public void handleDelete(HSKeepAliveEvent event) throws AdminEventListenerException {
    }

    public void handleUpdate(HSKeepAliveEvent event) throws AdminEventListenerException {
        if (this.webContainer == null) {
            return;
        }
        try {
            ConfigContext configContext = event.getConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
            if (config == null) {
                return;
            }
            this.webContainer.updateHttpService(config.getHttpService());
        }
        catch (Exception e) {
            throw new AdminEventListenerException(e);
        }
    }

    public void handleCreate(HSKeepAliveEvent event) throws AdminEventListenerException {
    }

    public void handleDelete(HSRequestProcessingEvent event) throws AdminEventListenerException {
    }

    public void handleUpdate(HSRequestProcessingEvent event) throws AdminEventListenerException {
        if (this.webContainer == null) {
            return;
        }
        try {
            ConfigContext configContext = event.getConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
            if (config == null) {
                return;
            }
            this.webContainer.updateHttpService(config.getHttpService());
        }
        catch (Exception e) {
            throw new AdminEventListenerException(e);
        }
    }

    public void handleCreate(HSRequestProcessingEvent event) throws AdminEventListenerException {
    }
}

