/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.Switch;
import com.sun.enterprise.security.jauth.ClientAuthConfig;
import com.sun.enterprise.security.jauth.ClientAuthContext;
import com.sun.enterprise.security.wss.WebServiceSecurity;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPMessage;

public class MessageLayerClientHandler
implements Handler {
    private static Logger _logger = null;
    public static final String CLIENT_AUTH_CONFIG = "com.sun.enterprise.security.wss.ClientAuthConfig";
    private static final String CLIENT_AUTH_CONTEXT = "com.sun.enterprise.security.jauth.ClientAuthContext";
    private static String errMsg;
    private ClientAuthConfig config_ = null;
    private QName[] qname = null;
    private boolean isAppclientContainer = false;
    private QName serviceName = null;

    public MessageLayerClientHandler() {
        int containerType = Switch.getSwitch().getContainerType();
        this.isAppclientContainer = containerType == 1;
    }

    public boolean handleFault(MessageContext messageContext) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "wss-auth-client: ClientHandler does not handle SOAP faults");
        }
        return true;
    }

    public boolean handleRequest(MessageContext messageContext) {
        if (!this.isSoapMessageContext(messageContext)) {
            throw new JAXRPCException(errMsg);
        }
        if (this.config_ == null) {
            return true;
        }
        SOAPMessageContext smc = (SOAPMessageContext)messageContext;
        SOAPMessage request = smc.getMessage();
        ClientAuthContext cAC = this.config_.getAuthContext(null, request);
        if (cAC == null) {
            return true;
        }
        smc.setProperty(CLIENT_AUTH_CONTEXT, (Object)cAC);
        smc.setProperty("javax.xml.ws.wsdl.service", (Object)this.serviceName);
        try {
            WebServiceSecurity.secureRequest(smc, cAC, this.isAppclientContainer);
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "ws.error_secure_request", e);
            }
            throw new JAXRPCException((Throwable)e);
        }
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) {
        boolean retValue;
        if (!this.isSoapMessageContext(messageContext)) {
            throw new JAXRPCException(errMsg);
        }
        if (this.config_ == null) {
            return true;
        }
        SOAPMessageContext smc = (SOAPMessageContext)messageContext;
        ClientAuthContext cAC = (ClientAuthContext)smc.getProperty(CLIENT_AUTH_CONTEXT);
        if (cAC == null) {
            return true;
        }
        try {
            retValue = WebServiceSecurity.validateResponse(smc, cAC);
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "ws.error_validate_response", e);
            }
            throw new JAXRPCException((Throwable)e);
        }
        return retValue;
    }

    public QName[] getHeaders() {
        return this.qname;
    }

    public void destroy() {
        this.qname = null;
    }

    public void init(HandlerInfo info) {
        this.qname = info.getHeaders();
        this.config_ = (ClientAuthConfig)info.getHandlerConfig().get(CLIENT_AUTH_CONFIG);
        this.serviceName = (QName)info.getHandlerConfig().get("javax.xml.ws.wsdl.service");
    }

    private boolean isSoapMessageContext(MessageContext mc) {
        boolean retValue;
        boolean bl = retValue = mc instanceof SOAPMessageContext;
        if (!retValue && _logger.isLoggable(Level.WARNING)) {
            _logger.log(Level.WARNING, "ws.error_not_soap");
        }
        return retValue;
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
        errMsg = "Client WSS Handler: MessageContext not of type SOAPMessageContext";
    }
}

