/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationFilterFactory;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomcat.util.buf.MessageBytes;

final class StandardWrapperValve
extends ValveBase {
    private static Log log = LogFactory.getLog(StandardWrapperValve.class);
    private long processingTimeMillis;
    private long maxTimeMillis;
    private volatile long minTimeMillis = Long.MAX_VALUE;
    private AtomicInteger requestCount = new AtomicInteger(0);
    private int errorCount;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");

    StandardWrapperValve() {
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        long t1;
        block44: {
            Servlet servlet;
            StandardWrapper wrapper;
            Throwable throwable;
            block43: {
                block42: {
                    boolean unavailable = false;
                    throwable = null;
                    t1 = System.currentTimeMillis();
                    this.requestCount.incrementAndGet();
                    wrapper = (StandardWrapper)this.getContainer();
                    HttpRequest hrequest = (HttpRequest)request;
                    servlet = null;
                    HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
                    HttpServletResponse hres = (HttpServletResponse)response.getResponse();
                    if (!((Context)wrapper.getParent()).getAvailable()) {
                        hres.sendError(503);
                        response.setDetailMessage(sm.getString("standardContext.isUnavailable"));
                        unavailable = true;
                    }
                    if (!unavailable && wrapper.isUnavailable()) {
                        this.log(sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
                        if (hres != null) {
                            long available = wrapper.getAvailable();
                            if (available > 0L && available < Long.MAX_VALUE) {
                                hres.setDateHeader("Retry-After", available);
                                hres.sendError(503);
                                response.setDetailMessage(sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
                            } else if (available == Long.MAX_VALUE) {
                                hres.sendError(404);
                                response.setDetailMessage(sm.getString("standardWrapper.notFound", wrapper.getName()));
                            }
                        }
                        unavailable = true;
                    }
                    try {
                        if (!unavailable) {
                            servlet = wrapper.allocate();
                        }
                    }
                    catch (UnavailableException e) {
                        if (e.isPermanent()) {
                            hres.sendError(404);
                            response.setDetailMessage(sm.getString("standardWrapper.notFound", wrapper.getName()));
                        } else {
                            hres.setDateHeader("Retry-After", (long)e.getUnavailableSeconds());
                            hres.sendError(503);
                            response.setDetailMessage(sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
                        }
                    }
                    catch (ServletException e) {
                        this.log(sm.getString("standardWrapper.allocateException", wrapper.getName()), StandardWrapper.getRootCause(e));
                        throwable = e;
                        this.exception(request, response, e);
                        servlet = null;
                    }
                    catch (Throwable e) {
                        this.log(sm.getString("standardWrapper.allocateException", wrapper.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                        servlet = null;
                    }
                    try {
                        response.sendAcknowledgement();
                    }
                    catch (IOException e) {
                        this.log(sm.getString("standardWrapper.acknowledgeException", wrapper.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (Throwable e) {
                        this.log(sm.getString("standardWrapper.acknowledgeException", wrapper.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                        servlet = null;
                    }
                    MessageBytes requestPathMB = null;
                    if (hreq != null) {
                        requestPathMB = hrequest.getRequestPathMB();
                    }
                    hreq.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", (Object)ApplicationFilterFactory.REQUEST_INTEGER);
                    hreq.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", (Object)requestPathMB);
                    ApplicationFilterFactory factory = ApplicationFilterFactory.getInstance();
                    ApplicationFilterChain filterChain = factory.createFilterChain((ServletRequest)request, wrapper, servlet);
                    try {
                        String jspFile = wrapper.getJspFile();
                        if (jspFile != null) {
                            hreq.setAttribute("org.apache.catalina.jsp_file", (Object)jspFile);
                        }
                        if (servlet != null) {
                            if (filterChain != null) {
                                filterChain.doFilter((ServletRequest)hreq, (ServletResponse)hres);
                            } else {
                                ApplicationFilterChain.servletService((ServletRequest)hreq, (ServletResponse)hres, servlet, wrapper.getInstanceSupport());
                            }
                        }
                    }
                    catch (ClientAbortException e) {
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (IOException e) {
                        this.log(sm.getString("standardWrapper.serviceException", wrapper.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (UnavailableException e) {
                        this.log(sm.getString("standardWrapper.serviceException", wrapper.getName()), e);
                        wrapper.unavailable(e);
                        long available = wrapper.getAvailable();
                        if (available > 0L && available < Long.MAX_VALUE) {
                            hres.setDateHeader("Retry-After", available);
                            hres.sendError(503);
                            response.setDetailMessage(sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
                        } else if (available == Long.MAX_VALUE) {
                            hres.sendError(404);
                            response.setDetailMessage(sm.getString("standardWrapper.notFound", wrapper.getName()));
                        }
                    }
                    catch (ServletException e) {
                        Throwable rootCause = StandardWrapper.getRootCause(e);
                        if (!(rootCause instanceof ClientAbortException)) {
                            this.log(sm.getString("standardWrapper.serviceException", wrapper.getName()), rootCause);
                        }
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (Throwable e) {
                        this.log(sm.getString("standardWrapper.serviceException", wrapper.getName()), e);
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    try {
                        if (filterChain != null) {
                            filterChain.release();
                        }
                    }
                    catch (Throwable e) {
                        this.log(sm.getString("standardWrapper.releaseFilters", wrapper.getName()), e);
                        if (throwable != null) break block42;
                        throwable = e;
                        this.exception(request, response, e);
                    }
                }
                try {
                    if (servlet != null) {
                        wrapper.deallocate(servlet);
                    }
                }
                catch (Throwable e) {
                    this.log(sm.getString("standardWrapper.deallocateException", wrapper.getName()), e);
                    if (throwable != null) break block43;
                    throwable = e;
                    this.exception(request, response, e);
                }
            }
            try {
                if (servlet != null && wrapper.getAvailable() == Long.MAX_VALUE) {
                    wrapper.unload();
                }
            }
            catch (Throwable e) {
                this.log(sm.getString("standardWrapper.unloadException", wrapper.getName()), e);
                if (throwable != null) break block44;
                throwable = e;
                this.exception(request, response, e);
            }
        }
        long t2 = System.currentTimeMillis();
        long time = t2 - t1;
        this.processingTimeMillis += time;
        if (time > this.maxTimeMillis) {
            this.maxTimeMillis = time;
        }
        if (time < this.minTimeMillis) {
            this.minTimeMillis = time;
        }
        return 2;
    }

    private void log(String message) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("StandardWrapperValve[" + this.container.getName() + "]: " + message);
        } else {
            String containerName = null;
            if (this.container != null) {
                containerName = this.container.getName();
            }
            System.out.println("StandardWrapperValve[" + containerName + "]: " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("StandardWrapperValve[" + this.container.getName() + "]: " + message, throwable);
        } else {
            String containerName = null;
            if (this.container != null) {
                containerName = this.container.getName();
            }
            System.out.println("StandardWrapperValve[" + containerName + "]: " + message);
            System.out.println("" + throwable);
            throwable.printStackTrace(System.out);
        }
    }

    private void exception(Request request, Response response, Throwable exception) {
        ServletRequest sreq = request.getRequest();
        sreq.setAttribute("javax.servlet.error.exception", (Object)exception);
        ServletResponse sresponse = response.getResponse();
        ((HttpServletResponse)sresponse).setStatus(500);
    }

    public long getProcessingTimeMillis() {
        return this.processingTimeMillis;
    }

    public void setProcessingTimeMillis(long processingTimeMillis) {
        this.processingTimeMillis = processingTimeMillis;
    }

    public long getMaxTimeMillis() {
        return this.maxTimeMillis;
    }

    public void setMaxTimeMillis(long maxTimeMillis) {
        this.maxTimeMillis = maxTimeMillis;
    }

    public long getMinTimeMillis() {
        return this.minTimeMillis;
    }

    public void setMinTimeMillis(long minTimeMillis) {
        this.minTimeMillis = minTimeMillis;
    }

    public int getRequestCount() {
        return this.requestCount.get();
    }

    public void setRequestCount(int count) {
        this.requestCount.set(count);
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    public ObjectName createObjectName(String domain, ObjectName parent) throws MalformedObjectNameException {
        return null;
    }
}

