/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Vector;
import sun.rmi.rmic.iiop.CompoundType;
import sun.rmi.rmic.iiop.ContextStack;
import sun.rmi.rmic.iiop.IDLNames;
import sun.rmi.rmic.iiop.Type;

public class ArrayType
extends Type {
    private Type type;
    private int arrayDimension;
    private String brackets;
    private String bracketsSig;

    public static ArrayType forArray(sun.tools.java.Type theType, ContextStack stack) {
        ArrayType result = null;
        sun.tools.java.Type arrayType = theType;
        if (arrayType.getTypeCode() == 9) {
            while (arrayType.getTypeCode() == 9) {
                arrayType = arrayType.getElementType();
            }
            Type existing = ArrayType.getType(theType, stack);
            if (existing != null) {
                if (!(existing instanceof ArrayType)) {
                    return null;
                }
                return (ArrayType)existing;
            }
            Type temp = CompoundType.makeType(arrayType, null, stack);
            if (temp != null) {
                result = new ArrayType(stack, temp, theType.getArrayDimension());
                ArrayType.putType(theType, (Type)result, stack);
                stack.push(result);
                stack.pop(true);
            }
        }
        return result;
    }

    public String getSignature() {
        return this.bracketsSig + this.type.getSignature();
    }

    public Type getElementType() {
        return this.type;
    }

    public int getArrayDimension() {
        return this.arrayDimension;
    }

    public String getArrayBrackets() {
        return this.brackets;
    }

    public String toString() {
        return this.getQualifiedName() + this.brackets;
    }

    public String getTypeDescription() {
        return "Array of " + this.type.getTypeDescription();
    }

    public String getTypeName(boolean useQualifiedNames, boolean useIDLNames, boolean globalIDLNames) {
        if (useIDLNames) {
            return super.getTypeName(useQualifiedNames, useIDLNames, globalIDLNames);
        }
        return super.getTypeName(useQualifiedNames, useIDLNames, globalIDLNames) + this.brackets;
    }

    protected void swapInvalidTypes() {
        if (this.type.getStatus() != 1) {
            this.type = this.getValidType(this.type);
        }
    }

    protected boolean addTypes(int typeCodeFilter, HashSet checked, Vector matching) {
        boolean result = super.addTypes(typeCodeFilter, checked, matching);
        if (result) {
            this.getElementType().addTypes(typeCodeFilter, checked, matching);
        }
        return result;
    }

    private ArrayType(ContextStack stack, Type type, int arrayDimension) {
        super(stack, 262144);
        this.type = type;
        this.arrayDimension = arrayDimension;
        this.brackets = "";
        this.bracketsSig = "";
        for (int i = 0; i < arrayDimension; ++i) {
            this.brackets = this.brackets + "[]";
            this.bracketsSig = this.bracketsSig + "[";
        }
        String idlName = IDLNames.getArrayName(type, arrayDimension);
        String[] module = IDLNames.getArrayModuleNames(type);
        this.setNames(type.getIdentifier(), module, idlName);
        this.setRepositoryID();
    }

    protected Class loadClass() {
        Class<?> result = null;
        Class elementClass = this.type.getClassInstance();
        if (elementClass != null) {
            result = Array.newInstance(elementClass, new int[this.arrayDimension]).getClass();
        }
        return result;
    }

    protected void destroy() {
        super.destroy();
        if (this.type != null) {
            this.type.destroy();
            this.type = null;
        }
        this.brackets = null;
        this.bracketsSig = null;
    }
}

