/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout.template;

import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.LayoutDefinition;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.LayoutStaticText;
import com.sun.jsftemplating.layout.descriptors.handler.Handler;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerDefinition;
import com.sun.jsftemplating.layout.descriptors.handler.OutputMapping;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateWriter {
    private PrintWriter _writer = null;
    private static final String INDENT = "  ";

    public TemplateWriter(OutputStream stream) {
        this._writer = new PrintWriter(stream);
    }

    public void write(LayoutDefinition def) throws IOException {
        this.writeBody("", def);
        this._writer.flush();
    }

    protected void writeBody(String prefix, LayoutElement elt) throws IOException {
        this.writeHandlers(prefix, elt.getHandlersByTypeMap());
        for (LayoutElement child : elt.getChildLayoutElements()) {
            if (child instanceof LayoutStaticText) {
                this.writeLayoutStaticText(prefix, (LayoutStaticText)child);
                continue;
            }
            if (!(child instanceof LayoutComponent)) continue;
            this.writeLayoutComponent(prefix, (LayoutComponent)child);
        }
    }

    protected void write(String str) throws IOException {
        this._writer.print(str);
    }

    protected void writeHandlers(String prefix, Map<String, List<Handler>> handlerMap) throws IOException {
        for (String eventType : handlerMap.keySet()) {
            this.write(prefix + "<!" + eventType + "\n");
            for (Handler handler : handlerMap.get(eventType)) {
                this.writeHandler(INDENT + prefix, handler);
            }
            this.write(prefix + "/>\n");
        }
    }

    protected void writeHandler(String prefix, Handler handler) throws IOException {
        HandlerDefinition def = handler.getHandlerDefinition();
        this.write(prefix + def.getId() + "(");
        String seperator = "";
        for (String inputKey : def.getInputDefs().keySet()) {
            this.write(seperator + inputKey + "=\"" + handler.getInputValue(inputKey) + "\"");
            seperator = ", ";
        }
        OutputMapping output = null;
        for (String outputKey : def.getOutputDefs().keySet()) {
            output = handler.getOutputValue(outputKey);
            this.write(seperator + outputKey + "=>$" + output.getStringOutputType() + "{" + output.getOutputKey() + "}");
            seperator = ", ";
        }
        this.write(");\n");
    }

    protected void writeLayoutStaticText(String prefix, LayoutStaticText text) throws IOException {
        this.write(prefix + "\"" + text.getOptions().get("value") + "\n");
    }

    protected void writeLayoutComponent(String prefix, LayoutComponent comp) throws IOException {
        String type = comp.getType().getId();
        this.write(prefix + "<" + type);
        this.write(" id=\"" + comp.getUnevaluatedId() + "\"");
        if (comp.isOverwrite()) {
            this.write(" overwrite=\"true\"");
        }
        Map<String, Object> options = comp.getOptions();
        for (String key : options.keySet()) {
            this.write(" " + key + "=\"" + options.get(key) + "\"");
        }
        this.write(">\n");
        this.writeBody(INDENT + prefix, comp);
        this.write(prefix + "</" + type + ">\n");
    }
}

