/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade;

import com.sun.enterprise.tools.upgrade.cluster.ClusterInfo;
import com.sun.enterprise.tools.upgrade.cluster.ClusteredInstance;
import com.sun.enterprise.tools.upgrade.cluster.ClustersInfoManager;
import com.sun.enterprise.tools.upgrade.cluster.IIOPCluster;
import com.sun.enterprise.tools.upgrade.common.BaseModule;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.CommonProperties;
import com.sun.enterprise.tools.upgrade.common.DomainInfo;
import com.sun.enterprise.tools.upgrade.common.DomainsProcessor;
import com.sun.enterprise.tools.upgrade.common.HarnessException;
import com.sun.enterprise.tools.upgrade.common.UpdateProgressManager;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UpgradeHarness {
    private static Logger logger = LogService.getLogger("com.sun.enterprise.tools.upgrade");
    private StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade");
    private List moduleList = new LinkedList();
    private CommonInfoModel commonInfo;
    private ArrayList doNotCopyList;

    public void setCommonInfoModel(CommonInfoModel commonInfo) {
        this.commonInfo = commonInfo;
    }

    public void startUpgrade() {
        DomainsProcessor dProcessor = new DomainsProcessor(this.commonInfo);
        try {
            this.loadModules();
            System.setProperty("com.sun.aas.configRoot", this.commonInfo.getTargetInstallDir() + File.separator + "config");
            dProcessor.processTargetDomains();
            UpdateProgressManager.getProgressManager().processUpgradeUpdateEvent(30);
            if ((this.commonInfo.isEnterpriseEdition(this.commonInfo.getSourceEdition()) || "cluster".equals(this.commonInfo.getSourceEdition())) && !dProcessor.processClusters()) {
                dProcessor.processStandAloneInstances();
            }
            UpdateProgressManager.getProgressManager().processUpgradeUpdateEvent(50);
            int totalIterations = this.getTotalIterationsFromDomainMapping();
            int currentIteration = 0;
            Iterator dItr = this.commonInfo.getDomainMapping().keySet().iterator();
            while (dItr.hasNext()) {
                DomainInfo dInfo = (DomainInfo)this.commonInfo.getDomainMapping().get(dItr.next());
                this.commonInfo.setCurrentDomain(dInfo.getDomainName());
                List instanceList = this.getProcessableInstanceList(dInfo);
                logger.log(Level.INFO, this.stringManager.getString("enterprise.tools.upgrade.currentlyProcessingDomain", (Object)dInfo.getDomainName()));
                for (int instIndex = 0; instIndex < instanceList.size(); ++instIndex) {
                    ++currentIteration;
                    String currentInstanceName = (String)instanceList.get(instIndex);
                    if (!currentInstanceName.equals("")) {
                        this.commonInfo.setCurrentSourceInstance(currentInstanceName);
                        logger.log(Level.INFO, this.stringManager.getString("enterprise.tools.upgrade.currentlyProcessingInstance", (Object)currentInstanceName));
                    }
                    if (this.invokeModules(currentIteration, totalIterations)) continue;
                    return;
                }
                if (this.copyAdminKeyFile(dInfo)) {
                    logger.log(Level.INFO, this.stringManager.getString("enterprise.tools.upgrade.copykeyfile"));
                }
                if (this.copyDomainPasswordsFile(dInfo)) {
                    logger.log(Level.INFO, this.stringManager.getString("enterprise.tools.upgrade.copydomain_passwords_file"));
                }
                if (this.restoreMasterPassword(dInfo)) {
                    logger.log(Level.INFO, this.stringManager.getString("enterprise.tools.upgrade.restored_master_password"));
                }
                if (!this.copyMqRepository(dInfo)) continue;
                logger.log(Level.INFO, this.stringManager.getString("enterprise.tools.upgrade.copy_mq_repository"));
            }
            logger.log(Level.INFO, this.stringManager.getString("enterprise.tools.upgrade.finishedUpgrade"));
            UpdateProgressManager.getProgressManager().processUpgradeUpdateEvent(100);
            this.removeAsadminpass();
        }
        catch (HarnessException he) {
            logger.log(Level.SEVERE, this.stringManager.getString("enterprise.tools.upgrade.generalException", (Object)he.getMessage()));
            UpdateProgressManager.getProgressManager().processUpgradeUpdateEvent(-1);
            this.commonInfo.recover();
            return;
        }
    }

    private int getTotalIterationsFromDomainMapping() {
        int totalIt = 1;
        Iterator dItr = this.commonInfo.getDomainMapping().keySet().iterator();
        while (dItr.hasNext()) {
            DomainInfo dInfo = (DomainInfo)this.commonInfo.getDomainMapping().get(dItr.next());
            List instanceList = this.getProcessableInstanceList(dInfo);
            totalIt += instanceList.size();
        }
        return totalIt;
    }

    private boolean invokeModules(int currentIteration, int totalIterations) {
        String moduleName = "Default";
        ArrayList<BaseModule> successfulModuleList = new ArrayList<BaseModule>();
        int moduleSize = this.moduleList.size();
        int nthModule = 0;
        int progress = 0;
        for (int i = 0; i < moduleSize; ++i) {
            ++nthModule;
            if (!UpdateProgressManager.getProgressManager().canContinueUpgrade()) {
                logger.log(Level.SEVERE, this.stringManager.getString("enterprise.tools.upgrade.didNotfinishUpgrade", (Object)this.commonInfo.getTargetDomainRoot()));
                UpdateProgressManager.getProgressManager().processUpgradeUpdateEvent(-1);
                return false;
            }
            BaseModule baseModule = (BaseModule)this.moduleList.get(i);
            moduleName = baseModule.getName();
            if (baseModule.upgrade(this.commonInfo)) {
                successfulModuleList.add(baseModule);
            } else {
                logger.log(Level.INFO, this.stringManager.getString("enterprise.tools.upgrade.module_upgrade_failed", (Object)moduleName));
                UpdateProgressManager.getProgressManager().setContinueUpgrade(false);
                baseModule.recovery(this.commonInfo);
                for (int k = 0; k < successfulModuleList.size(); ++k) {
                    BaseModule successModule = (BaseModule)successfulModuleList.get(k);
                    logger.log(Level.INFO, this.stringManager.getString("enterprise.tools.upgrade.module_rollback", (Object)successModule.getName(), (Object)this.commonInfo.getCurrentDomain()));
                    successModule.recovery(this.commonInfo);
                }
            }
            logger.log(Level.INFO, this.stringManager.getString("enterprise.tools.upgrade.finishedModule") + moduleName);
            int pFirst = 50 * currentIteration / totalIterations;
            int pLast = 50 / totalIterations - 50 * nthModule / (moduleSize * totalIterations);
            progress = 50 + pFirst - pLast;
            UpdateProgressManager.getProgressManager().processUpgradeUpdateEvent(progress);
        }
        return true;
    }

    private void upgradeEESource() {
        int totalIterations = ClustersInfoManager.getClusterInfoManager().getClusterInfoList().size() + UpgradeUtils.getUpgradeUtils(this.commonInfo).getStandAloneInstances(this.commonInfo.getDomainMapping()).size() + 1;
        int currentIteration = 0;
        for (ClusterInfo cInfo : ClustersInfoManager.getClusterInfoManager().getClusterInfoList()) {
            ClusteredInstance clInstance = cInfo.getMasterInstance();
            if (clInstance == null) {
                clInstance = (ClusteredInstance)cInfo.getClusteredInstanceList().get(0);
            }
            this.commonInfo.setCurrentCluster(cInfo.getClusterName());
            this.commonInfo.setCurrentDomain(clInstance.getDomain());
            this.commonInfo.setCurrentSourceInstance(clInstance.getInstanceName());
            logger.log(Level.INFO, this.stringManager.getString("enterprise.tools.upgrade.currentlyProcessingCLUSTER", (Object)cInfo.getClusterName()));
            if (this.invokeModules(++currentIteration, totalIterations)) continue;
            return;
        }
        this.commonInfo.setCurrentCluster(null);
        for (Vector instDInfo : UpgradeUtils.getUpgradeUtils(this.commonInfo).getStandAloneInstances(this.commonInfo.getDomainMapping())) {
            this.commonInfo.setCurrentDomain(((DomainInfo)instDInfo.elementAt(1)).getDomainName());
            this.commonInfo.setCurrentSourceInstance((String)instDInfo.elementAt(0));
            logger.log(Level.INFO, this.stringManager.getString("enterprise.tools.upgrade.currentlyProcessingInstance", (Object)((String)instDInfo.elementAt(0))));
            if (this.invokeModules(++currentIteration, totalIterations)) continue;
            return;
        }
        this.updateMiscellaneousClusterInfo();
        logger.log(Level.INFO, this.stringManager.getString("enterprise.tools.upgrade.finishedUpgrade"));
        UpdateProgressManager.getProgressManager().processUpgradeUpdateEvent(100);
    }

    private void updateMiscellaneousClusterInfo() {
        Hashtable persistenceStoreMapping;
        Hashtable iiopMapping = ClustersInfoManager.getClusterInfoManager().getIIOPClustersMapping();
        if (iiopMapping != null) {
            for (String domainName : iiopMapping.keySet()) {
                List iCls = (List)iiopMapping.get(domainName);
                String domainXMLfile = this.commonInfo.getDestinationDomainPath(domainName) + File.separator + "config" + File.separator + "domain.xml";
                for (int i = 0; i < iCls.size(); ++i) {
                    IIOPCluster iiopCluster = (IIOPCluster)iCls.get(i);
                    UpgradeUtils.getUpgradeUtils(this.commonInfo).updateDomainXMLWithIIOPCluster(this.commonInfo, domainXMLfile, iiopCluster);
                }
            }
        }
        if ((persistenceStoreMapping = ClustersInfoManager.getClusterInfoManager().getPersistenceStorePropertiesMapping()) != null) {
            for (String domainName : persistenceStoreMapping.keySet()) {
                Properties props = (Properties)persistenceStoreMapping.get(domainName);
                String domainXMLfile = this.commonInfo.getDestinationDomainPath(domainName) + File.separator + "domain.xml";
                UpgradeUtils.getUpgradeUtils(this.commonInfo).updateDomainXMLWithPersistenceStoreProps(props);
            }
        }
    }

    private List getProcessableInstanceList(DomainInfo dInfo) {
        ArrayList<String> instanceList = new ArrayList<String>();
        String sourceVersion = this.commonInfo.getSourceVersion();
        if (!"7x".equals(sourceVersion)) {
            instanceList.add(new String(""));
            return instanceList;
        }
        List domainInstanceList = dInfo.getInstanceNames();
        for (int i = 0; i < domainInstanceList.size(); ++i) {
            String instanceName = (String)domainInstanceList.get(i);
            if (instanceName.equals("admin-server")) continue;
            instanceList.add(instanceName);
            if (!this.commonInfo.getSourceEdition().equals("pe")) continue;
            if (domainInstanceList.size() <= 2) break;
            logger.log(Level.INFO, this.stringManager.getString("enterprise.tools.upgrade.more_thanone_instance", (Object)instanceName));
            break;
        }
        if (instanceList.isEmpty()) {
            logger.log(Level.WARNING, this.stringManager.getString("enterprise.tools.upgrade.no_server_instance", (Object)dInfo.getDomainName()));
        }
        return instanceList;
    }

    private void loadModules() {
        List list = CommonProperties.getRegisteredModules(this.commonInfo);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            String moduleClassName = (String)list.get(i);
            try {
                Class<?> cls = Class.forName(moduleClassName);
                BaseModule baseModule = (BaseModule)cls.newInstance();
                this.moduleList.add(baseModule);
                continue;
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.SEVERE, this.stringManager.getString("enterprise.tools.upgrade.load_instantiate_error", (Object)e.getMessage()), e);
                continue;
            }
            catch (InstantiationException e) {
                logger.log(Level.SEVERE, this.stringManager.getString("enterprise.tools.upgrade.load_instantiate_error", (Object)e.getMessage()), e);
                continue;
            }
            catch (IllegalAccessException e) {
                logger.log(Level.SEVERE, this.stringManager.getString("enterprise.tools.upgrade.load_instantiate_error", (Object)e.getMessage()), e);
            }
        }
    }

    public void copyDomainsFromBackup(String domainName) {
        DomainInfo domainInfo = (DomainInfo)this.commonInfo.getDomainMapping().get(domainName);
        String domainPath = domainInfo.getDomainPath();
        try {
            UpgradeUtils.getUpgradeUtils(this.commonInfo);
            UpgradeUtils.copyDirectory(new File(domainPath), new File(this.commonInfo.getTargetDomainRoot() + File.separator + domainName));
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, this.stringManager.getString("IOException thrown", (Object)domainPath));
        }
        if (System.getProperty("os.name").equals("Unix") || System.getProperty("os.name").equals("Linux") || System.getProperty("os.name").equals("SunOS")) {
            this.setExecutePermissions(this.commonInfo.getTargetDomainRoot() + File.separator + domainName);
        }
    }

    public void setExecutePermissions(String domainPath) {
        String binDir = domainPath + File.separator + "bin";
        String generatedDir = domainPath + File.separator + "generated" + File.separator + "tmp";
        logger.log(Level.INFO, "bin dir= " + binDir);
        try {
            String[] fileList = new File(binDir).list();
            for (int i = 0; i < fileList.length; ++i) {
                logger.log(Level.INFO, "File List = " + binDir + File.separator + fileList[i]);
                Runtime.getRuntime().exec("/bin/chmod a+x " + binDir + File.separator + fileList[i]);
            }
            Runtime.getRuntime().exec("/bin/chmod 700 " + generatedDir);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, this.stringManager.getString("domainsProcessor.IOException", (Object)domainPath));
        }
    }

    public boolean copyAdminKeyFile(DomainInfo dInfo) {
        if (this.commonInfo.getSourceVersion().equals("7x")) {
            return false;
        }
        try {
            String sourceKeyFilePath = dInfo.getDomainPath() + File.separator + "config";
            String targetKeyFilePath = this.commonInfo.getTargetDomainRoot() + File.separator + dInfo.getDomainName() + File.separator + "config";
            String sourceKeyFile = sourceKeyFilePath + File.separator + "admin-keyfile";
            String targetKeyFile = targetKeyFilePath + File.separator + "admin-keyfile";
            if (!new File(sourceKeyFile).exists()) {
                return false;
            }
            UpgradeUtils.getUpgradeUtils(this.commonInfo);
            UpgradeUtils.copyFile(sourceKeyFile, targetKeyFile);
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, this.stringManager.getString("domainsProcessor.IOException", (Object)ioe.getMessage()));
            return false;
        }
        return true;
    }

    public void copyDomain(String sourceDomain, String targetDomainRoot) {
        File srcDomain = new File(sourceDomain);
        File targetDomain = new File(targetDomainRoot, (String)this.commonInfo.getDomainList().get(0));
        String[] srcDomainListing = srcDomain.list();
        for (int i = 0; i < srcDomainListing.length; ++i) {
            if (this.doNotCopyList.contains(srcDomainListing[i])) continue;
            File srcDomainSubDirectory = new File(sourceDomain, srcDomainListing[i]);
            File targetDomainSubDirectory = new File(targetDomain, srcDomainListing[i]);
            try {
                UpgradeUtils.copyDirectory(srcDomainSubDirectory, targetDomainSubDirectory);
                continue;
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, this.stringManager.getString("domainsProcessor.IOException", (Object)ioe.getMessage()));
            }
        }
        if (System.getProperty("os.name").equals("Unix") || System.getProperty("os.name").equals("Linux") || System.getProperty("os.name").equals("SunOS")) {
            String domainName = (String)this.commonInfo.getDomainList().get(0);
            this.setExecutePermissions(this.commonInfo.getTargetDomainRoot() + File.separator + domainName);
        }
    }

    public boolean copyDomainPasswordsFile(DomainInfo dInfo) {
        if (this.commonInfo.getSourceVersion().equals("7x")) {
            return false;
        }
        String sourcePasswordsFilePath = dInfo.getDomainPath() + File.separator + "config";
        String targetPasswordsFilePath = this.commonInfo.getTargetDomainRoot() + File.separator + dInfo.getDomainName() + File.separator + "config";
        String sourcePasswordsFile = sourcePasswordsFilePath + File.separator + "domain-passwords";
        String targetPasswordsFile = targetPasswordsFilePath + File.separator + "domain-passwords";
        try {
            if (!new File(sourcePasswordsFile).exists()) {
                return false;
            }
            UpgradeUtils.getUpgradeUtils(this.commonInfo);
            UpgradeUtils.copyFile(sourcePasswordsFile, targetPasswordsFile);
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, this.stringManager.getString("enterprise.tools.upgrade.copy_domain_passwords_file_failed", (Object)sourcePasswordsFilePath, (Object)targetPasswordsFilePath));
            return false;
        }
        return true;
    }

    private boolean restoreMasterPassword(DomainInfo dInfo) {
        if (this.commonInfo.getSourceVersion().equals("7x")) {
            return false;
        }
        String targetMasterPasswordFile = this.commonInfo.getTargetDomainRoot() + File.separator + dInfo.getDomainName() + File.separator + "master-password";
        String sourceMasterPasswordFile = dInfo.getDomainPath() + File.separator + "master-password";
        try {
            if (new File(sourceMasterPasswordFile).exists()) {
                UpgradeUtils.copyFile(sourceMasterPasswordFile, targetMasterPasswordFile);
            } else if (new File(targetMasterPasswordFile).exists() && !UpgradeUtils.deleteFile(targetMasterPasswordFile)) {
                throw new SecurityException();
            }
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                logger.log(Level.WARNING, this.stringManager.getString("enterprise.tools.upgrade.copy_master_password_file_failed", (Object)sourceMasterPasswordFile, (Object)targetMasterPasswordFile));
            }
            if (e instanceof SecurityException) {
                logger.log(Level.WARNING, this.stringManager.getString("enterprise.tools.upgrade.delete_master_password_file_failed", (Object)targetMasterPasswordFile));
            }
            return false;
        }
        return true;
    }

    private boolean copyMqRepository(DomainInfo dInfo) {
        String sourcePath = dInfo.getDomainPath() + File.separator + "imq";
        String targetPath = this.commonInfo.getTargetDomainRoot() + File.separator + dInfo.getDomainName() + File.separator + "imq";
        try {
            File sourceDir = new File(sourcePath);
            File targetDir = new File(targetPath);
            if (!sourceDir.exists()) {
                return false;
            }
            UpgradeUtils.getUpgradeUtils(this.commonInfo);
            UpgradeUtils.copyDirectory(sourceDir, targetDir);
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, this.stringManager.getString("enterprise.tools.upgrade.copy_mq_repository_failed", (Object)sourcePath, (Object)targetPath));
            return false;
        }
        return true;
    }

    private void removeAsadminpass() {
        File f = new File(System.getProperty("user.home"), ".asadminpass");
        if (f.exists()) {
            f.delete();
            logger.log(Level.INFO, this.stringManager.getString("enterprise.tools.upgrade.removed.asadminpass", (Object)f.getAbsolutePath()));
        }
    }
}

