/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.cluster;

import com.sun.enterprise.tools.upgrade.cluster.ClusteredInstance;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class ClusterInfo {
    private String clusterName;
    private List clusteredInstanceList;
    private String domainName;
    private static Logger log = CommonInfoModel.getDefaultLogger();

    public List getClusteredInstanceList() {
        return this.clusteredInstanceList;
    }

    public void parseClinstanceConfFile(File file) throws FileNotFoundException, IOException {
        if (this.clusteredInstanceList == null) {
            this.clusteredInstanceList = new ArrayList();
        }
        this.clusteredInstanceList.clear();
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String line = null;
        ClusteredInstance clInstance = null;
        while ((line = reader.readLine()) != null) {
            if (line.trim().startsWith("#")) continue;
            if (line.trim().startsWith("instancename")) {
                String instanceName = line.substring("instancename".length()).trim();
                clInstance = this.createNewInstance(instanceName);
                continue;
            }
            if (clInstance == null) continue;
            clInstance.extractDataFromLine(line);
        }
    }

    public void updateClusteredInstanceList(String domainXMLFile, String domainName, String clName, UpgradeUtils upgradeUtils) {
        if (this.clusteredInstanceList == null) {
            this.clusteredInstanceList = new ArrayList();
        }
        this.clusteredInstanceList.clear();
        upgradeUtils.updateClusteredInstanceList(domainXMLFile, domainName, clName, this.clusteredInstanceList);
    }

    private ClusteredInstance createNewInstance(String instanceName) {
        ClusteredInstance clInstance = new ClusteredInstance(instanceName);
        this.clusteredInstanceList.add(clInstance);
        return clInstance;
    }

    public ClusteredInstance getMasterInstance() {
        ClusteredInstance clInstance2 = null;
        for (ClusteredInstance clInstance2 : this.clusteredInstanceList) {
            if (!clInstance2.isMaster()) continue;
            return clInstance2;
        }
        return null;
    }

    public String getDomainName() {
        if (this.domainName == null) {
            ClusteredInstance clInstance = this.getMasterInstance();
            if (clInstance == null && this.clusteredInstanceList.size() > 0) {
                clInstance = (ClusteredInstance)this.clusteredInstanceList.get(0);
            }
            this.domainName = clInstance.getDomain();
            return clInstance.getDomain();
        }
        return this.domainName;
    }

    public void setDomainName(String dName) {
        this.domainName = dName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clName) {
        this.clusterName = clName;
    }

    public void print() {
        if (this.clusteredInstanceList != null) {
            for (ClusteredInstance clInst : this.clusteredInstanceList) {
                log.info(clInst.getInstanceName());
                log.info(clInst.getUser());
                log.info(clInst.getHost());
                log.info(clInst.getPort());
                log.info(clInst.getDomain());
                log.info(clInst.getInstancePort());
                log.info(String.valueOf(clInst.isMaster()));
                log.info("\n");
            }
        }
    }
}

