/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.cluster;

import com.sun.enterprise.tools.upgrade.cluster.ClusterInfo;
import com.sun.enterprise.tools.upgrade.cluster.IIOPCluster;
import com.sun.enterprise.tools.upgrade.cluster.LBInfo;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.DomainInfo;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public class ClustersInfoManager {
    private static ClustersInfoManager clusterManager;
    private List clusterInfoList;
    private StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade");
    private static Logger logger;
    private Hashtable iiopClustersMapping;
    private Hashtable persistenceStoreMapping;
    private LBInfo loadBalancerInfo;

    public static ClustersInfoManager getClusterInfoManager() {
        if (clusterManager == null) {
            clusterManager = new ClustersInfoManager();
        }
        return clusterManager;
    }

    public ClusterInfo parseClinstanceConfFile(String fileName) throws FileNotFoundException, IOException {
        return this.parseClinstanceConfFile(new File(fileName));
    }

    public ClusterInfo parseClinstanceConfFile(File file) throws FileNotFoundException, IOException {
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        ClusterInfo clInfo = new ClusterInfo();
        clInfo.parseClinstanceConfFile(file);
        return clInfo;
    }

    public List getClusterInfoList() {
        return this.clusterInfoList;
    }

    public boolean processClinstanceConfFiles(List clinstanceConfFiles) {
        if (this.clusterInfoList == null) {
            this.clusterInfoList = new ArrayList();
        }
        this.clusterInfoList.clear();
        Iterator it = clinstanceConfFiles.iterator();
        while (it.hasNext()) {
            try {
                this.clusterInfoList.add(this.parseClinstanceConfFile((String)it.next()));
            }
            catch (FileNotFoundException fne) {
                logger.severe(this.stringManager.getString("enterprise.tools.upgrade.clinstanceConfFileMissing"));
                System.exit(1);
            }
            catch (Exception ex) {
                logger.severe(this.stringManager.getString("enterprise.tools.upgrade.clinstanceConfFileProcessingException"));
                return false;
            }
        }
        return true;
    }

    public void gatherClusterInfo(CommonInfoModel commonInfo) {
        if (this.clusterInfoList == null) {
            this.clusterInfoList = new ArrayList();
        }
        this.clusterInfoList.clear();
        Iterator dItr = commonInfo.getDomainMapping().keySet().iterator();
        while (dItr.hasNext()) {
            DomainInfo dInfo = (DomainInfo)commonInfo.getDomainMapping().get(dItr.next());
            String domainName = dInfo.getDomainName();
            String domainXmlFile = dInfo.getDomainPath() + File.separator + "config" + File.separator + "domain.xml";
            UpgradeUtils.getUpgradeUtils(commonInfo).updateClusterList(domainXmlFile, domainName, this.clusterInfoList);
        }
    }

    public LBInfo getLoadBalancerInfo() {
        return this.loadBalancerInfo;
    }

    public boolean processLoadBalancerFile(String fileName) {
        if (this.loadBalancerInfo == null) {
            this.loadBalancerInfo = new LBInfo();
        }
        if (!new File(fileName).exists()) {
            return false;
        }
        return this.loadBalancerInfo.processLoadBalancerFile(fileName);
    }

    public Hashtable getIIOPClustersMapping() {
        return this.iiopClustersMapping;
    }

    public IIOPCluster getIIOPCluster(String domainName, String clusterName) {
        if (this.iiopClustersMapping == null) {
            this.iiopClustersMapping = new Hashtable();
        }
        ArrayList<IIOPCluster> clList = (ArrayList<IIOPCluster>)this.iiopClustersMapping.get(domainName);
        IIOPCluster iiopCluster = null;
        if (clList != null && !clList.isEmpty()) {
            for (Object e : clList) {
                IIOPCluster iCluster = (IIOPCluster)e;
                if (!iCluster.getClusterName().equals(clusterName)) continue;
                iiopCluster = iCluster;
                break;
            }
        } else {
            clList = new ArrayList<IIOPCluster>();
        }
        if (iiopCluster == null) {
            iiopCluster = new IIOPCluster(clusterName);
            clList.add(iiopCluster);
            this.iiopClustersMapping.put(domainName, clList);
        }
        return iiopCluster;
    }

    public boolean isIIOPClusterExists(String domainName, String clusterName) {
        if (this.iiopClustersMapping == null) {
            return false;
        }
        List clList = (List)this.iiopClustersMapping.get(domainName);
        if (clList == null || clList.isEmpty()) {
            return false;
        }
        Iterator iIt = clList.iterator();
        while (iIt.hasNext()) {
            if (!((IIOPCluster)iIt.next()).getClusterName().equals(clusterName)) continue;
            return true;
        }
        return false;
    }

    public Hashtable getPersistenceStorePropertiesMapping() {
        return this.persistenceStoreMapping;
    }

    public void addPersistenceStoreProperty(String domainName, String name, String value) {
        Properties propsList;
        if (this.persistenceStoreMapping == null) {
            this.persistenceStoreMapping = new Hashtable();
        }
        if ((propsList = (Properties)this.persistenceStoreMapping.get(domainName)) == null) {
            propsList = new Properties();
        }
        propsList.setProperty(name, value);
        this.persistenceStoreMapping.put(domainName, propsList);
    }

    public static void main(String[] args) {
        ArrayList<String> aList = new ArrayList<String>();
        aList.add("c:\\temp\\clinstance.conf");
        aList.add("c:\\temp\\clinstance.conf");
        ClustersInfoManager cIM = ClustersInfoManager.getClusterInfoManager();
        cIM.processClinstanceConfFiles(aList);
        cIM.print();
    }

    public void print() {
        if (this.clusterInfoList != null) {
            for (ClusterInfo clInfo : this.clusterInfoList) {
                CommonInfoModel.getDefaultLogger().info("\n\n\n *****************");
                clInfo.print();
            }
        }
    }

    static {
        logger = LogService.getLogger("com.sun.enterprise.tools.upgrade");
    }
}

