/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.tools.upgrade.cluster.ClustersInfoManager;
import com.sun.enterprise.tools.upgrade.common.DomainInfo;
import com.sun.enterprise.tools.upgrade.common.UpgradeConstants;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.tools.upgrade.common.VersionExtracter;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CommonInfoModel {
    private String AS_ADMIN_USER = "admin";
    private String AS_ADMIN_ADMINPASSWORD = "adminadmin";
    private String AS_ADMIN_MASTERPASSWORD = "changeit";
    private String SOURCE_INSTALL_DIR;
    private String TARGET_INSTALL_DIR;
    private String adminUserName = null;
    private String adminPassword = null;
    private File passwordFile = null;
    private String masterPassword = null;
    private String passwordFilePath = null;
    private Map domainCredentials;
    private List passwordFileList;
    private String osName;
    private String[] CERT_ALIASES;
    private String sourceDomainRoot = "";
    private String targetDomainRoot;
    private boolean sourceInputAsDomainRoot;
    private boolean certificateConversionFlag = false;
    private boolean enlistDomain;
    private List domainList;
    private List domainOptionList;
    private String InstallConfig70;
    private String sourceApplicationRoot;
    private String currentDomain;
    private String currentSourceServerInstance = "";
    private String currentCluster;
    private Hashtable domainMapping;
    private Map domainNameMapping;
    private String sourceVersionEdition = null;
    private String targetVersionEdition = null;
    private String sourceVersion = null;
    private String targetVersion = "9.1";
    private String sourceEdition = null;
    private String targetDefaultProfile = null;
    private boolean isInPlace = false;
    private Map domainNSSPwdMapping;
    private Map domainTargetNSSPwdMapping;
    private Map domainJKSPwdMapping;
    private Map domainJKSCAPwdMapping;
    private Map domainssPwdFileMapping;
    private Map domainTargetnssPwdFileMapping;
    private StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.common");
    private static Logger logger = LogService.getLogger("com.sun.enterprise.tools.upgrade");
    private static final String CERT_FILE_NAME = "keystore.jks";
    private static final String TRUSTED_KEY_STORE = "cacerts.jks";
    private static final String LICENSE_FILE = "LICENSE.txt";
    private static final String NUMBERSTRING = "0123456789";
    public static final String DOMAINS = "domains";
    public static final String CONFIG = "config";
    private static final String SERVER_POLICY_FILE = "server.policy";
    private static final String DEFAULT_WEB_XML_FILE = "default-web.xml";
    private static final String SUN_ACC_XML_FILE = "sun-acc.xml";
    private static final String DOMAIN_XML_FILE = "domain.xml";
    private static final String SOURCE_WSS_SERVER_CONFIG_XML = "wss-server-config.xml";
    private static final String TARGET_WSS_SERVER_CONFIG_XML = "wss-server-config-1.0.xml";
    private static final String HADB_DIR = "hadb";
    private static final String HADBM_JAR_FILE = "hadbm.jar";
    private boolean cliMode = false;
    private boolean nopromptMode = false;

    public CommonInfoModel() {
        this.domainList = new ArrayList();
        this.domainOptionList = new ArrayList();
        this.passwordFileList = new ArrayList();
        this.domainNSSPwdMapping = new HashMap();
        this.domainTargetNSSPwdMapping = new HashMap();
        this.domainJKSPwdMapping = new HashMap();
        this.domainJKSCAPwdMapping = new HashMap();
        this.domainssPwdFileMapping = new HashMap();
        this.domainTargetnssPwdFileMapping = new HashMap();
        this.domainNameMapping = new HashMap();
        this.domainCredentials = new HashMap();
    }

    public void setTargetDomainRoot(String targetDomainsRoot) {
        if (this.targetDomainRoot != null && this.targetDomainRoot.equals(targetDomainsRoot)) {
            return;
        }
        this.targetDomainRoot = targetDomainsRoot;
        try {
            String logPath = this.targetDomainRoot + File.separator + "upgrade.log";
            logger.info(this.stringManager.getString("upgrade.common.log_redirect") + logPath);
            LogService.initialize(logPath);
        }
        catch (Exception e) {
            logger.warning(e.getLocalizedMessage());
        }
    }

    public String getTargetDomainRoot() {
        return this.targetDomainRoot;
    }

    public void setSourceDomainRoot(String sourceDomainRoot) {
        this.sourceDomainRoot = sourceDomainRoot;
    }

    public String getSourceDomainRoot() {
        return this.sourceDomainRoot;
    }

    public String getSourceDomainPath() {
        return ((DomainInfo)this.getDomainMapping().get(this.currentDomain)).getDomainPath();
    }

    public String getSourceInstancePath() {
        String currentDomain = this.getCurrentDomain();
        String currentSourceInstance = this.getCurrentSourceInstance();
        DomainInfo dInfo = (DomainInfo)this.getDomainMapping().get(currentDomain);
        return dInfo.getInstancePath(currentSourceInstance);
    }

    public String getCurrentSourceInstance() {
        return this.currentSourceServerInstance;
    }

    public void setCurrentSourceInstance(String server) {
        this.currentSourceServerInstance = server;
    }

    public String getTargetConfig() {
        String config = this.getTargetDomainRoot() + File.separator + (String)this.domainNameMapping.get(this.currentDomain) + File.separator + CONFIG;
        return config;
    }

    public String getTargetJKSKeyStorePath() {
        String path = this.getTargetDomainRoot() + File.separator + (String)this.domainNameMapping.get(this.currentDomain) + File.separator + CONFIG + File.separator + CERT_FILE_NAME;
        return path;
    }

    public String getTargetTrustedJKSKeyStorePath() {
        String path = this.getTargetDomainRoot() + File.separator + (String)this.domainNameMapping.get(this.currentDomain) + File.separator + CONFIG + File.separator + TRUSTED_KEY_STORE;
        return path;
    }

    public String getSourceJKSKeyStorePath() {
        String path = this.getSourceDomainPath() + File.separator + CONFIG + File.separator + CERT_FILE_NAME;
        return path;
    }

    public String getSourceTrustedJKSKeyStorePath() {
        String path = this.getSourceDomainPath() + File.separator + CONFIG + File.separator + TRUSTED_KEY_STORE;
        return path;
    }

    public String getDestinationDomainPath() {
        return this.getDestinationDomainPath(this.currentDomain);
    }

    public String getDestinationDomainPath(String domainName) {
        String path = this.getTargetDomainRoot() + File.separator + (String)this.domainNameMapping.get(domainName);
        return path;
    }

    public void addDomainName(String domainName) {
        this.domainList.add(domainName);
    }

    public List getDomainList() {
        return this.domainList;
    }

    public void addDomainOptionName(String domainName) {
        this.domainOptionList.add(domainName);
    }

    public List getDomainOptionList() {
        return this.domainOptionList;
    }

    public String getCurrentDomain() {
        return this.currentDomain;
    }

    public void setCurrentDomain(String domainName) {
        this.currentDomain = domainName;
    }

    public boolean getCertificateConversionFlag() {
        return this.certificateConversionFlag;
    }

    public void setCertificateConversionFlag(boolean flag) {
        this.certificateConversionFlag = flag;
    }

    public String getSourceInstallDir() {
        return this.SOURCE_INSTALL_DIR;
    }

    public void setSourceInstallDir(String src) {
        this.SOURCE_INSTALL_DIR = src;
    }

    public String getTargetInstallDir() {
        return System.getProperty("com.sun.aas.installRoot");
    }

    public void setTargetInstallDir(String tgt) {
        this.TARGET_INSTALL_DIR = tgt;
    }

    public String getCertDbPassword() {
        Map instanceNSSPwdMap = (Map)this.domainNSSPwdMapping.get(this.currentDomain);
        return (String)instanceNSSPwdMap.get(this.currentSourceServerInstance);
    }

    public void setCertDbPassword(String pwd) {
        this.setCertDbPassword(this.currentDomain, this.currentSourceServerInstance, pwd);
    }

    public void setCertDbPassword(String domain, String pwd) {
        this.setCertDbPassword(domain, this.currentSourceServerInstance, pwd);
    }

    public void setCertDbPassword(String domain, String instance, String pwd) {
        HashMap<String, String> instanceNssPwdMap = (HashMap<String, String>)this.domainNSSPwdMapping.get(domain);
        if (instanceNssPwdMap == null) {
            instanceNssPwdMap = new HashMap<String, String>();
        }
        instanceNssPwdMap.put(instance, pwd);
        this.domainNSSPwdMapping.put(domain, instanceNssPwdMap);
    }

    public String getTargetCertDbPassword() {
        return (String)this.domainTargetNSSPwdMapping.get(this.currentDomain);
    }

    public void setTargetCertDbPassword(String pwd) {
        this.domainTargetNSSPwdMapping.put(this.currentDomain, pwd);
    }

    public void setTargetCertDbPassword(String domain, String pwd) {
        this.domainTargetNSSPwdMapping.put(domain, pwd);
    }

    public String[] getCertAliases() {
        return this.CERT_ALIASES;
    }

    public String getJksKeystorePassword() {
        return (String)this.domainJKSPwdMapping.get((String)this.domainNameMapping.get(this.currentDomain));
    }

    public void setJksKeystorePassword(String pwd) {
        this.domainJKSPwdMapping.put((String)this.domainNameMapping.get(this.currentDomain), pwd);
    }

    public void setJksKeystorePassword(String domain, String pwd) {
        this.domainJKSPwdMapping.put((String)this.domainNameMapping.get(this.currentDomain), pwd);
    }

    public String getJksCAKeystorePassword() {
        return (String)this.domainJKSCAPwdMapping.get((String)this.domainNameMapping.get(this.currentDomain));
    }

    public void setJksCAKeystorePassword(String pwd) {
        this.domainJKSCAPwdMapping.put((String)this.domainNameMapping.get(this.currentDomain), pwd);
    }

    public void setJksCAKeystorePassword(String domain, String pwd) {
        this.domainJKSCAPwdMapping.put((String)this.domainNameMapping.get(this.currentDomain), pwd);
    }

    public Hashtable getDomainMapping() {
        return this.domainMapping;
    }

    public void setDomainMapping(Hashtable domainMapping) {
        this.domainMapping = domainMapping;
    }

    public String getOSName() {
        return this.osName;
    }

    public void setOSName(String osName) {
        this.osName = osName;
    }

    public String getNSSPwdFile() {
        return (String)this.domainssPwdFileMapping.get(this.currentDomain);
    }

    public void setNSSPwdFile(String pwdFile) {
        this.domainTargetnssPwdFileMapping.put(this.currentDomain, pwdFile);
    }

    public String getTargetNSSPwdFile() {
        return (String)this.domainTargetnssPwdFileMapping.get(this.currentDomain);
    }

    public void setTargetNSSPwdFile(String pwdFile) {
        this.domainTargetnssPwdFileMapping.put(this.currentDomain, pwdFile);
    }

    public void setInstallConfig70(String config) {
        this.InstallConfig70 = config;
    }

    public String getInstallConfig70() {
        return this.InstallConfig70;
    }

    public Map getTargetDomainNameMapping() {
        return this.domainNameMapping;
    }

    public boolean isInPlace() {
        return this.isInPlace;
    }

    public void setIsInPlace(boolean isInPlace) {
        this.isInPlace = isInPlace;
    }

    public static Logger getDefaultLogger() {
        if (logger == null) {
            logger = LogService.getLogger("com.sun.enterprise.tools.upgrade");
        }
        return logger;
    }

    public boolean isUpgradeJKStoJKS() {
        String sourceVersionAndEdition = this.getSourceVersionAndEdition();
        return "as80pe".equals(sourceVersionAndEdition) || "as81pe".equals(sourceVersionAndEdition);
    }

    public boolean isUpgradeJKStoNSS() {
        return false;
    }

    public boolean isUpgradeNSStoNSS() {
        String sourceVersionAndEdition = this.getSourceVersionAndEdition();
        return "as81ee".equals(sourceVersionAndEdition);
    }

    public boolean isUpgradeNSStoJKS() {
        return false;
    }

    public boolean checkUpgradefrom8xpeto9x() {
        boolean checkUpgradefrom8xpeto9x = false;
        String sourceVersionAndEdition = this.getSourceVersionAndEdition();
        String targetVersion = this.getTargetVersion();
        checkUpgradefrom8xpeto9x = ("as80pe".equals(sourceVersionAndEdition) || "as81pe".equals(sourceVersionAndEdition) || "as82pe".equals(sourceVersionAndEdition)) && "9.1".equals(targetVersion);
        return checkUpgradefrom8xpeto9x;
    }

    public boolean checkUpgradefrom8xeeto9x() {
        boolean checkUpgradefrom8xeeto9x = false;
        String sourceVersionAndEdition = this.getSourceVersionAndEdition();
        String targetVersion = this.getTargetVersion();
        checkUpgradefrom8xeeto9x = ("as81ee".equals(sourceVersionAndEdition) || "as82ee".equals(sourceVersionAndEdition)) && "9.1".equals(targetVersion);
        return checkUpgradefrom8xeeto9x;
    }

    public boolean checkUpgradefrom9xpeto9x() {
        boolean checkUpgradefrom9xpeto9x = false;
        String sourceVersionAndEdition = this.getSourceVersionAndEdition();
        String targetVersion = this.getTargetVersion();
        checkUpgradefrom9xpeto9x = "as90pe".equals(sourceVersionAndEdition) && "9.1".equals(targetVersion);
        return checkUpgradefrom9xpeto9x;
    }

    public boolean checkUpgrade8xto9x() {
        boolean checkUpgrade8xto9x = false;
        checkUpgrade8xto9x = this.checkUpgradefrom8xpeto9x() || this.checkUpgradefrom8xeeto9x();
        return checkUpgrade8xto9x;
    }

    public boolean checkUpgrade9xto9x() {
        boolean checkUpgrade9xto9x = false;
        checkUpgrade9xto9x = this.checkUpgradefrom9xpeto9x();
        return checkUpgrade9xto9x;
    }

    public void enlistDomainsFromSource() {
        if (this.enlistDomain) {
            return;
        }
        String source = this.getSourceInstallDir();
        if (source == null) {
            return;
        }
        if (source.endsWith(File.separator)) {
            source = source.substring(0, source.length() - File.separator.length());
        }
        String domainName = source.substring(source.lastIndexOf(File.separator) + File.separator.length(), source.length());
        String domainRoot = source.substring(0, source.lastIndexOf(domainName) - File.separator.length());
        this.setSourceDomainRoot(domainRoot);
        this.setSourceDomainRootFlag(true);
        this.setDomainMapping(UpgradeUtils.getUpgradeUtils(this).enlistDomains(domainName, domainRoot));
        this.enlistDomain = true;
    }

    private boolean sourceIsDomain() {
        return UpgradeUtils.getUpgradeUtils(this).checkSourceInputAsDomain();
    }

    public boolean isValid70Domain(String domainPath) {
        return UpgradeUtils.getUpgradeUtils(this).isValid70Domain(domainPath);
    }

    public boolean getSourceDomainRootFlag() {
        return this.sourceInputAsDomainRoot;
    }

    public void setSourceDomainRootFlag(boolean fl) {
        this.sourceInputAsDomainRoot = fl;
    }

    public void printInfo() {
        CommonInfoModel.getDefaultLogger().finest("SOURCE_INSTALL_DIR==" + this.SOURCE_INSTALL_DIR);
        CommonInfoModel.getDefaultLogger().finest("SOURCE_INSTALL_DIR==" + this.TARGET_INSTALL_DIR);
        int size = this.domainList.size();
        for (int i = 0; i < size; ++i) {
            String domainName = (String)this.domainList.get(i);
            CommonInfoModel.getDefaultLogger().finest("**********" + domainName + "****************");
            CommonInfoModel.getDefaultLogger().finest("NSSPWD==" + this.domainNSSPwdMapping.get(domainName));
            CommonInfoModel.getDefaultLogger().finest("JKSPWD==" + this.domainJKSPwdMapping.get(domainName));
            CommonInfoModel.getDefaultLogger().finest("********************************************");
        }
    }

    public String getSourceServerPolicyFileName() {
        return this.getSourceDomainPath() + File.separator + CONFIG + File.separator + SERVER_POLICY_FILE;
    }

    public String getTargetServerPolicyFileName() {
        return this.getDestinationDomainPath() + File.separator + CONFIG + File.separator + SERVER_POLICY_FILE;
    }

    public String getSourceDefaultWebXMLFileName() {
        return this.getSourceDomainPath() + File.separator + CONFIG + File.separator + DEFAULT_WEB_XML_FILE;
    }

    public String getTargetDefaultWebXMLFileName() {
        return this.getDestinationDomainPath() + File.separator + CONFIG + File.separator + DEFAULT_WEB_XML_FILE;
    }

    public String getSourceSunACCFileName() {
        return this.getSourceDomainPath() + File.separator + CONFIG + File.separator + SUN_ACC_XML_FILE;
    }

    public String getTargetSunACCFileName() {
        return this.getDestinationDomainPath() + File.separator + CONFIG + File.separator + SUN_ACC_XML_FILE;
    }

    public String getSourceConfigXMLFile() {
        return this.getSourceDomainPath() + File.separator + CONFIG + File.separator + DOMAIN_XML_FILE;
    }

    public String getTargetConfigXMLFile() {
        return this.getDestinationDomainPath() + File.separator + CONFIG + File.separator + DOMAIN_XML_FILE;
    }

    public String getSourceVersionAndEdition() {
        String sourceInstallDir;
        if (this.sourceVersionEdition == null && (sourceInstallDir = this.getSourceInstallDir()) != null) {
            this.sourceVersionEdition = new VersionExtracter(sourceInstallDir, this).getVersion();
        }
        return this.sourceVersionEdition;
    }

    public void clearSourceAndTargetVersions() {
        this.sourceVersionEdition = null;
    }

    public String getSourceVersion() {
        if (this.sourceVersion == null) {
            this.sourceVersion = UpgradeUtils.getUpgradeUtils(this).versionString(this.getSourceVersionAndEdition());
        }
        return this.sourceVersion;
    }

    public String getTargetVersion() {
        return this.targetVersion;
    }

    public String getSourceEdition() {
        if (this.sourceEdition == null) {
            this.sourceEdition = UpgradeUtils.getUpgradeUtils(this).editionString(this.getSourceVersionAndEdition());
        }
        return this.sourceEdition;
    }

    public String getTargetDefaultProfile() {
        if (this.targetDefaultProfile == null) {
            this.targetDefaultProfile = new VersionExtracter(this.getTargetInstallDir(), this).getTargetDefaultProfile();
        }
        return this.targetDefaultProfile;
    }

    public boolean isUpgradeSupported() {
        String sourceVersionAndEdition = this.getSourceVersionAndEdition();
        String sourceVersion = this.getSourceVersion();
        String sourceEdition = this.getSourceEdition();
        String targetVersion = this.getTargetVersion();
        String targetDefaultProfile = this.getTargetDefaultProfile();
        String tmpKey = null;
        tmpKey = UpgradeConstants.isPreAS91Version(sourceVersion) ? sourceVersionAndEdition : sourceVersion;
        if (!((HashSet)UpgradeConstants.supportMap.get(tmpKey)).contains(targetVersion)) {
            logger.info(this.stringManager.getString("upgrade.common.upgrade_not_supported"));
            return false;
        }
        if ("ee".equals(sourceEdition)) {
            if ("developer".equals(targetDefaultProfile)) {
                if (!this.isInPlace()) {
                    if (this.isNssHadbFound()) {
                        return true;
                    }
                    logger.info(this.stringManager.getString("upgrade.common.upgrade_not_supported_EEDeveloperSBS"));
                    return false;
                }
                logger.info(this.stringManager.getString("upgrade.common.upgrade_not_supported_EEToDeveloper"));
                return false;
            }
            return true;
        }
        if ("pe".equals(sourceEdition)) {
            logger.log(Level.INFO, this.stringManager.getString("upgrade.common.developer_profile_created"));
            return true;
        }
        if ("cluster".equals(sourceEdition) && !targetDefaultProfile.equals("enterprise")) {
            logger.log(Level.INFO, this.stringManager.getString("upgrade.common.cluster_profile_created"));
            return true;
        }
        if (sourceEdition.equals(targetDefaultProfile)) {
            return true;
        }
        logger.info(this.stringManager.getString("upgrade.common.upgrade_not_supported"));
        return false;
    }

    public String getCurrentCluster() {
        return this.currentCluster;
    }

    public void setCurrentCluster(String clu) {
        this.currentCluster = clu;
    }

    public String findLatestDomainDir(String domainRoot) {
        UpgradeUtils upgrUtils = UpgradeUtils.getUpgradeUtils(this);
        return upgrUtils.findLatestDomainDir(domainRoot, this.currentDomain);
    }

    public String getAdminUserName() {
        return this.adminUserName;
    }

    public void setAdminUserName(String adminUserName) {
        this.adminUserName = adminUserName;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public String getPasswordFile() {
        if (this.passwordFilePath == null) {
            try {
                this.passwordFile = File.createTempFile("ugpw", null);
                FileWriter writer = new FileWriter(this.passwordFile);
                writer.write("AS_ADMIN_PASSWORD=" + this.getAdminPassword() + "\n");
                writer.write("AS_ADMIN_ADMINPASSWORD=" + this.getAdminPassword() + "\n");
                writer.write("AS_ADMIN_MASTERPASSWORD=" + this.getMasterPassword() + "\n");
                writer.close();
                this.passwordFilePath = this.passwordFile.getAbsolutePath();
            }
            catch (IOException ioe) {
                logger.severe(this.stringManager.getString("upgrade.common.general_exception") + " " + ioe.getMessage());
            }
        }
        return this.passwordFilePath;
    }

    public void setPasswordsFromFile(String path) {
        try {
            File userPasswordFile = new File(path);
            BufferedReader reader = new BufferedReader(new FileReader(userPasswordFile));
            while (reader.ready()) {
                String line = reader.readLine();
                if (line.startsWith("AS_ADMIN_PASSWORD=")) {
                    this.setAdminPassword(line.substring(line.indexOf("=") + 1));
                    continue;
                }
                if (line.startsWith("AS_ADMIN_ADMINPASSWORD=")) {
                    this.setAdminPassword(line.substring(line.indexOf("=") + 1));
                    continue;
                }
                if (!line.startsWith("AS_ADMIN_MASTERPASSWORD=")) continue;
                this.setMasterPassword(line.substring(line.indexOf("=") + 1));
            }
            reader.close();
        }
        catch (Exception e) {
            logger.severe(this.stringManager.getString("upgrade.common.general_exception") + " " + e.getMessage());
        }
    }

    public void setMasterPassword(String pw) {
        this.masterPassword = pw;
    }

    public String getMasterPassword() {
        return this.masterPassword;
    }

    public void deletePasswordFile() {
        if (this.passwordFile != null) {
            this.passwordFile.delete();
        }
    }

    public String getSourceInitConfFileName() {
        return null;
    }

    public void recover() {
        UpgradeUtils.getUpgradeUtils(this).recover();
    }

    public boolean processClinstnceConfFiles(Vector files) {
        return ClustersInfoManager.getClusterInfoManager().processClinstanceConfFiles(files);
    }

    public String getSourceWssServerConfigXML() {
        return this.getSourceDomainPath() + File.separator + CONFIG + File.separator + SOURCE_WSS_SERVER_CONFIG_XML;
    }

    public String getTargetWssServerConfigXML() {
        return this.getDestinationDomainPath() + File.separator + CONFIG + File.separator + TARGET_WSS_SERVER_CONFIG_XML;
    }

    public void setSourceApplicationRoot(String applRoot) {
        this.sourceApplicationRoot = applRoot;
    }

    public String getSourceApplicationRoot() {
        return this.sourceApplicationRoot;
    }

    public void setDomainCredentials(String dName, String dValues) {
        this.domainCredentials.put(dName, dValues);
    }

    public String getDomValuesFromPasswordFile(String domainName) {
        return (String)this.domainCredentials.get(domainName);
    }

    public void addPasswordFile(String passwordFile) {
        this.passwordFileList.add(passwordFile);
    }

    public List getPasswordFileList() {
        return this.passwordFileList;
    }

    public void processDomainXmlForClusters() {
        ClustersInfoManager.getClusterInfoManager().gatherClusterInfo(this);
    }

    public boolean isNssHadbFound() {
        String strHadbDir = this.getTargetInstallDir() + File.separator + HADB_DIR;
        File hadbDir = new File(strHadbDir);
        if (!hadbDir.exists()) {
            return false;
        }
        String[] hadbList = hadbDir.list();
        if (hadbList == null || hadbList.length <= 0) {
            return false;
        }
        String strHadbmJarFile = strHadbDir + File.separator + hadbList[0] + File.separator + "lib" + File.separator + HADBM_JAR_FILE;
        File hadbmJarFile = new File(strHadbmJarFile);
        return hadbmJarFile.exists();
    }

    public void setCliMode(boolean b) {
        this.cliMode = b;
    }

    public boolean getCliMode() {
        return this.cliMode;
    }

    public boolean isNoprompt() {
        return this.nopromptMode;
    }

    public void setNoprompt(boolean flag) {
        this.nopromptMode = flag;
    }

    public String getDefaultMasterPassword() {
        return this.AS_ADMIN_MASTERPASSWORD;
    }

    public boolean isEnterpriseEdition(String s) {
        boolean flag = false;
        if ("ee".equals(s) || "enterprise".equals(s)) {
            flag = true;
        }
        return flag;
    }

    public boolean isPlatformEdition(String s) {
        boolean flag = false;
        if ("pe".equals(s) || "developer".equals(s) || "cluster".equals(s)) {
            flag = true;
        }
        return flag;
    }
}

