/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.gui;

import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.DomainInfo;
import com.sun.enterprise.tools.upgrade.gui.util.DialogEvent;
import com.sun.enterprise.tools.upgrade.gui.util.DialogListener;
import com.sun.enterprise.tools.upgrade.gui.util.Utils;
import com.sun.enterprise.util.i18n.StringManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.TitledBorder;

public class AddDomainDialog
extends JDialog {
    private JComboBox domainsComboBox;
    private JComboBox instancesComboBox;
    private JPasswordField targetKeyDBPwdField;
    private JPasswordField sourceCertPwdField;
    private JPasswordField targetCertAuthPwdField;
    public static final int JKStoJKS = 1;
    public static final int NSStoNSS = 2;
    public static final int NSStoJKS = 3;
    public static final int JKStoNSS = 4;
    private int currentSourceToVersion;
    private StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.gui");
    private Logger logger = CommonInfoModel.getDefaultLogger();
    private List domainList;
    private List instanceList;
    private Hashtable domainMap;
    private CommonInfoModel commonInfo;
    private Vector dialogListeners = new Vector();

    public void addDialogListener(DialogListener listener) {
        this.dialogListeners.addElement(listener);
    }

    public void removeDialogListener(DialogListener listener) {
        this.dialogListeners.removeElement(listener);
    }

    public AddDomainDialog(Frame parent, boolean modal, CommonInfoModel commonInfo, int currentStoT) {
        super(parent, modal);
        this.setTitle(this.stringManager.getString("upgrade.gui.adddomainpanel.dialogTitle"));
        this.domainList = commonInfo.getDomainList();
        this.domainMap = commonInfo.getDomainMapping();
        this.instanceList = new ArrayList();
        this.currentSourceToVersion = currentStoT;
        this.commonInfo = commonInfo;
        this.initComponents();
    }

    /*
     * Unable to fully structure code
     */
    private void initComponents() {
        domainNameLabel = new JLabel();
        this.domainsComboBox = new JComboBox<E>();
        this.instancesComboBox = new JComboBox<E>();
        passwordPanel = null;
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AddDomainDialog.this.cancelButtonActionPerformed();
            }
        });
        this.domainsComboBox.setModel(new DefaultComboBoxModel<Object>(this.domainList.toArray()));
        this.domainsComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                AddDomainDialog.this.domainsComboBoxItemStateChanged();
            }
        });
        this.addComponetWithConstraints(this.domainsComboBox, this.getContentPane(), 0, 1, 1, 1, 2, new Insets(0, 10, 10, 60), 1.0, 0.0);
        if (this.commonInfo.getSourceVersion().equals("7x")) {
            domainNameLabel.setText(this.stringManager.getString("upgrade.gui.adddomainpanel.instanceBoxLabel"));
            dInfo = (DomainInfo)this.domainMap.get((String)this.domainsComboBox.getSelectedItem());
            this.instanceList = dInfo.getInstanceNames();
            this.instanceList.remove("admin-server");
            this.instancesComboBox.setModel(new DefaultComboBoxModel<Object>(this.instanceList.toArray()));
            this.instancesComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent evt) {
                    AddDomainDialog.this.instancesComboBoxItemStateChanged();
                }
            });
            this.addComponetWithConstraints(this.instancesComboBox, this.getContentPane(), 0, 2, 1, 1, 2, new Insets(0, 10, 10, 60), 1.0, 0.0);
        } else {
            domainNameLabel.setText(this.stringManager.getString("upgrade.gui.adddomainpanel.listBoxLabel"));
        }
        this.addComponetWithConstraints(domainNameLabel, this.getContentPane(), 0, 0, 1, 1, 2, new Insets(10, 10, 5, 60), 1.0, 0.0);
        if (this.currentSourceToVersion == 3) ** GOTO lbl-1000
        if (this.currentSourceToVersion == 4) lbl-1000:
        // 2 sources

        {
            passwordPanel = this.getPasswordPanelWith3Fields();
        } else {
            passwordPanel = this.getPasswordPanelWith2Fields();
        }
        this.addComponetWithConstraints(passwordPanel, this.getContentPane(), 0, 3, 1, 1, 1, new Insets(5, 10, 10, 60), 1.0, 1.0);
        this.addComponetWithConstraints(this.getButtonsPanel(), this.getContentPane(), 0, 4, 1, 1, 2, new Insets(0, 0, 0, 0), 1.0, 0.0);
        this.setSize(400, 350);
    }

    private void addComponetWithConstraints(JComponent compo, Container parent, int gx, int gy, int gw, int gh, int fill, Insets in, double wx, double wy) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gx;
        gridBagConstraints.gridy = gy;
        gridBagConstraints.gridwidth = gw;
        gridBagConstraints.gridheight = gh;
        gridBagConstraints.fill = fill;
        gridBagConstraints.insets = in;
        gridBagConstraints.weightx = wx;
        gridBagConstraints.weighty = wy;
        parent.add((Component)compo, gridBagConstraints);
    }

    private JPanel getPasswordPanelWith3Fields() {
        JPanel passwordPanel = new JPanel();
        JLabel sourceCertPwdLabel = new JLabel();
        this.sourceCertPwdField = new JPasswordField();
        JLabel targetKeyDBPwdLabel = new JLabel();
        this.targetKeyDBPwdField = new JPasswordField();
        this.targetCertAuthPwdField = new JPasswordField();
        JLabel targetCertAuthPwdLabel = new JLabel();
        passwordPanel.setLayout(new GridBagLayout());
        passwordPanel.setBorder(new TitledBorder(this.stringManager.getString("upgrade.gui.adddomainpanel.certTitleBorder")));
        String[] labelAndToolTipStrings = new String[6];
        if (this.currentSourceToVersion == 3) {
            labelAndToolTipStrings[0] = this.stringManager.getString("upgrade.gui.adddomainpanel.NSStoJKS.sourceCertLabelTooltip");
            labelAndToolTipStrings[1] = this.stringManager.getString("upgrade.gui.adddomainpanel.NSStoJKS.targetKeyDBTooltip");
            labelAndToolTipStrings[2] = this.stringManager.getString("upgrade.gui.adddomainpanel.NSStoJKS.targetCATooltip");
            labelAndToolTipStrings[3] = this.stringManager.getString("upgrade.gui.adddomainpanel.NSStoJKS.sourceCertLabel");
            labelAndToolTipStrings[4] = this.stringManager.getString("upgrade.gui.adddomainpanel.NSStoJKS.targetKeyDBLabel");
            labelAndToolTipStrings[5] = this.stringManager.getString("upgrade.gui.adddomainpanel.NSStoJKS.targetCALabel");
        } else {
            labelAndToolTipStrings[0] = this.stringManager.getString("upgrade.gui.adddomainpanel.JKStoNSS.sourceCertLabelTooltip");
            labelAndToolTipStrings[1] = this.stringManager.getString("upgrade.gui.adddomainpanel.JKStoNSS.targetKeyDBTooltip");
            labelAndToolTipStrings[2] = this.stringManager.getString("upgrade.gui.adddomainpanel.JKStoNSS.targetCATooltip");
            labelAndToolTipStrings[3] = this.stringManager.getString("upgrade.gui.adddomainpanel.JKStoNSS.sourceCertLabel");
            labelAndToolTipStrings[4] = this.stringManager.getString("upgrade.gui.adddomainpanel.JKStoNSS.targetKeyDBLabel");
            labelAndToolTipStrings[5] = this.stringManager.getString("upgrade.gui.adddomainpanel.JKStoNSS.targetCALabel");
        }
        sourceCertPwdLabel.setText(labelAndToolTipStrings[3]);
        sourceCertPwdLabel.setToolTipText(labelAndToolTipStrings[0]);
        this.addComponetWithConstraints(sourceCertPwdLabel, passwordPanel, 0, 0, 1, 1, 2, new Insets(5, 10, 5, 10), 1.0, 0.0);
        this.sourceCertPwdField.setToolTipText(labelAndToolTipStrings[0]);
        this.addComponetWithConstraints(this.sourceCertPwdField, passwordPanel, 0, 1, 1, 1, 2, new Insets(0, 10, 7, 10), 1.0, 0.0);
        targetKeyDBPwdLabel.setText(labelAndToolTipStrings[4]);
        targetKeyDBPwdLabel.setToolTipText(labelAndToolTipStrings[1]);
        this.addComponetWithConstraints(targetKeyDBPwdLabel, passwordPanel, 0, 2, 1, 1, 2, new Insets(5, 10, 5, 10), 1.0, 0.0);
        this.targetKeyDBPwdField.setToolTipText(labelAndToolTipStrings[1]);
        this.addComponetWithConstraints(this.targetKeyDBPwdField, passwordPanel, 0, 3, 1, 1, 2, new Insets(0, 10, 7, 10), 1.0, 0.0);
        targetCertAuthPwdLabel.setText(labelAndToolTipStrings[5]);
        targetCertAuthPwdLabel.setToolTipText(labelAndToolTipStrings[2]);
        this.addComponetWithConstraints(targetCertAuthPwdLabel, passwordPanel, 0, 4, 1, 1, 2, new Insets(5, 10, 5, 10), 1.0, 0.0);
        this.targetCertAuthPwdField.setToolTipText(labelAndToolTipStrings[2]);
        this.addComponetWithConstraints(this.targetCertAuthPwdField, passwordPanel, 0, 5, 1, 1, 2, new Insets(0, 10, 7, 10), 1.0, 0.0);
        return passwordPanel;
    }

    private JPanel getPasswordPanelWith2Fields() {
        JPanel passwordPanel = new JPanel();
        JLabel sourceCertPwdLabel = new JLabel();
        this.sourceCertPwdField = new JPasswordField();
        JLabel targetKeyDBPwdLabel = new JLabel();
        this.targetKeyDBPwdField = new JPasswordField();
        passwordPanel.setLayout(new GridBagLayout());
        passwordPanel.setBorder(new TitledBorder(this.stringManager.getString("upgrade.gui.adddomainpanel.certTitleBorder")));
        String[] labelAndToolTipStrings = new String[4];
        if (this.currentSourceToVersion == 1) {
            labelAndToolTipStrings[0] = this.stringManager.getString("upgrade.gui.adddomainpanel.JKStoJKS.sourceCertLabelTooltip");
            labelAndToolTipStrings[1] = this.stringManager.getString("upgrade.gui.adddomainpanel.JKStoJKS.targetKeyDBTooltip");
            labelAndToolTipStrings[2] = this.stringManager.getString("upgrade.gui.adddomainpanel.JKStoJKS.sourceCertLabel");
            labelAndToolTipStrings[3] = this.stringManager.getString("upgrade.gui.adddomainpanel.JKStoJKS.targetKeyDBLabel");
        } else {
            labelAndToolTipStrings[0] = this.stringManager.getString("upgrade.gui.adddomainpanel.NSStoNSS.sourceCertLabelTooltip");
            labelAndToolTipStrings[1] = this.stringManager.getString("upgrade.gui.adddomainpanel.NSStoNSS.targetKeyDBTooltip");
            labelAndToolTipStrings[2] = this.stringManager.getString("upgrade.gui.adddomainpanel.NSStoNSS.sourceCertLabel");
            labelAndToolTipStrings[3] = this.stringManager.getString("upgrade.gui.adddomainpanel.NSStoNSS.targetKeyDBLabel");
        }
        sourceCertPwdLabel.setText(labelAndToolTipStrings[2]);
        sourceCertPwdLabel.setToolTipText(labelAndToolTipStrings[0]);
        this.addComponetWithConstraints(sourceCertPwdLabel, passwordPanel, 0, 0, 1, 1, 2, new Insets(5, 10, 5, 10), 1.0, 0.0);
        this.sourceCertPwdField.setToolTipText(labelAndToolTipStrings[0]);
        this.addComponetWithConstraints(this.sourceCertPwdField, passwordPanel, 0, 1, 1, 1, 2, new Insets(0, 10, 7, 10), 1.0, 0.0);
        targetKeyDBPwdLabel.setText(labelAndToolTipStrings[3]);
        targetKeyDBPwdLabel.setToolTipText(labelAndToolTipStrings[1]);
        this.addComponetWithConstraints(targetKeyDBPwdLabel, passwordPanel, 0, 2, 1, 1, 2, new Insets(5, 10, 5, 10), 1.0, 0.0);
        this.targetKeyDBPwdField.setToolTipText(labelAndToolTipStrings[1]);
        this.addComponetWithConstraints(this.targetKeyDBPwdField, passwordPanel, 0, 3, 1, 1, 2, new Insets(0, 10, 7, 10), 1.0, 0.0);
        return passwordPanel;
    }

    private JPanel getButtonsPanel() {
        JPanel buttonsPanel = new JPanel();
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        JButton helpButton = new JButton();
        buttonsPanel.setLayout(new GridBagLayout());
        okButton.setText(this.stringManager.getString("upgrade.gui.adddomainpanel.okButtonText"));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddDomainDialog.this.okButtonActionPerformed();
            }
        });
        this.addComponetWithConstraints(okButton, buttonsPanel, 1, 0, 1, 1, 0, new Insets(5, 5, 10, 10), 0.0, 0.0);
        cancelButton.setText(this.stringManager.getString("upgrade.gui.adddomainpanel.cancelButtonText"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddDomainDialog.this.cancelButtonActionPerformed();
            }
        });
        this.addComponetWithConstraints(cancelButton, buttonsPanel, 2, 0, 1, 1, 0, new Insets(5, 5, 10, 10), 0.0, 0.0);
        helpButton.setText(this.stringManager.getString("upgrade.gui.adddomainpanel.helpButtonText"));
        helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddDomainDialog.this.helpButtonActionPerformed();
            }
        });
        this.addComponetWithConstraints(helpButton, buttonsPanel, 3, 0, 1, 1, 0, new Insets(5, 5, 10, 10), 0.0, 0.0);
        this.addComponetWithConstraints(new JPanel(), buttonsPanel, 0, 0, 1, 1, 2, new Insets(5, 5, 10, 10), 1.0, 0.0);
        if (Utils.getHelpBroker() != null) {
            Utils.getHelpBroker().enableHelpOnButton((Component)helpButton, "ADD_DOMAIN_DIALOG", null);
        }
        return buttonsPanel;
    }

    private void helpButtonActionPerformed() {
        DialogEvent de = new DialogEvent(this, 6);
        for (int i = 0; i < this.dialogListeners.size(); ++i) {
            ((DialogListener)this.dialogListeners.elementAt(i)).dialogProcessed(de);
        }
    }

    private void cancelButtonActionPerformed() {
        DialogEvent de = new DialogEvent(this, 2);
        for (int i = 0; i < this.dialogListeners.size(); ++i) {
            ((DialogListener)this.dialogListeners.elementAt(i)).dialogProcessed(de);
        }
    }

    private void okButtonActionPerformed() {
        DialogEvent de;
        block10: {
            Vector<Object> data;
            block9: {
                de = new DialogEvent(this, 5);
                data = new Vector<Object>();
                de.setObject(data);
                data.add(new Integer(this.currentSourceToVersion));
                data.add(this.domainsComboBox.getSelectedItem());
                if (this.instanceList.isEmpty()) {
                    data.add("server");
                } else {
                    data.add(this.instancesComboBox.getSelectedItem());
                }
                if (this.sourceCertPwdField.getPassword() != null && !"".equals(new String(this.sourceCertPwdField.getPassword()).trim())) {
                    data.add(new String(this.sourceCertPwdField.getPassword()));
                }
                if (this.targetKeyDBPwdField.getPassword() != null && !"".equals(new String(this.targetKeyDBPwdField.getPassword()).trim())) {
                    data.add(new String(this.targetKeyDBPwdField.getPassword()));
                }
                if (this.currentSourceToVersion == 3) break block9;
                if (this.currentSourceToVersion != 4) break block10;
            }
            if (this.targetCertAuthPwdField.getPassword() != null && !"".equals(new String(this.targetCertAuthPwdField.getPassword()).trim())) {
                data.add(new String(this.targetCertAuthPwdField.getPassword()));
            }
        }
        for (int i = 0; i < this.dialogListeners.size(); ++i) {
            ((DialogListener)this.dialogListeners.elementAt(i)).dialogProcessed(de);
        }
    }

    private void domainsComboBoxItemStateChanged() {
        DomainInfo dInfo = (DomainInfo)this.domainMap.get((String)this.domainsComboBox.getSelectedItem());
        this.instanceList = dInfo.getInstanceNames();
        if (this.commonInfo.getSourceVersion().equals("7x")) {
            this.instanceList.remove("admin-server");
        }
        this.instancesComboBox.setModel(new DefaultComboBoxModel<Object>(this.instanceList.toArray()));
    }

    private void instancesComboBoxItemStateChanged() {
    }

    public static void main(String[] args) {
    }

    public void clearFields() {
        this.sourceCertPwdField.setText("");
        this.targetKeyDBPwdField.setText("");
        if (this.targetCertAuthPwdField != null) {
            this.targetCertAuthPwdField.setText("");
        }
    }
}

