/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.transform.elements;

import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.DomainsProcessor;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.tools.upgrade.transform.elements.BaseElement;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HttpListener
extends BaseElement {
    private static Logger log = CommonInfoModel.getDefaultLogger();
    private final String HTTP_LISTENER_PORT_PROPERTY_NAME = "HTTP_LISTENER_PORT";

    public void transform(Element element, Element parentSource, Element parentResult) {
        this.logger.log(Level.FINE, this.stringManager.getString("upgrade.transform.transformingMSG", (Object)this.getClass().getName(), (Object)element));
        NodeList resultHttpListeners = parentResult.getElementsByTagName("http-listener");
        Element resultHttpListener = null;
        Vector<String> notToTransferAttrList = new Vector<String>();
        for (int lh = 0; lh < resultHttpListeners.getLength(); ++lh) {
            String resultElementID = ((Element)resultHttpListeners.item(lh)).getAttribute("id");
            if (element.getAttribute("id").equals(resultElementID)) {
                String instanceName;
                resultHttpListener = (Element)resultHttpListeners.item(lh);
                String propertyName = this.getHttpListenerPortProperty(resultElementID, resultHttpListener);
                if (commonInfoModel.getCurrentCluster() != null) {
                    notToTransferAttrList.add("port");
                    if (propertyName != null) {
                        String propertyValue = null;
                        if (!resultElementID.equals("http-listener-1")) {
                            propertyValue = element.getAttribute("port");
                        }
                        UpgradeUtils.getUpgradeUtils(commonInfoModel).updateListenerPortsForClusteredInstances(parentResult.getOwnerDocument().getDocumentElement(), propertyName, propertyValue, this);
                    }
                } else if (!commonInfoModel.isPlatformEdition(commonInfoModel.getSourceEdition()) && (instanceName = commonInfoModel.getCurrentSourceInstance()) != null && !"".equals(instanceName.trim())) {
                    notToTransferAttrList.add("port");
                    String propertyValue = element.getAttribute("port");
                    NodeList servers = parentResult.getOwnerDocument().getDocumentElement().getElementsByTagName("servers");
                    NodeList serverList = ((Element)servers.item(0)).getElementsByTagName("server");
                    UpgradeUtils.getUpgradeUtils(commonInfoModel).addOrUpdateSystemPropertyToServer(instanceName, serverList, propertyName, propertyValue, this);
                }
                this.transferAttributes(element, resultHttpListener, notToTransferAttrList);
            }
            if (!resultElementID.equals("admin-listener")) continue;
            String domainPath = commonInfoModel.getSourceDomainPath();
            String adminPort = DomainsProcessor.getSourceAdminPort(domainPath);
            String adminSecurity = DomainsProcessor.getSourceAdminSecurity(domainPath);
            ((Element)resultHttpListeners.item(lh)).setAttribute("port", adminPort);
            if (commonInfoModel.isEnterpriseEdition(commonInfoModel.getSourceEdition()) && adminSecurity.equals("false")) {
                ((Element)resultHttpListeners.item(lh)).setAttribute("security-enabled", "true");
                continue;
            }
            ((Element)resultHttpListeners.item(lh)).setAttribute("security-enabled", adminSecurity);
        }
        if (resultHttpListener == null) {
            resultHttpListener = parentResult.getOwnerDocument().createElement("http-listener");
            if (commonInfoModel.getCurrentCluster() != null) {
                notToTransferAttrList.add("port");
                String propertyName = element.getAttribute("id") + "_HTTP_LISTENER_PORT";
                UpgradeUtils.getUpgradeUtils(commonInfoModel).updateListenerPortsForClusteredInstances(parentResult.getOwnerDocument().getDocumentElement(), propertyName, element.getAttribute("port"), this);
                resultHttpListener.setAttribute("port", "${" + propertyName + "}");
            }
            this.transferAttributes(element, resultHttpListener, notToTransferAttrList);
            this.appendElementToParent(parentResult, resultHttpListener);
        }
        super.transform(element, parentSource, resultHttpListener);
    }

    public void transferAttributes(Element sourceEle, Element targetEle, List notToTransferAttrList) {
        notToTransferAttrList.add("acceptor-threads");
        this.logger.log(Level.FINE, this.getClass().getName() + ":: notToTransferAttrList ", notToTransferAttrList);
        super.transferAttributes(sourceEle, targetEle, notToTransferAttrList);
        if ("7x".equals(commonInfoModel.getSourceVersion())) {
            String serverID = sourceEle.getOwnerDocument().getDocumentElement().getAttribute("name");
            if (targetEle.getAttribute("default-virtual-server").equals(serverID)) {
                targetEle.setAttribute("default-virtual-server", "server");
            }
        }
    }

    private void printAttrs(Element ele) {
        NamedNodeMap sourceAttrNodeMap = ele.getAttributes();
        for (int index = 0; index < sourceAttrNodeMap.getLength(); ++index) {
            Node sourceAttrNode = sourceAttrNodeMap.item(index);
            log.info("******\n attr name=" + sourceAttrNode.getNodeName() + " attrValue=" + sourceAttrNode.getNodeValue());
        }
    }

    private String getHttpListenerPortProperty(String id, Element resultHttpListener) {
        if (id.equals("http-listener-1")) {
            return this.HTTP_LISTENER_PORT_PROPERTY_NAME;
        }
        String portValue = resultHttpListener.getAttribute("port");
        if (portValue != null && portValue.trim().startsWith("${")) {
            return portValue.substring(2, portValue.length() - 1);
        }
        return null;
    }
}

