/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.transform.elements;

import com.sun.enterprise.tools.upgrade.transform.elements.BaseElement;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JavaConfig
extends BaseElement {
    private List exludedJarList = null;

    public void transform(Element element, Element parentSource, Element parentResult) {
        this.logger.log(Level.FINE, this.stringManager.getString("upgrade.transform.transformingMSG", (Object)this.getClass().getName(), (Object)element.getTagName()));
        Vector<String> notToTransferAttrList = new Vector<String>();
        notToTransferAttrList.add("classpath-suffix");
        notToTransferAttrList.add("classpath-prefix");
        notToTransferAttrList.add("java-home");
        notToTransferAttrList.add("server-classpath");
        NodeList javaConfs = parentResult.getElementsByTagName("java-config");
        Element javaConf = null;
        if (commonInfoModel.checkUpgradefrom8xeeto9x()) {
            javaConf = (Element)javaConfs.item(0);
            this.appendSuffixToClasspath(element, javaConf);
            this.appendSystemClasspath(element, javaConf);
            if (javaConfs.getLength() != 0) {
                notToTransferAttrList.add("system-classpath");
                this.transferAttributes(element, javaConf, notToTransferAttrList);
            }
            this.updateClassPathAttributes(element, javaConf);
            super.transform(element, parentSource, javaConf);
            return;
        }
        this.logger.log(Level.FINE, this.stringManager.getString(this.getClass().getName() + ":: javaConfs.getLength() ", (Object)javaConfs.getLength()));
        if (javaConfs.getLength() == 0) {
            javaConf = parentResult.getOwnerDocument().createElement("java-config");
            this.transferAttributes(element, javaConf, notToTransferAttrList);
            this.updateClassPathAttributes(element, javaConf);
            this.appendElementToParent(parentResult, javaConf);
        } else {
            javaConf = (Element)javaConfs.item(0);
            this.transferAttributes(element, javaConf, notToTransferAttrList);
            this.updateClassPathAttributes(element, javaConf);
        }
        super.transform(element, parentSource, javaConf);
    }

    private void updateClassPathAttributes(Element source, Element target) {
        String cpToAppend;
        String cpPrefix;
        String cpToAppend2;
        String cpSuffix = source.getAttribute("classpath-suffix");
        if (cpSuffix != null && !cpSuffix.trim().equals("") && (cpToAppend2 = this.getClassPathStringToAppend(cpSuffix)) != null) {
            String targetCP = target.getAttribute("classpath-suffix");
            if (targetCP == null || targetCP.trim().equals("")) {
                target.setAttribute("classpath-suffix", cpToAppend2);
            } else {
                targetCP = targetCP + "${path.separator}" + cpToAppend2;
                target.setAttribute("classpath-suffix", targetCP);
            }
        }
        if ((cpPrefix = source.getAttribute("classpath-prefix")) != null && !cpPrefix.trim().equals("") && (cpToAppend = this.getClassPathStringToAppend(cpPrefix)) != null) {
            String targetCP = target.getAttribute("classpath-prefix");
            if (targetCP == null || targetCP.trim().equals("")) {
                target.setAttribute("classpath-prefix", cpToAppend);
            } else {
                targetCP = targetCP + "${path.separator}" + cpToAppend;
                target.setAttribute("classpath-prefix", targetCP);
            }
        }
    }

    private String getClassPathStringToAppend(String sourceCPString) {
        if (sourceCPString == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(sourceCPString, System.getProperty("path.separator"));
        String cpToAppend = null;
        if (this.exludedJarList == null) {
            this.buildExcludedJarList();
        }
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!this.isValidClassPathElement(token)) continue;
            if (cpToAppend == null) {
                cpToAppend = token;
                continue;
            }
            cpToAppend = cpToAppend + "${path.separator}" + token;
        }
        return cpToAppend;
    }

    private boolean isValidClassPathElement(String cp) {
        for (int i = 0; i < this.exludedJarList.size(); ++i) {
            if (cp.indexOf((String)this.exludedJarList.get(i)) == -1) continue;
            return false;
        }
        return true;
    }

    private void buildExcludedJarList() {
        if (this.exludedJarList != null) {
            return;
        }
        this.exludedJarList = new ArrayList();
        this.exludedJarList.add("pbclient42RE.jar");
        this.exludedJarList.add("sax.jar");
        this.exludedJarList.add("xalan.jar");
        this.exludedJarList.add("dom4j.jar");
        this.exludedJarList.add("xercesImpl.jar");
        this.exludedJarList.add("jaxp-api.jar");
        this.exludedJarList.add("jaxrpc-api.jar");
        this.exludedJarList.add("xmlsec.jar");
        this.exludedJarList.add("saaj-api.jar");
        this.exludedJarList.add("jaxrpc-impl.jar");
        this.exludedJarList.add("jaxrpc-spi.jar");
        this.exludedJarList.add("common-logging.jar");
        this.exludedJarList.add("saaj-impl.jar");
        this.exludedJarList.add("mail.jar");
        this.exludedJarList.add("activation.jar");
        this.exludedJarList.add("jaas.jar");
        this.exludedJarList.add("jdk_logging.jar");
        this.exludedJarList.add("servlet.jar");
        this.exludedJarList.add("xsltc.jar");
        this.exludedJarList.add("relaxngDatatype.jar");
        this.exludedJarList.add("xsdlib.jar");
        this.exludedJarList.add("jakarta-log4j.jar");
        this.exludedJarList.add("namespace.jar");
        this.exludedJarList.add("appserv-rt.jar");
        this.exludedJarList.add("jmxremote_optional.jar");
        this.exludedJarList.add("rmissl.jar");
        this.exludedJarList.add("appserv-tags.jar");
        this.exludedJarList.add("jsf-api.jar");
        this.exludedJarList.add("activation.jar");
        this.exludedJarList.add("appserv-upgrade.jar");
        this.exludedJarList.add("jsf-impl.jar");
        this.exludedJarList.add("admin-cli.jar");
        this.exludedJarList.add("appservLauncher.jar");
        this.exludedJarList.add("j2ee-svc.jar");
        this.exludedJarList.add("j2ee.jar");
        this.exludedJarList.add("sun-appserv-ant.jar");
        this.exludedJarList.add("jaxr-api.jar");
        this.exludedJarList.add("appserv-admin.jar");
        this.exludedJarList.add("jaxr-impl.jar");
        this.exludedJarList.add("appserv-assemblytool.jar");
        this.exludedJarList.add("jaxrpc-api.jar");
        this.exludedJarList.add("appserv-cmp.jar");
        this.exludedJarList.add("commons-launcher.jar");
        this.exludedJarList.add("appserv-ext.jar");
        this.exludedJarList.add("commons-logging.jar");
        this.exludedJarList.add("jhall.jar");
        this.exludedJarList.add("appserv-jstl.jar");
        this.exludedJarList.add("deployhelp.jar");
        this.exludedJarList.add("jmxremote.jar");
        this.exludedJarList.add("relaxngDatatype.jar");
        this.exludedJarList.add("jaxb-api.jar");
        this.exludedJarList.add("jaxb-impl.jar");
        this.exludedJarList.add("jaxb-libs.jar");
        this.exludedJarList.add("jaxb-xjc.jar");
        this.exludedJarList.add("jax-qname.jar");
        this.exludedJarList.add("namespace.jar");
    }

    public void appendSuffixToClasspath(Element source, Element javaConf) {
        String serverCP = javaConf.getAttribute("server-classpath");
        if (serverCP != null && !serverCP.trim().equals("")) {
            String modServerCP = serverCP + "${path.separator}${com.sun.aas.mfwkHome}/lib/mfwk_instrum_tk.jar";
            javaConf.setAttribute("server-classpath", modServerCP);
        }
    }

    public void appendSystemClasspath(Element source, Element javaConf) {
        String systemCP = javaConf.getAttribute("system-classpath");
        if (systemCP != null && !systemCP.trim().equals("")) {
            String modSystemCP = systemCP + "${path.separator}${com.sun.aas.installRoot}/lib/appserv-launch.jar";
            javaConf.setAttribute("system-classpath", modSystemCP);
        } else {
            javaConf.setAttribute("system-classpath", "${com.sun.aas.installRoot}/lib/appserv-launch.jar");
        }
    }
}

