/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.Collator;
import org.netbeans.modules.dbschema.DBElementProperties;
import org.netbeans.modules.dbschema.DBException;
import org.netbeans.modules.dbschema.DBIdentifier;

public abstract class DBElement
implements Comparable,
DBElementProperties {
    Impl impl;

    public DBElement() {
    }

    protected DBElement(Impl impl) {
        this.impl = impl;
        impl.attachToElement(this);
    }

    public final Impl getElementImpl() {
        return this.impl;
    }

    public void setElementImpl(Impl impl) {
        this.impl = impl;
        if (this.impl != null) {
            this.impl.attachToElement(this);
        }
    }

    public DBIdentifier getName() {
        DBIdentifier dBIdentifier = this.getElementImpl().getName();
        return dBIdentifier;
    }

    public final void setName(DBIdentifier dBIdentifier) throws DBException {
        this.getElementImpl().setName(dBIdentifier);
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getElementImpl().addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getElementImpl().removePropertyChangeListener(propertyChangeListener);
    }

    public String toString() {
        return this.getName().toString();
    }

    public int compareTo(Object object) {
        if (object == null) {
            throw new ClassCastException();
        }
        if (object == this) {
            return 0;
        }
        String string = this.getName().getFullName();
        String string2 = ((DBElement)object).getName().getFullName();
        if (string == null) {
            return string2 == null ? 0 : -1;
        }
        if (string2 == null) {
            return 1;
        }
        int n = Collator.getInstance().compare(string, string2);
        if (n == 0 && this.getClass() != object.getClass()) {
            n = this.getClass().getName().compareTo(object.getClass().getName());
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        return this.getClass() == object.getClass() && this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this.getName() != null && this.getName().getFullName() != null ? this.getName().getFullName().hashCode() : 0;
    }

    static abstract class Memory
    implements Impl {
        protected DBElement _element;
        private DBIdentifier _name;
        private PropertyChangeSupport support;

        public Memory() {
        }

        public Memory(DBElement dBElement) {
            this._name = dBElement.getName();
        }

        public void attachToElement(DBElement dBElement) {
            this._element = dBElement;
        }

        public final synchronized DBIdentifier getName() {
            if (this._name == null) {
                this._name = DBIdentifier.create("");
            }
            return this._name;
        }

        public synchronized void setName(DBIdentifier dBIdentifier) {
            DBIdentifier dBIdentifier2 = this._name;
            this._name = dBIdentifier;
            this.firePropertyChange("name", dBIdentifier2, dBIdentifier);
        }

        protected final void firePropertyChange(String string, Object object, Object object2) {
            if (this.support != null) {
                this.support.firePropertyChange(string, object, object2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.support == null) {
                Memory memory = this;
                synchronized (memory) {
                    if (this.support == null) {
                        this.support = new PropertyChangeSupport(this._element);
                    }
                }
            }
            this.support.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.support != null) {
                this.support.removePropertyChangeListener(propertyChangeListener);
            }
        }
    }

    public static interface Impl {
        public static final int ADD = 1;
        public static final int REMOVE = -1;
        public static final int SET = 0;

        public void attachToElement(DBElement var1);

        public DBIdentifier getName();

        public void setName(DBIdentifier var1) throws DBException;

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);
    }
}

