/*
 * Decompiled with CFR 0.152.
 */
package com.truchsess.faces.compound.component;

import com.truchsess.faces.compound.component.UICompoundChildComponent;
import com.truchsess.faces.compound.component.UICompoundParentComponent;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class UICompoundParentComponentDelegate
implements UICompoundParentComponent {
    transient UICompoundParentComponent outer;
    private Map facets = null;
    private List children = null;
    private static final Iterator EMPTY_ITERATOR = new Iterator(){

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Object next() {
            throw new NoSuchElementException("Empty Iterator");
        }

        public boolean hasNext() {
            return false;
        }
    };

    public UICompoundParentComponentDelegate(UICompoundParentComponent outer) {
        this.outer = outer;
    }

    public int getCompoundChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCompoundChildren() {
        if (this.children == null) {
            UICompoundParentComponentDelegate uICompoundParentComponentDelegate = this;
            synchronized (uICompoundParentComponentDelegate) {
                if (this.children == null) {
                    this.children = new ChildrenList(this.outer);
                }
            }
        }
        return this.children;
    }

    public int getCompoundFacetCount() {
        return this.facets == null ? 0 : this.facets.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getCompoundFacets() {
        if (this.facets == null) {
            UICompoundParentComponentDelegate uICompoundParentComponentDelegate = this;
            synchronized (uICompoundParentComponentDelegate) {
                if (this.facets == null) {
                    this.facets = new FacetsMap(this.outer);
                }
            }
        }
        return this.facets;
    }

    public Iterator getCompoundFacetsAndChildren() {
        if (this.facets == null && this.children == null) {
            return EMPTY_ITERATOR;
        }
        return new FacetsAndChildrenIterator(this);
    }

    private static void eraseParent(UICompoundChildComponent component) {
        List children;
        int index;
        UICompoundParentComponent parent = component.getCompoundParent();
        if (parent == null) {
            return;
        }
        if (parent.getCompoundChildCount() > 0 && (index = (children = parent.getCompoundChildren()).indexOf(component)) >= 0) {
            children.remove(index);
            return;
        }
        if (parent.getCompoundFacetCount() > 0) {
            Map facets = parent.getCompoundFacets();
            Iterator entries = facets.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                if (entry.getValue() != component) continue;
                entries.remove();
                return;
            }
        }
        throw new IllegalStateException("Parent was not null, but this component not related");
    }

    private static class ChildrenList
    extends ArrayList {
        private UICompoundParentComponent component;

        public ChildrenList(UICompoundParentComponent component) {
            this.component = component;
        }

        public void add(int index, Object element) {
            if (element == null) {
                throw new NullPointerException();
            }
            if (index < 0 || index > this.size()) {
                throw new IndexOutOfBoundsException();
            }
            UICompoundParentComponentDelegate.eraseParent((UICompoundChildComponent)element);
            ((UICompoundChildComponent)element).setCompoundParent(this.component);
            super.add(index, element);
        }

        public boolean add(Object element) {
            if (element == null) {
                throw new NullPointerException();
            }
            UICompoundParentComponentDelegate.eraseParent((UICompoundChildComponent)element);
            ((UICompoundChildComponent)element).setCompoundParent(this.component);
            return super.add(element);
        }

        public boolean addAll(Collection collection) {
            Iterator elements = new ArrayList(collection).iterator();
            boolean changed = false;
            while (elements.hasNext()) {
                UICompoundChildComponent element = (UICompoundChildComponent)elements.next();
                if (element == null) {
                    throw new NullPointerException();
                }
                this.add(element);
                changed = true;
            }
            return changed;
        }

        public boolean addAll(int index, Collection collection) {
            Iterator elements = new ArrayList(collection).iterator();
            boolean changed = false;
            while (elements.hasNext()) {
                UICompoundChildComponent element = (UICompoundChildComponent)elements.next();
                if (element == null) {
                    throw new NullPointerException();
                }
                this.add(index++, element);
                changed = true;
            }
            return changed;
        }

        public void clear() {
            int n = this.size();
            if (n < 1) {
                return;
            }
            int i = 0;
            while (i < n) {
                UICompoundChildComponent child = (UICompoundChildComponent)this.get(i);
                child.setCompoundParent(null);
                ++i;
            }
            super.clear();
        }

        public Iterator iterator() {
            return new ChildrenListIterator(this);
        }

        public ListIterator listIterator() {
            return new ChildrenListIterator(this);
        }

        public ListIterator listIterator(int index) {
            return new ChildrenListIterator(this, index);
        }

        public Object remove(int index) {
            UICompoundChildComponent child = (UICompoundChildComponent)this.get(index);
            super.remove(index);
            child.setCompoundParent(null);
            return child;
        }

        public boolean remove(Object elementObj) {
            UICompoundChildComponent element = (UICompoundChildComponent)elementObj;
            if (element == null) {
                throw new NullPointerException();
            }
            if (super.remove(element)) {
                element.setCompoundParent(null);
                return true;
            }
            return false;
        }

        public boolean removeAll(Collection collection) {
            boolean result = false;
            Iterator elements = collection.iterator();
            while (elements.hasNext()) {
                if (!this.remove(elements.next())) continue;
                result = true;
            }
            return result;
        }

        public boolean retainAll(Collection collection) {
            boolean modified = false;
            Iterator items = this.iterator();
            while (items.hasNext()) {
                if (collection.contains(items.next())) continue;
                items.remove();
                modified = true;
            }
            return modified;
        }

        public Object set(int index, Object element) {
            if (element == null) {
                throw new NullPointerException();
            }
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            UICompoundParentComponentDelegate.eraseParent((UICompoundChildComponent)element);
            UICompoundChildComponent previous = (UICompoundChildComponent)this.get(index);
            previous.setCompoundParent(null);
            ((UICompoundChildComponent)element).setCompoundParent(this.component);
            super.set(index, element);
            return previous;
        }
    }

    private static class ChildrenListIterator
    implements ListIterator {
        private ChildrenList list;
        private int index;
        private int last = -1;

        public ChildrenListIterator(ChildrenList list) {
            this.list = list;
            this.index = 0;
        }

        public ChildrenListIterator(ChildrenList list, int index) {
            this.list = list;
            if (index < 0 || index >= list.size()) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            this.index = index;
        }

        public boolean hasNext() {
            return this.index < this.list.size();
        }

        public Object next() {
            try {
                UICompoundChildComponent o = (UICompoundChildComponent)this.list.get(this.index);
                this.last = this.index++;
                return o;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException(String.valueOf(this.index));
            }
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            this.list.remove(this.last);
            if (this.last < this.index) {
                --this.index;
            }
            this.last = -1;
        }

        public void add(Object o) {
            if (!(o instanceof UICompoundChildComponent)) {
                throw new ClassCastException();
            }
            this.last = -1;
            this.list.add(this.index++, o);
        }

        public boolean hasPrevious() {
            return this.index > 1;
        }

        public int nextIndex() {
            return this.index;
        }

        public Object previous() {
            try {
                int current = this.index - 1;
                UICompoundChildComponent o = (UICompoundChildComponent)this.list.get(current);
                this.last = current;
                this.index = current;
                return o;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void set(Object o) {
            if (!(o instanceof UICompoundChildComponent)) {
                throw new ClassCastException();
            }
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            this.list.set(this.last, o);
        }
    }

    private static final class FacetsAndChildrenIterator
    implements Iterator {
        private Iterator iterator;
        private boolean childMode;
        private UICompoundParentComponent c;

        public FacetsAndChildrenIterator(UICompoundParentComponent c) {
            this.c = c;
            this.childMode = false;
        }

        private void update() {
            if (this.iterator == null) {
                if (this.c.getCompoundFacetCount() != 0) {
                    this.iterator = this.c.getCompoundFacets().values().iterator();
                    this.childMode = false;
                } else if (this.c.getCompoundChildCount() != 0) {
                    this.iterator = this.c.getCompoundChildren().iterator();
                    this.childMode = true;
                } else {
                    this.iterator = EMPTY_ITERATOR;
                    this.childMode = true;
                }
            } else if (!this.childMode && !this.iterator.hasNext() && this.c.getCompoundChildCount() != 0) {
                this.iterator = this.c.getCompoundChildren().iterator();
                this.childMode = true;
            }
        }

        public boolean hasNext() {
            this.update();
            return this.iterator.hasNext();
        }

        public Object next() {
            this.update();
            return (UICompoundChildComponent)this.iterator.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class FacetsMap
    extends HashMap {
        UICompoundParentComponent component;

        public FacetsMap(UICompoundParentComponent component) {
            this.component = component;
        }

        public void clear() {
            Iterator keys = this.keySet().iterator();
            while (keys.hasNext()) {
                keys.next();
                keys.remove();
            }
            super.clear();
        }

        public Set entrySet() {
            return new FacetsMapEntrySet(this);
        }

        public Set keySet() {
            return new FacetsMapKeySet(this);
        }

        public Object put(Object key, Object value) {
            if (key == null || value == null) {
                throw new NullPointerException();
            }
            if (!(key instanceof String) || !(value instanceof UICompoundChildComponent)) {
                throw new ClassCastException();
            }
            UICompoundChildComponent previous = (UICompoundChildComponent)super.get(key);
            if (previous != null) {
                previous.setCompoundParent(null);
            }
            UICompoundParentComponentDelegate.eraseParent((UICompoundChildComponent)value);
            ((UICompoundChildComponent)value).setCompoundParent(this.component);
            return super.put(key, value);
        }

        public void putAll(Map map) {
            if (map == null) {
                throw new NullPointerException();
            }
            Iterator entries = map.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                this.put((String)entry.getKey(), (UICompoundChildComponent)entry.getValue());
            }
        }

        public Object remove(Object key) {
            UICompoundChildComponent previous = (UICompoundChildComponent)this.get(key);
            if (previous != null) {
                previous.setCompoundParent(null);
            }
            super.remove(key);
            return previous;
        }

        public Collection values() {
            return new FacetsMapValues(this);
        }

        Iterator keySetIterator() {
            return new ArrayList(super.keySet()).iterator();
        }
    }

    private static class FacetsMapEntrySet
    extends AbstractSet {
        private FacetsMap map = null;

        public FacetsMapEntrySet(FacetsMap map) {
            this.map = map;
        }

        public boolean add(Map.Entry o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            this.map.clear();
        }

        public boolean contains(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Object v = e.getValue();
            if (!this.map.containsKey(k)) {
                return false;
            }
            if (v == null) {
                return this.map.get(k) == null;
            }
            return v.equals(this.map.get(k));
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public Iterator iterator() {
            return new FacetsMapEntrySetIterator(this.map);
        }

        public boolean remove(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Object k = ((Map.Entry)o).getKey();
            if (this.map.containsKey(k)) {
                this.map.remove(k);
                return true;
            }
            return false;
        }

        public boolean removeAll(Collection c) {
            boolean result = false;
            Iterator v = c.iterator();
            while (v.hasNext()) {
                if (!this.remove(v.next())) continue;
                result = true;
            }
            return result;
        }

        public boolean retainAll(Collection c) {
            boolean result = false;
            Iterator v = this.iterator();
            while (v.hasNext()) {
                if (c.contains(v.next())) continue;
                v.remove();
                result = true;
            }
            return result;
        }

        public int size() {
            return this.map.size();
        }
    }

    private static class FacetsMapEntrySetEntry
    implements Map.Entry {
        private FacetsMap map;
        private String key;

        public FacetsMapEntrySetEntry(FacetsMap map, String key) {
            this.map = map;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (this.key == null ? e.getKey() != null : !this.key.equals(e.getKey())) {
                return false;
            }
            UICompoundChildComponent v = (UICompoundChildComponent)this.map.get(this.key);
            return !(v == null ? e.getValue() != null : !v.equals(e.getValue()));
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return (UICompoundChildComponent)this.map.get(this.key);
        }

        public int hashCode() {
            Object value = this.map.get(this.key);
            return (this.key == null ? 0 : this.key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public Object setValue(Object value) {
            if (!(value instanceof UICompoundChildComponent)) {
                throw new ClassCastException();
            }
            UICompoundChildComponent previous = (UICompoundChildComponent)this.map.get(this.key);
            this.map.put(this.key, value);
            return previous;
        }
    }

    private static class FacetsMapEntrySetIterator
    implements Iterator {
        private FacetsMap map = null;
        private Iterator iterator = null;
        private Map.Entry last = null;

        public FacetsMapEntrySetIterator(FacetsMap map) {
            this.map = map;
            this.iterator = map.keySetIterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            this.last = new FacetsMapEntrySetEntry(this.map, (String)this.iterator.next());
            return this.last;
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.map.remove(this.last.getKey());
            this.last = null;
        }
    }

    private static class FacetsMapKeySet
    extends AbstractSet {
        private FacetsMap map = null;

        public FacetsMapKeySet(FacetsMap map) {
            this.map = map;
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            this.map.clear();
        }

        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        public boolean containsAll(Collection c) {
            Iterator v = c.iterator();
            while (v.hasNext()) {
                if (this.map.containsKey(v.next())) continue;
                return false;
            }
            return true;
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public Iterator iterator() {
            return new FacetsMapKeySetIterator(this.map);
        }

        public boolean remove(Object o) {
            if (this.map.containsKey(o)) {
                this.map.remove(o);
                return true;
            }
            return false;
        }

        public boolean removeAll(Collection c) {
            boolean result = false;
            Iterator v = c.iterator();
            while (v.hasNext()) {
                Object o = v.next();
                if (!this.map.containsKey(o)) continue;
                this.map.remove(o);
                result = true;
            }
            return result;
        }

        public boolean retainAll(Collection c) {
            boolean result = false;
            Iterator v = this.iterator();
            while (v.hasNext()) {
                if (c.contains(v.next())) continue;
                v.remove();
                result = true;
            }
            return result;
        }

        public int size() {
            return this.map.size();
        }
    }

    private static class FacetsMapKeySetIterator
    implements Iterator {
        private FacetsMap map = null;
        private Iterator iterator = null;
        private String last = null;

        public FacetsMapKeySetIterator(FacetsMap map) {
            this.map = map;
            this.iterator = map.keySetIterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            this.last = (String)this.iterator.next();
            return this.last;
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.map.remove(this.last);
            this.last = null;
        }
    }

    private static class FacetsMapValues
    extends AbstractCollection {
        private FacetsMap map;

        public FacetsMapValues(FacetsMap map) {
            this.map = map;
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            this.map.clear();
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public Iterator iterator() {
            return new FacetsMapValuesIterator(this.map);
        }

        public int size() {
            return this.map.size();
        }
    }

    private static class FacetsMapValuesIterator
    implements Iterator {
        private FacetsMap map = null;
        private Iterator iterator = null;
        private Object last = null;

        public FacetsMapValuesIterator(FacetsMap map) {
            this.map = map;
            this.iterator = map.keySetIterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            this.last = this.iterator.next();
            return (UICompoundChildComponent)this.map.get(this.last);
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.map.remove(this.last);
            this.last = null;
        }
    }
}

