/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.framework;

import com.sun.jbi.framework.EnvironmentContext;
import com.sun.jbi.framework.StringTranslator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarCache {
    Map mOpenJarFiles = new HashMap();
    Map mResourceIndex = Collections.synchronizedMap(new HashMap());
    URLStreamHandler mUrlStreamHandler = new JarStreamHandlerImpl();

    public URLStreamHandler getURLStreamHandler() {
        return this.mUrlStreamHandler;
    }

    public URL createURL(URL jarFileURL, String entry) throws MalformedURLException {
        URL url = new URL("jar", null, -1, jarFileURL.toString() + "!/" + (entry == null ? "" : entry), this.getURLStreamHandler());
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map map = this.mOpenJarFiles;
        synchronized (map) {
            for (JarFileImpl jarFile : this.mOpenJarFiles.values()) {
                try {
                    jarFile.closeImpl();
                }
                catch (IOException exc) {
                    exc.printStackTrace();
                }
            }
            this.mResourceIndex.clear();
            this.mOpenJarFiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getResourceAsStream(String fileName) {
        if ((fileName = fileName.replace('\\', '/')).startsWith("/")) {
            fileName = fileName.substring(1);
        } else if (fileName.startsWith("./")) {
            fileName = fileName.substring(2);
        }
        Object key = this.mResourceIndex.get(fileName);
        Map map = this.mOpenJarFiles;
        synchronized (map) {
            JarFile jarFile;
            if (key != null && (jarFile = (JarFile)this.mOpenJarFiles.get(key)) != null) {
                try {
                    JarEntry entry = jarFile.getJarEntry(fileName);
                    return jarFile.getInputStream(entry);
                }
                catch (IOException exc) {
                    throw new RuntimeException(exc);
                }
            }
            for (Map.Entry e : this.mOpenJarFiles.entrySet()) {
                JarFile jarFile2 = (JarFile)e.getValue();
                JarEntry entry = jarFile2.getJarEntry(fileName);
                if (entry == null) continue;
                try {
                    this.mResourceIndex.put(fileName, e.getKey());
                    return jarFile2.getInputStream(entry);
                }
                catch (IOException exc) {
                    throw new RuntimeException(exc);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL findResource(String fileName) {
        if ((fileName = fileName.replace('\\', '/')).startsWith("/")) {
            fileName = fileName.substring(1);
        } else if (fileName.startsWith("./")) {
            fileName = fileName.substring(2);
        }
        Object key = this.mResourceIndex.get(fileName);
        Map map = this.mOpenJarFiles;
        synchronized (map) {
            JarFile jarFile;
            if (key != null && (jarFile = (JarFile)this.mOpenJarFiles.get(key)) != null) {
                try {
                    return this.createURL(new File(jarFile.getName()).toURL(), fileName);
                }
                catch (MalformedURLException exc) {
                    throw new RuntimeException(exc);
                }
            }
            for (Map.Entry e : this.mOpenJarFiles.entrySet()) {
                JarFile jarFile2 = (JarFile)e.getValue();
                JarEntry entry = jarFile2.getJarEntry(fileName);
                if (entry == null) continue;
                try {
                    this.mResourceIndex.put(fileName, e.getKey());
                    return this.createURL(new File(jarFile2.getName()).toURL(), fileName);
                }
                catch (MalformedURLException exc) {
                    throw new RuntimeException(exc);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector findResources(String fileName) {
        if ((fileName = fileName.replace('\\', '/')).startsWith("/")) {
            fileName = fileName.substring(1);
        } else if (fileName.startsWith("./")) {
            fileName = fileName.substring(2);
        }
        Vector<URL> result = new Vector<URL>();
        Map map = this.mOpenJarFiles;
        synchronized (map) {
            for (JarFile jarFile : this.mOpenJarFiles.values()) {
                JarEntry entry = jarFile.getJarEntry(fileName);
                if (entry == null) continue;
                try {
                    result.add(this.createURL(new File(jarFile.getName()).toURL(), fileName));
                }
                catch (MalformedURLException exc) {
                    throw new RuntimeException(exc);
                }
            }
        }
        return result;
    }

    public void addJar(String fileName) throws IOException {
        try {
            this.addJar(new JarFileImpl(fileName));
        }
        catch (IOException e) {
            throw new RuntimeException("jar file: " + fileName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJar(JarFile file) throws IOException {
        if (null == file) {
            StringTranslator translator = (StringTranslator)EnvironmentContext.getInstance().getStringTranslatorFor(this);
            throw new IllegalArgumentException(translator.getString("NULL_ARGUMENT", "file"));
        }
        String name = file.getName();
        File f = new File(name);
        URL url = f.toURL();
        Map map = this.mOpenJarFiles;
        synchronized (map) {
            JarFileImpl prev = (JarFileImpl)this.mOpenJarFiles.get(url.getPath());
            if (prev != null) {
                prev.closeImpl();
            }
            this.mOpenJarFiles.put(url.getPath(), (JarFileImpl)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] getURLs() {
        LinkedList<URL> list = new LinkedList<URL>();
        Map map = this.mOpenJarFiles;
        synchronized (map) {
            Iterator iter = this.mOpenJarFiles.values().iterator();
            while (iter.hasNext()) {
                String fileName = ((JarFile)iter.next()).getName();
                try {
                    list.add(this.createURL(new File(fileName).toURL(), null));
                }
                catch (MalformedURLException exc) {
                    throw new RuntimeException(exc);
                }
            }
        }
        URL[] urls = new URL[list.size()];
        list.toArray(urls);
        return urls;
    }

    class JarStreamHandlerImpl
    extends URLStreamHandler {
        JarStreamHandlerImpl() {
        }

        protected URLConnection openConnection(URL url) throws IOException {
            return new JarURLConnectionImpl(url);
        }
    }

    public class JarURLConnectionImpl
    extends JarURLConnection {
        JarFile mJarFile;

        public JarURLConnectionImpl(URL url) throws MalformedURLException {
            super(url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JarFile getJarFile() throws IOException {
            if (this.mJarFile == null) {
                URL jarFileURL = this.getJarFileURL();
                Map map = JarCache.this.mOpenJarFiles;
                synchronized (map) {
                    this.mJarFile = (JarFile)JarCache.this.mOpenJarFiles.get(jarFileURL.getPath());
                    if (this.mJarFile == null) {
                        this.mJarFile = new JarFileImpl(jarFileURL.getPath());
                        JarCache.this.mOpenJarFiles.put(jarFileURL.getPath(), this.mJarFile);
                    }
                }
            }
            return this.mJarFile;
        }

        public InputStream getInputStream() throws IOException {
            return this.getJarFile().getInputStream(this.getJarFile().getEntry(this.getEntryName()));
        }

        public void connect() throws IOException {
        }
    }

    public static class JarFileImpl
    extends JarFile {
        public JarFileImpl(String name) throws IOException {
            super(name);
        }

        public void close() {
        }

        public void closeImpl() throws IOException {
            super.close();
        }

        protected void finalize() throws IOException {
            this.closeImpl();
        }
    }
}

