/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.config;

import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.util.EnvironmentAccess;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.XMLParseException;

public class DescriptorSupport
extends javax.management.modelmbean.DescriptorSupport {
    private static final String DESCRIPTOR_TYPE = "descriptorType";
    private static final String DESCRIPTOR_TYPE_VALUE = "attribute";
    private StringTranslator mTranslator;
    private Logger mLog;

    public DescriptorSupport() {
        this.setUnmutableFields();
    }

    DescriptorSupport(DescriptorSupport inDescr) {
        super(inDescr);
        this.setUnmutableFields();
    }

    DescriptorSupport(int initNumFields) throws MBeanException {
        super(initNumFields);
        this.setUnmutableFields();
    }

    DescriptorSupport(String inStr) throws MBeanException, XMLParseException {
        super(inStr);
        this.setUnmutableFields();
    }

    DescriptorSupport(String[] fields) {
        super(fields);
        this.setUnmutableFields();
    }

    DescriptorSupport(String[] fieldNames, Object[] fieldValues) {
        super(fieldNames, fieldValues);
        this.setUnmutableFields();
    }

    public void setAttributeName(String name) {
        this.setField(RequiredFieldName.ATTR_NAME.getFieldName(), name);
    }

    public void setIsStatic(Boolean isStatic) {
        this.setField(RequiredFieldName.IS_STATIC.getFieldName(), isStatic);
    }

    public void setDefault(Object def) {
        this.setField(RequiredFieldName.DEFAULT.getFieldName(), def);
    }

    public void setDisplayName(String displayName) {
        this.setField(RequiredFieldName.DISPLAY_NAME.getFieldName(), displayName);
    }

    public void setDisplayNameId(String id) {
        this.setField(RequiredFieldName.DISPLAY_NAME_ID.getFieldName(), id);
    }

    public void setDescriptionId(String id) {
        this.setField(RequiredFieldName.DESCRIPTION_ID.getFieldName(), id);
    }

    public void setToolTip(String toolTip) {
        this.setField(RequiredFieldName.TOOL_TIP.getFieldName(), toolTip);
    }

    public void setToolTipId(String toolTipId) {
        this.setField(RequiredFieldName.TOOL_TIP_ID.getFieldName(), toolTipId);
    }

    public void setResourceBundleName(String bundleName) {
        this.setField(RequiredFieldName.RESOURCE_BUNDLE_NAME.getFieldName(), bundleName);
    }

    public void setMinValue(Object value) {
        this.setField(OptionalFieldName.MIN_VALUE.getFieldName(), value);
    }

    public void setMaxValue(Object value) {
        this.setField(OptionalFieldName.MAX_VALUE.getFieldName(), value);
    }

    public void setEnumValue(String value) {
        this.setField(OptionalFieldName.ENUM_VALUE.getFieldName(), value);
    }

    public void setUnit(String unit) {
        this.setField(OptionalFieldName.UNIT.getFieldName(), unit);
    }

    public boolean isValid() throws RuntimeOperationsException {
        boolean isValid = false;
        if (super.isValid()) {
            List<String> names = Arrays.asList(this.getFieldNames());
            for (RequiredFieldName fieldName : RequiredFieldName.values()) {
                if (!names.contains(fieldName.getFieldName())) {
                    String exMsg = this.getTranslator().getString("CS_DESCR_REQ_FIELD_MISSING", fieldName.getFieldName(), (String)this.getFieldValue("name"));
                    this.getLogger().warning(exMsg);
                    isValid = false;
                    break;
                }
                isValid = true;
            }
        }
        return isValid;
    }

    private void setUnmutableFields() {
        this.setField(DESCRIPTOR_TYPE, DESCRIPTOR_TYPE_VALUE);
    }

    private StringTranslator getTranslator() {
        if (this.mTranslator == null) {
            EnvironmentContext envCtx = EnvironmentAccess.getContext();
            this.mTranslator = envCtx.getStringTranslator("com.sun.jbi.management");
        }
        return this.mTranslator;
    }

    private Logger getLogger() {
        if (this.mLog == null) {
            this.mLog = Logger.getLogger("com.sun.jbi.management");
        }
        return this.mLog;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OptionalFieldName {
        MIN_VALUE("minValue"),
        MAX_VALUE("maxValue"),
        ENUM_VALUE("enumValue"),
        UNIT("unit");

        private String mFieldName;

        private OptionalFieldName(String name) {
            this.mFieldName = name;
        }

        public String getFieldName() {
            return this.mFieldName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequiredFieldName {
        ATTR_NAME("name"),
        IS_STATIC("isStatic"),
        DEFAULT("default"),
        DISPLAY_NAME("displayName"),
        DISPLAY_NAME_ID("displayNameId"),
        DESCRIPTION_ID("descriptionId"),
        TOOL_TIP("toolTip"),
        TOOL_TIP_ID("tootTipId"),
        RESOURCE_BUNDLE_NAME("resourceBundleName");

        private String mFieldName;

        private RequiredFieldName(String name) {
            this.mFieldName = name;
        }

        public String getFieldName() {
            return this.mFieldName;
        }
    }
}

