/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.config;

import com.sun.jbi.management.ConfigurationCategory;
import com.sun.jbi.management.config.RuntimeConfiguration;
import com.sun.jbi.management.registry.GenericQuery;
import com.sun.jbi.management.registry.Updater;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.JBIException;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanInfo;

public class InstanceConfiguration
extends RuntimeConfiguration {
    protected ConcurrentHashMap<String, Object> mOverridenAttributes;

    public InstanceConfiguration(ModelMBeanInfo mbeanInfo, ConfigurationCategory category) throws Exception {
        super(mbeanInfo, category, null);
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.persistDomainConfig();
        try {
            GenericQuery query = this.getRegistry().getGenericQuery();
            Updater updater = this.getRegistry().getUpdater();
            String attrValue = attribute.getValue() == null ? "null" : attribute.getValue().toString();
            String domainValue = query.getAttribute("domain", this.mCategory, attribute.getName());
            if (domainValue.equals(attrValue.toString())) {
                updater.deleteAttribute(this.mCategory, attribute.getName());
            } else {
                updater.setAttribute(this.mCategory, attribute.getName(), attrValue);
            }
        }
        catch (Exception ex) {
            String errMsg = InstanceConfiguration.getTranslator().getString("JBI_ADMIN_SET_CFG_ATTRIB_FAILED", attribute.getName(), this.mCategory.toString(), ex.getMessage());
            JBIException jbiEx = new JBIException(errMsg);
            throw new MBeanException((Exception)((Object)jbiEx), errMsg);
        }
    }

    public void deleteOverride(String attrName) throws Exception {
        Updater updater = this.getRegistry().getUpdater();
        updater.deleteAttribute(this.mCategory, attrName);
    }
}

