/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.facade;

import com.sun.jbi.ComponentInfo;
import com.sun.jbi.ComponentQuery;
import com.sun.jbi.ComponentState;
import com.sun.jbi.ComponentType;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.ServiceAssemblyQuery;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.management.message.MessageBuilder;
import com.sun.jbi.management.registry.GenericQuery;
import com.sun.jbi.management.registry.Registry;
import com.sun.jbi.management.registry.RegistryException;
import com.sun.jbi.management.registry.Updater;
import com.sun.jbi.management.repository.Archive;
import com.sun.jbi.management.repository.ArchiveType;
import com.sun.jbi.management.system.ManagementContext;
import com.sun.jbi.management.system.ManagementException;
import com.sun.jbi.management.util.FacadeMbeanHelper;
import com.sun.jbi.management.util.FileHelper;
import com.sun.jbi.management.util.FileTransfer;
import com.sun.jbi.management.util.Validator;
import com.sun.jbi.management.util.ValidatorFactory;
import com.sun.jbi.management.util.ValidatorType;
import com.sun.jbi.platform.PlatformContext;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Facade {
    protected String mTarget;
    protected EnvironmentContext mEnvCtx;
    protected MBeanServer mMBeanSvr;
    protected MBeanNames mMBeanNames;
    protected MessageBuilder mMsgBuilder;
    protected PlatformContext mPlatform;
    protected StringTranslator mTranslator;
    protected ManagementContext mMgtCtx;
    protected Logger mLog;
    private Registry mRegistry;
    protected static final String DOMAIN = "domain";
    protected static final String WORKSPACE_ROOT = "workspace";

    public Facade(EnvironmentContext ctx, String target) throws ManagementException {
        this.mPlatform = ctx.getPlatformContext();
        this.mTarget = target;
        this.mEnvCtx = ctx;
        this.mTranslator = this.mEnvCtx.getStringTranslator("com.sun.jbi.management.facade");
        this.mLog = Logger.getLogger("com.sun.jbi.management");
        this.mMsgBuilder = new MessageBuilder(this.mTranslator);
        this.mMBeanNames = this.mEnvCtx.getMBeanNames();
        this.mMBeanSvr = this.mEnvCtx.getMBeanServer();
        this.mMgtCtx = new ManagementContext(ctx);
    }

    protected ComponentQuery getComponentQuery() throws ManagementException {
        try {
            return this.getRegistry().getComponentQuery(this.mTarget);
        }
        catch (RegistryException rex) {
            String errMsg = this.mMsgBuilder.buildExceptionMessage("getComponentQuery", (Throwable)((Object)rex));
            throw new ManagementException(errMsg);
        }
    }

    protected GenericQuery getGenericQuery() throws ManagementException {
        try {
            return this.getRegistry().getGenericQuery();
        }
        catch (RegistryException rex) {
            String errMsg = this.mMsgBuilder.buildExceptionMessage("getGenericQuery", (Throwable)((Object)rex));
            throw new ManagementException(errMsg);
        }
    }

    protected Updater getUpdater() throws ManagementException {
        try {
            return this.getRegistry().getUpdater();
        }
        catch (RegistryException rex) {
            String errMsg = this.mMsgBuilder.buildExceptionMessage("getUpdater", (Throwable)((Object)rex));
            throw new ManagementException(errMsg);
        }
    }

    protected ServiceAssemblyQuery getServiceAssemblyQuery() throws ManagementException {
        try {
            return this.getRegistry().getServiceAssemblyQuery(this.mTarget);
        }
        catch (RegistryException rex) {
            String errMsg = this.mMsgBuilder.buildExceptionMessage("ServiceAssemblyQuery", (Throwable)((Object)rex));
            throw new ManagementException(errMsg);
        }
    }

    protected Registry getRegistry() {
        return (Registry)this.mEnvCtx.getRegistry();
    }

    protected MBeanServerConnection getMBeanServerConnection(String serverName) throws ManagementException {
        try {
            return this.mPlatform.getMBeanServerConnection(serverName);
        }
        catch (Exception ex) {
            String msg = this.mMsgBuilder.buildExceptionMessage("getMBeanServerConnection", ex);
            throw new ManagementException(msg);
        }
    }

    protected void invokeRemoteVoidOperation(ObjectName mbeanName, String op, Object[] params, String[] sign, String serverName) throws ManagementException {
        this.mbeanRegistrationCheck(op, mbeanName, serverName);
        MBeanServerConnection svrConxn = this.getMBeanServerConnection(serverName);
        try {
            this.mLog.finest(this.mTranslator.getString("JBI_ADMIN_INVOKING_REMOTE_OPERATION", new String[]{op, mbeanName.toString(), serverName}));
            svrConxn.invoke(mbeanName, op, params, sign);
            this.mLog.finest(this.mTranslator.getString("JBI_ADMIN_DONE_INVOKING_REMOTE_OPERATION", new String[]{op, mbeanName.toString(), serverName}));
        }
        catch (JMException ex) {
            Throwable actualEx = FacadeMbeanHelper.stripJmException(ex);
            String errMsg = this.mMsgBuilder.buildExceptionMessage(op, actualEx);
            throw new ManagementException(errMsg);
        }
        catch (JMRuntimeException ex) {
            Throwable actualEx = FacadeMbeanHelper.stripJmException(ex);
            String errMsg = this.mMsgBuilder.buildExceptionMessage(op, actualEx);
            throw new ManagementException(errMsg);
        }
        catch (IOException ioex) {
            String msg = this.mMsgBuilder.buildExceptionMessage(op, ioex);
            throw new ManagementException(msg);
        }
    }

    protected Object invokeRemoteOperation(ObjectName mbeanName, String op, Object[] params, String[] sign, String serverName) throws ManagementException {
        this.mbeanRegistrationCheck(op, mbeanName, serverName);
        MBeanServerConnection svrConxn = this.getMBeanServerConnection(serverName);
        try {
            Object rslt;
            this.mLog.finest(this.mTranslator.getString("JBI_ADMIN_INVOKING_REMOTE_OPERATION", new String[]{op, mbeanName.toString(), serverName}));
            if (op.startsWith("get") && params != null && params.length == 0) {
                String attr = op.substring("get".length());
                rslt = svrConxn.getAttribute(mbeanName, attr);
            } else {
                rslt = svrConxn.invoke(mbeanName, op, params, sign);
            }
            this.mLog.finest(this.mTranslator.getString("JBI_ADMIN_DONE_INVOKING_REMOTE_OPERATION", new String[]{op, mbeanName.toString(), serverName}));
            return rslt;
        }
        catch (JMException ex) {
            Throwable actualEx = FacadeMbeanHelper.stripJmException(ex);
            String errMsg = this.mMsgBuilder.buildExceptionMessage(op, actualEx);
            throw new ManagementException(errMsg);
        }
        catch (JMRuntimeException ex) {
            Throwable actualEx = FacadeMbeanHelper.stripJmException(ex);
            String errMsg = this.mMsgBuilder.buildExceptionMessage(op, actualEx);
            throw new ManagementException(errMsg);
        }
        catch (IOException ioex) {
            String msg = this.mMsgBuilder.buildExceptionMessage(op, ioex);
            throw new ManagementException(msg);
        }
    }

    protected Object invokeLocalOperation(ObjectName mbeanName, String op, Object[] params, String[] sign) throws ManagementException {
        this.mbeanRegistrationCheck(op, mbeanName);
        try {
            this.mLog.finest(this.mTranslator.getString("JBI_ADMIN_INVOKING_LOCAL_OPERATION", new String[]{op, mbeanName.toString()}));
            Object rslt = this.mMBeanSvr.invoke(mbeanName, op, params, sign);
            this.mLog.finest(this.mTranslator.getString("JBI_ADMIN_DONE_INVOKING_LOCAL_OPERATION", new String[]{op, mbeanName.toString()}));
            return rslt;
        }
        catch (JMException ex) {
            Throwable actualEx = FacadeMbeanHelper.stripJmException(ex);
            String errMsg = this.mMsgBuilder.buildExceptionMessage(op, actualEx);
            throw new ManagementException(errMsg);
        }
        catch (JMRuntimeException ex) {
            Throwable actualEx = FacadeMbeanHelper.stripJmException(ex);
            String errMsg = this.mMsgBuilder.buildExceptionMessage(op, actualEx);
            throw new ManagementException(errMsg);
        }
    }

    protected ComponentType getComponentType(String componentName) throws ManagementException {
        ComponentType compType = null;
        try {
            compType = this.getGenericQuery().getComponentType(componentName);
        }
        catch (RegistryException rex) {
            this.mLog.warning(rex.getMessage());
            throw new ManagementException(this.mMsgBuilder.buildExceptionMessage("getComponentType", (Throwable)((Object)rex)));
        }
        return compType;
    }

    protected String getComponentStateOnInstance(String compName, String instanceName) throws ManagementException {
        if (this.isInstanceRunning(instanceName)) {
            String[] sign = new String[]{};
            Object[] params = new Object[]{};
            ObjectName compLCName = this.getComponentLifeCycleMBeanName(compName, this.getComponentType(compName), instanceName);
            String state = (String)this.invokeRemoteOperation(compLCName, "getCurrentState", params, sign, instanceName);
            this.mLog.finer(this.mTranslator.getString("JBI_ADMIN_CURRENT_STATE_ON_INSTANCE", compName, instanceName, state));
            return state;
        }
        return "Shutdown";
    }

    protected ComponentState getComponentState(String compName, String instanceName) throws ManagementException {
        String state = this.getComponentStateOnInstance(compName, instanceName);
        return ComponentState.valueOfLifeCycleState(state);
    }

    protected boolean isComponentInstalled(String compName) throws ManagementException {
        boolean isInstalled = false;
        ComponentInfo compInfo = this.getComponentQuery().getComponentInfo(compName);
        if (compInfo == null) {
            this.mLog.fine("Component " + compName + " is not installed on target " + this.mTarget);
            isInstalled = false;
        } else {
            isInstalled = true;
        }
        return isInstalled;
    }

    protected ObjectName getFacadeInstallerMBeanName(String componentName) throws ManagementException {
        ComponentType compType = this.getComponentType(componentName);
        return this.getFacadeInstallerMBeanName(componentName, compType);
    }

    protected ObjectName getFacadeInstallerMBeanName(String componentName, ComponentType compType) throws ManagementException {
        ObjectName instName = null;
        if (ComponentType.BINDING.equals((Object)compType)) {
            instName = this.mMBeanNames.getBindingMBeanName(componentName, MBeanNames.ComponentServiceType.Installer, this.mTarget);
        } else if (ComponentType.ENGINE.equals((Object)compType)) {
            instName = this.mMBeanNames.getEngineMBeanName(componentName, MBeanNames.ComponentServiceType.Installer, this.mTarget);
        } else {
            String[] params = new String[]{componentName};
            this.mMsgBuilder.throwManagementException("getFacadeInstallerMBeanName", "JBI_ADMIN_UNKNOWN_COMPONENT", params);
        }
        return instName;
    }

    protected File fromFileURL(String urlStr) {
        try {
            if (urlStr.startsWith("file:")) {
                urlStr = new URL(urlStr).getPath();
            }
        }
        catch (MalformedURLException badURLEx) {
            this.mLog.info(this.mTranslator.getString("JBI_ADMIN_BAD_INSTALL_URL", new String[]{urlStr, badURLEx.getMessage()}));
        }
        return new File(urlStr);
    }

    protected String toFileURL(String urlStr) {
        try {
            if (!urlStr.startsWith("file:")) {
                urlStr = new File(urlStr).toURL().toString();
            }
        }
        catch (MalformedURLException badURLEx) {
            this.mLog.info(this.mTranslator.getString("JBI_ADMIN_BAD_INSTALL_URL", new String[]{urlStr, badURLEx.getMessage()}));
        }
        return urlStr;
    }

    protected Archive validateArchive(String archiveZipUrl, ArchiveType expectedType, String taskId) throws ManagementException {
        Archive archive = null;
        try {
            ValidatorFactory.setDescriptorValidation(true);
            Validator validator = ValidatorFactory.createValidator(this.mEnvCtx, this.getValidatorType(expectedType));
            File archiveFile = this.fromFileURL(archiveZipUrl);
            if (validator != null) {
                validator.validate(archiveFile);
                archive = new Archive(archiveFile, false);
            } else {
                archive = new Archive(archiveFile, true);
            }
        }
        catch (Exception ex) {
            throw new ManagementException(this.mMsgBuilder.buildExceptionMessage(taskId, ex));
        }
        if (!expectedType.equals(archive.getType())) {
            String[] params = new String[]{archiveZipUrl, expectedType.toString()};
            this.mMsgBuilder.throwManagementException(taskId, "JBI_ADMIN_INVALID_ARCHIVE_TYPE", params);
        }
        return archive;
    }

    static String listToString(List<String> list) {
        Iterator<String> itr = list.iterator();
        StringBuffer buff = new StringBuffer();
        buff.append((Object)itr.next());
        while (itr.hasNext()) {
            buff.append(", ");
            buff.append((Object)itr.next());
        }
        return buff.toString();
    }

    private void mbeanRegistrationCheck(String op, ObjectName mbeanName, String serverName) throws ManagementException {
        MBeanServerConnection svrConxn = this.getMBeanServerConnection(serverName);
        boolean isRegistered = false;
        try {
            isRegistered = svrConxn.isRegistered(mbeanName);
        }
        catch (IOException ioex) {
            throw new ManagementException(this.mMsgBuilder.buildExceptionMessage(op, ioex));
        }
        if (!isRegistered) {
            Object[] params = new String[]{mbeanName.toString(), serverName};
            String errMsg = this.mTranslator.getString("JBI_ADMIN_MBEAN_NOT_REGISTERED", params);
            String jbiTaskMsg = this.mMsgBuilder.buildFrameworkMessage(op, MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
            throw new ManagementException(jbiTaskMsg);
        }
    }

    private void mbeanRegistrationCheck(String op, ObjectName mbeanName) throws ManagementException {
        boolean isRegistered = this.mMBeanSvr.isRegistered(mbeanName);
        if (!isRegistered) {
            Object[] params = new String[]{mbeanName.toString()};
            String errMsg = this.mTranslator.getString("JBI_ADMIN_LOCAL_MBEAN_NOT_REGISTERED", params);
            String jbiTaskMsg = this.mMsgBuilder.buildFrameworkMessage(op, MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
            throw new ManagementException(jbiTaskMsg);
        }
    }

    protected boolean isInstanceRunning(String instanceName) throws ManagementException {
        boolean isInstanceRunning = false;
        try {
            isInstanceRunning = this.mPlatform.isInstanceUp(instanceName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String msg = this.mMsgBuilder.buildExceptionMessage("isInstanceRunning", ex);
            throw new ManagementException(msg);
        }
        if (!isInstanceRunning) {
            this.mLog.fine("Instance " + instanceName + " is not up");
        }
        return isInstanceRunning;
    }

    protected String uploadFile(String serverName, String localFile) throws ManagementException {
        String uploadedPath = null;
        try {
            FileTransfer ft = new FileTransfer(serverName, this.mMBeanNames, this.mPlatform.getMBeanServerConnection(serverName));
            uploadedPath = ft.uploadFile(localFile);
        }
        catch (Exception ex) {
            String msg = this.mMsgBuilder.buildExceptionMessage("uploadFile", ex);
            throw new ManagementException(msg);
        }
        return uploadedPath;
    }

    protected void sharedLibraryInstallationCheck(String slName, boolean throwExWhenInstalled) throws ManagementException {
        boolean isInstalled = this.isSharedLibraryInstalled(slName);
        if (isInstalled && throwExWhenInstalled) {
            Object[] params = new String[]{slName, this.mTarget};
            String errMsg = this.mTranslator.getString("JBI_ADMIN_SHARED_LIBRARY_INSTALLED_ON_TARGET", params);
            String jbiTaskMsg = this.mMsgBuilder.buildFrameworkMessage("sharedLibraryInstallationCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
            throw new ManagementException(jbiTaskMsg);
        }
        if (!isInstalled && !throwExWhenInstalled) {
            Object[] params = new String[]{slName, this.mTarget};
            String errMsg = this.mTranslator.getString("JBI_ADMIN_SHARED_LIBRARY_NOT_INSTALLED_ON_TARGET", params);
            String jbiTaskMsg = this.mMsgBuilder.buildFrameworkMessage("sharedLibraryInstallationCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
            throw new ManagementException(jbiTaskMsg);
        }
    }

    protected boolean isSharedLibraryInstalled(String slName) throws ManagementException {
        List<String> targets = null;
        try {
            if (DOMAIN.equals(this.mTarget)) {
                return this.getGenericQuery().isSharedLibraryInstalled(slName);
            }
            targets = this.mPlatform.isStandaloneServer(this.mTarget) ? this.getGenericQuery().getServersInstallingSharedLibrary(slName) : this.getGenericQuery().getClustersInstallingSharedLibrary(slName);
            return targets.contains(this.mTarget);
        }
        catch (RegistryException rex) {
            String errMsg = this.mMsgBuilder.buildExceptionMessage("sharedLibraryInstallationCheck", (Throwable)((Object)rex));
            throw new ManagementException(errMsg);
        }
    }

    protected void componentInstallationCheck(String componentName, boolean throwExWhenInstalled) throws ManagementException {
        boolean isInstalled = this.isComponentInstalled(componentName);
        if (isInstalled && throwExWhenInstalled) {
            Object[] params = new String[]{componentName, this.mTarget};
            String errMsg = this.mTranslator.getString("JBI_ADMIN_COMPONENT_INSTALLED_ON_TARGET", params);
            String jbiTaskMsg = this.mMsgBuilder.buildFrameworkMessage("componentInstallationCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
            throw new ManagementException(jbiTaskMsg);
        }
        if (!isInstalled && !throwExWhenInstalled) {
            Object[] params = new String[]{componentName, this.mTarget};
            String errMsg = this.mTranslator.getString("JBI_ADMIN_COMPONENT_NOT_INSTALLED_ON_TARGET", params);
            String jbiTaskMsg = this.mMsgBuilder.buildFrameworkMessage("componentInstallationCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
            throw new ManagementException(jbiTaskMsg);
        }
    }

    protected void handleClusteredInstanceFailures(String taskId, Map<String, Throwable> exceptionMap, int numInstances, String locStrKey) throws ManagementException {
        if (exceptionMap.size() == numInstances) {
            String msg = this.mMsgBuilder.buildCompositeExceptionMessage(taskId, exceptionMap);
            throw new ManagementException(msg);
        }
        Set<String> instanceSet = exceptionMap.keySet();
        for (String instance : instanceSet) {
            this.mLog.warning(this.mTranslator.getString(locStrKey, instance, ((Exception)exceptionMap.get(instance)).getMessage()));
        }
    }

    protected ObjectName getComponentLifeCycleMBeanName(String componentName, ComponentType compType, String instanceName) {
        ObjectName compLCMBean = null;
        MBeanNames mbnNames = this.mMgtCtx.getMBeanNames(instanceName);
        compLCMBean = ComponentType.BINDING == compType ? mbnNames.getBindingMBeanName(componentName, "Lifecycle") : mbnNames.getEngineMBeanName(componentName, "Lifecycle");
        return compLCMBean;
    }

    protected void unregisterComponentLifeCycleMBean(String target, String compName) throws JBIException {
        ComponentType compType = this.getComponentType(compName);
        this.unregisterComponentLifeCycleMBean(target, compName, compType);
    }

    protected void unregisterComponentLifeCycleMBean(String target, String compName, ComponentType compType) throws JBIException {
        ObjectName compLCName = FacadeMbeanHelper.getComponentLifeCycleFacadeMBeanName(compName, compType, target, this.mEnvCtx.getMBeanNames());
        try {
            if (this.mMBeanSvr.isRegistered(compLCName)) {
                this.mMBeanSvr.unregisterMBean(compLCName);
            }
        }
        catch (Exception jex) {
            String msg = this.mMsgBuilder.buildExceptionMessage("unregisterComponentLifeCycleMBean", jex);
            throw new ManagementException(msg);
        }
    }

    protected void unregisterComponentExtensionMBean(String target, String compName) throws JBIException {
        ComponentType compType = this.getComponentType(compName);
        this.unregisterComponentExtensionMBean(target, compName, compType);
    }

    protected void unregisterComponentExtensionMBean(String target, String compName, ComponentType compType) throws JBIException {
        ObjectName facadeCompInfoMBean = null;
        facadeCompInfoMBean = compType == ComponentType.BINDING ? this.mMBeanNames.getBindingMBeanName(compName, MBeanNames.ComponentServiceType.Extension, target) : this.mMBeanNames.getEngineMBeanName(compName, MBeanNames.ComponentServiceType.Extension, target);
        try {
            if (this.mMBeanSvr.isRegistered(facadeCompInfoMBean)) {
                this.mMBeanSvr.unregisterMBean(facadeCompInfoMBean);
            }
        }
        catch (Exception jex) {
            String msg = this.mMsgBuilder.buildExceptionMessage("unregisterComponentExtensionMBean", jex);
            throw new ManagementException(msg);
        }
    }

    protected void throwNotSupportedManagementException(String taskId) throws ManagementException {
        String[] params = new String[]{taskId, this.mTarget};
        this.mMsgBuilder.throwManagementException(taskId, "JBI_ADMIN_UNSUPPORTED_OPERATION", params);
    }

    List<String> getAllTargets() throws ManagementException {
        ArrayList<String> targets = new ArrayList<String>();
        try {
            targets.addAll(this.getGenericQuery().getServers());
            targets.addAll(this.getGenericQuery().getClusters());
        }
        catch (RegistryException ex) {
            throw new ManagementException(this.mMsgBuilder.buildExceptionMessage("getAllTargets", (Throwable)((Object)ex)));
        }
        return targets;
    }

    private ValidatorType getValidatorType(ArchiveType arType) {
        ValidatorType type = null;
        if (arType.equals(ArchiveType.COMPONENT)) {
            type = ValidatorType.COMPONENT;
        } else if (arType.equals(ArchiveType.SHARED_LIBRARY)) {
            type = ValidatorType.SHARED_LIBRARY;
        } else if (arType.equals(ArchiveType.SERVICE_ASSEMBLY)) {
            type = ValidatorType.SERVICE_ASSEMBLY;
        } else if (arType.equals(ArchiveType.SERVICE_UNIT)) {
            type = ValidatorType.SERVICE_UNIT;
        }
        return type;
    }

    protected void archiveEqualityCheck(File f1, File f2, ArchiveType type, String entityName) throws ManagementException {
        boolean areArchivesIdentical = false;
        String token = "UNKNOWN";
        if (ArchiveType.COMPONENT.equals(type)) {
            token = "JBI_ADMIN_DIFFERENT_COMPONENT_ARCHIVE_EXISTS";
        } else if (ArchiveType.SHARED_LIBRARY.equals(type)) {
            token = "JBI_ADMIN_DIFFERENT_SHARED_LIBRARY_ARCHIVE_EXISTS";
        } else if (ArchiveType.SERVICE_ASSEMBLY.equals(type)) {
            token = "JBI_ADMIN_DIFFERENT_SERVICE_ASSEMBLY_ARCHIVE_EXISTS";
        }
        try {
            areArchivesIdentical = FileHelper.areFilesIdentical(f1, f2);
        }
        catch (IOException ioex) {
            this.mLog.warning(ioex.getMessage());
        }
        if (!areArchivesIdentical) {
            Object[] params = new String[]{entityName};
            String errMsg = this.mTranslator.getString(token, params);
            String jbiTaskMsg = this.mMsgBuilder.buildFrameworkMessage("archiveEqualityCheck", MessageBuilder.TaskResult.FAILED, MessageBuilder.MessageType.ERROR, MessageBuilder.getMessageString(errMsg), (String[])params, MessageBuilder.getMessageToken(errMsg));
            throw new ManagementException(jbiTaskMsg);
        }
    }
}

