/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.facade;

import com.sun.jbi.ComponentQuery;
import com.sun.jbi.ComponentState;
import com.sun.jbi.ComponentType;
import com.sun.jbi.EnvironmentContext;
import com.sun.jbi.ServiceLifecycle;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.ComponentExtensionMBean;
import com.sun.jbi.management.ComponentLifeCycleMBean;
import com.sun.jbi.management.ConfigurationCategory;
import com.sun.jbi.management.DeploymentServiceMBean;
import com.sun.jbi.management.InstallationServiceMBean;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.management.config.ConfigurationBuilder;
import com.sun.jbi.management.config.ConfigurationFactory;
import com.sun.jbi.management.facade.AdminService;
import com.sun.jbi.management.facade.ComponentExtension;
import com.sun.jbi.management.facade.ComponentLifeCycle;
import com.sun.jbi.management.facade.DeploymentService;
import com.sun.jbi.management.facade.InstallationService;
import com.sun.jbi.management.facade.RuntimeConfiguration;
import com.sun.jbi.management.internal.support.AntScriptRunner;
import com.sun.jbi.management.registry.GenericQuery;
import com.sun.jbi.management.registry.Registry;
import com.sun.jbi.management.registry.data.ComponentInfoImpl;
import com.sun.jbi.management.repository.Archive;
import com.sun.jbi.management.repository.ArchiveDownload;
import com.sun.jbi.management.repository.ArchiveDownloadMBean;
import com.sun.jbi.management.repository.ArchiveType;
import com.sun.jbi.management.repository.ArchiveUpload;
import com.sun.jbi.management.repository.ArchiveUploadMBean;
import com.sun.jbi.management.system.ManagementContext;
import com.sun.jbi.management.util.FacadeMbeanHelper;
import com.sun.jbi.platform.PlatformContext;
import com.sun.jbi.platform.PlatformEventListener;
import com.sun.jbi.ui.common.JBIJMXObjectNames;
import com.sun.jbi.ui.runtime.mbeans.JBIAdminCommandsUIBackPortMBean;
import com.sun.jbi.ui.runtime.mbeans.JBIAdminCommandsUIMBean;
import com.sun.jbi.ui.runtime.mbeans.UIMBeanFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.management.AdminServiceMBean;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.modelmbean.ModelMBeanInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementRuntimeService
implements ServiceLifecycle,
PlatformEventListener {
    private static final String ESB_UPLOAD_MBEAN_NAME = "com.sun.jbi.esb:ServiceType=ArchiveUpload";
    private static final String ADMIN_RUNNING_FILE = ".jbi_admin_running";
    private static final String ADMIN_STOPPED_FILE = ".jbi_admin_stopped";
    private EnvironmentContext mEnvCtx;
    private MBeanServer mMBeanSvr;
    private Logger mLog = Logger.getLogger("com.sun.jbi.management");
    private MBeanNames mMBeanNames;
    private ManagementContext mMgtCtx;
    private StringTranslator mTranslator;
    private PlatformContext mPlatform;
    private Set<MBeanNames.ServiceType> mConfigSvcTypes;
    private Properties mDefaults;
    private static final String DEFAULT_CONFIG_FILE = "runtime-config.defaults";

    @Override
    public void initService(EnvironmentContext aContext) throws JBIException {
        this.mLog.finest("Initializing Management Runtime Service.");
        this.mEnvCtx = aContext;
        this.mMgtCtx = new ManagementContext(this.mEnvCtx);
        this.mPlatform = this.mEnvCtx.getPlatformContext();
        this.mMBeanSvr = this.mEnvCtx.getMBeanServer();
        this.mMBeanNames = this.mEnvCtx.getMBeanNames();
        this.mTranslator = this.mEnvCtx.getStringTranslator("com.sun.jbi.management.facade");
        this.removeStopStateFile();
        this.mLog.finest(" This is target " + this.mPlatform.getTargetName());
        this.mPlatform.addListener(this);
        try {
            if (this.mPlatform.isAdminServer()) {
                this.registerUploadDownloadMBeans("domain");
                this.registerDomainFacadeMBeans();
                this.registerInstanceFacadeMBeans();
                this.registerClusterFacadeMBeans();
                this.registerJbiAdminUiMBeans();
                this.registerJbiAdminUiBackPortMBeans();
                this.createClientConfigFiles();
            } else {
                this.registerUploadDownloadMBeans(this.mPlatform.getInstanceName());
            }
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        this.createStartStateFile();
    }

    @Override
    public void startService() throws JBIException {
        this.mLog.finest("Starting Management Runtime Service.");
        this.updateRegistry();
        try {
            if (this.mPlatform.isAdminServer()) {
                this.registerComponentFacadeMBeans();
            }
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    @Override
    public void stopService() throws JBIException {
        this.mLog.finest("Stopping Management Runtime Service.");
        this.removeStartStateFile();
        try {
            if (this.mPlatform.isAdminServer()) {
                this.unregisterJbiAdminUiBackPortMBeans();
                this.unregisterJbiAdminUiMBeans();
                this.unregisterClusterFacadeMBeans();
                this.unregisterInstanceFacadeMBeans();
                this.unregisterDomainFacadeMBeans();
                this.unregisterUploadDownloadMBeans("domain");
            } else {
                this.unregisterUploadDownloadMBeans(this.mPlatform.getInstanceName());
            }
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
        this.createStopStateFile();
    }

    private void registerDomainFacadeMBeans() throws Exception {
        String domain = "domain";
        this.mLog.finest("Loading Facade MBeans");
        InstallationService instSvc = new InstallationService(this.mEnvCtx, domain);
        DeploymentService dplySvc = new DeploymentService(this.mEnvCtx, domain);
        AdminService adminSvc = new AdminService(this.mEnvCtx, domain);
        StandardMBean instStd = new StandardMBean(instSvc, InstallationServiceMBean.class);
        StandardMBean dplyStd = new StandardMBean(dplySvc, DeploymentServiceMBean.class);
        StandardMBean adminStd = new StandardMBean(adminSvc, AdminServiceMBean.class);
        this.mMBeanSvr.registerMBean(adminStd, this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.AdminService, MBeanNames.ServiceType.Admin, domain));
        this.mMBeanSvr.registerMBean(instStd, this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.InstallationService, MBeanNames.ServiceType.Installation, domain));
        this.mMBeanSvr.registerMBean(dplyStd, this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.DeploymentService, MBeanNames.ServiceType.Deployment, domain));
        this.registerRuntimeConfigFacadeMBeansForTarget(domain);
    }

    private void registerUploadDownloadMBeans(String target) throws Exception {
        this.mLog.finest("Loading Upload / Download MBeans");
        ArchiveUpload uploadSvc = new ArchiveUpload(this.mMgtCtx);
        ArchiveDownload downloadSvc = new ArchiveDownload(this.mMgtCtx);
        StandardMBean uploadStd = new StandardMBean(uploadSvc, ArchiveUploadMBean.class);
        StandardMBean downloadStd = new StandardMBean(downloadSvc, ArchiveDownloadMBean.class);
        this.mMBeanSvr.registerMBean(uploadStd, this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.FileTransferService, MBeanNames.ServiceType.Upload, target));
        this.mMBeanSvr.registerMBean(downloadStd, this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.FileTransferService, MBeanNames.ServiceType.Download, target));
        if (target.equals("domain")) {
            this.mMBeanSvr.registerMBean(uploadStd, new ObjectName(ESB_UPLOAD_MBEAN_NAME));
        }
    }

    private void registerInstanceFacadeMBeans() throws Exception {
        this.mLog.finest("Loading Instance Facade MBeans");
        Set<String> instances = this.mPlatform.getStandaloneServerNames();
        for (String instance : instances) {
            this.registerFacadeMBeansForTarget(instance);
        }
    }

    private void registerClusterFacadeMBeans() throws Exception {
        this.mLog.finest("Loading Cluster Facade MBeans");
        Set<String> clusters = this.mPlatform.getClusterNames();
        for (String cluster : clusters) {
            this.registerFacadeMBeansForTarget(cluster);
        }
    }

    private void registerComponentFacadeMBeans() throws Exception {
        this.registerComponentLifeCycleFacadeMBeansForTarget("domain");
        this.registerComponentExtensionFacadeMBeansForTarget("domain");
        this.mLog.finest("Loading Instance ComponentLifeCycle Facade MBeans");
        for (String target : this.mPlatform.getStandaloneServerNames()) {
            this.registerComponentLifeCycleFacadeMBeansForTarget(target);
            this.registerComponentExtensionFacadeMBeansForTarget(target);
        }
        this.mLog.finest("Loading Cluster ComponentLifecycle Facade MBeans");
        for (String target : this.mPlatform.getClusterNames()) {
            this.registerComponentLifeCycleFacadeMBeansForTarget(target);
            this.registerComponentExtensionFacadeMBeansForTarget(target);
        }
    }

    private void registerFacadeMBeansForTarget(String target) throws Exception {
        ObjectName adminSvcObjName = this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.AdminService, MBeanNames.ServiceType.Admin, target);
        ObjectName instSvcObjName = this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.InstallationService, MBeanNames.ServiceType.Installation, target);
        ObjectName dplySvcObjName = this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.DeploymentService, MBeanNames.ServiceType.Deployment, target);
        if (!this.mMBeanSvr.isRegistered(adminSvcObjName)) {
            AdminService adminSvc = new AdminService(this.mEnvCtx, target);
            StandardMBean adminStd = new StandardMBean(adminSvc, AdminServiceMBean.class);
            this.mMBeanSvr.registerMBean(adminStd, adminSvcObjName);
        }
        if (!this.mMBeanSvr.isRegistered(instSvcObjName)) {
            InstallationService instSvc = new InstallationService(this.mEnvCtx, target);
            StandardMBean instStd = new StandardMBean(instSvc, InstallationServiceMBean.class);
            this.mMBeanSvr.registerMBean(instStd, instSvcObjName);
        }
        if (!this.mMBeanSvr.isRegistered(dplySvcObjName)) {
            DeploymentService dplySvc = new DeploymentService(this.mEnvCtx, target);
            StandardMBean dplyStd = new StandardMBean(dplySvc, DeploymentServiceMBean.class);
            this.mMBeanSvr.registerMBean(dplyStd, dplySvcObjName);
        }
        this.registerRuntimeConfigFacadeMBeansForTarget(target);
    }

    private void unregisterDomainFacadeMBeans() throws Exception {
        String domain = "domain";
        this.mLog.finest("Unloading domain facade MBeans");
        this.unregisterComponentLifeCycleFacadeMBeansForTarget(domain);
        this.unregisterComponentExtensionFacadeMBeansForTarget(domain);
        this.mMBeanSvr.unregisterMBean(this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.AdminService, MBeanNames.ServiceType.Admin, domain));
        this.mMBeanSvr.unregisterMBean(this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.InstallationService, MBeanNames.ServiceType.Installation, domain));
        this.mMBeanSvr.unregisterMBean(this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.DeploymentService, MBeanNames.ServiceType.Deployment, domain));
        this.unregisterRuntimeConfigFacadeMBeansForTarget(domain);
    }

    private void unregisterUploadDownloadMBeans(String target) throws Exception {
        this.mLog.finest("Unloading Upload / Download MBeans");
        this.mMBeanSvr.unregisterMBean(this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.FileTransferService, MBeanNames.ServiceType.Upload, target));
        this.mMBeanSvr.unregisterMBean(this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.FileTransferService, MBeanNames.ServiceType.Download, target));
        if (target.equals("domain")) {
            this.mMBeanSvr.unregisterMBean(new ObjectName(ESB_UPLOAD_MBEAN_NAME));
        }
    }

    private void unregisterInstanceFacadeMBeans() throws Exception {
        this.mLog.finest("Unloading instance facade MBeans");
        Set<String> instances = this.mPlatform.getStandaloneServerNames();
        for (String instance : instances) {
            this.unregisterFacadeMBeansForTarget(instance);
        }
    }

    private void unregisterClusterFacadeMBeans() throws Exception {
        this.mLog.finest("Unloading cluster facade MBeans");
        Set<String> clusters = this.mPlatform.getClusterNames();
        for (String cluster : clusters) {
            this.unregisterFacadeMBeansForTarget(cluster);
        }
    }

    private void unregisterFacadeMBeansForTarget(String target) throws Exception {
        this.unregisterComponentLifeCycleFacadeMBeansForTarget(target);
        this.unregisterComponentExtensionFacadeMBeansForTarget(target);
        this.mMBeanSvr.unregisterMBean(this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.InstallationService, MBeanNames.ServiceType.Installation, target));
        this.mMBeanSvr.unregisterMBean(this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.DeploymentService, MBeanNames.ServiceType.Deployment, target));
        this.mMBeanSvr.unregisterMBean(this.mMBeanNames.getSystemServiceMBeanName(MBeanNames.ServiceName.AdminService, MBeanNames.ServiceType.Admin, target));
        this.unregisterRuntimeConfigFacadeMBeansForTarget(target);
    }

    private void registerJbiAdminUiMBeans() throws JBIException {
        try {
            JBIAdminCommandsUIMBean jbiAdminCommandsUIMBeanImpl = this.createJBIAdminCommandsUIMBean(this.mEnvCtx);
            StandardMBean mbean = new StandardMBean(jbiAdminCommandsUIMBeanImpl, JBIAdminCommandsUIMBean.class);
            this.mMBeanSvr.registerMBean(mbean, JBIJMXObjectNames.getJbiReferenceAdminUiMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    private void registerJbiAdminUiBackPortMBeans() throws JBIException {
        try {
            JBIAdminCommandsUIBackPortMBean jbiAdminCommandsUIBackPortMBeanImpl = this.createJBIAdminCommandsUIBackPortMBean(this.mEnvCtx);
            StandardMBean mbean = new StandardMBean(jbiAdminCommandsUIBackPortMBeanImpl, JBIAdminCommandsUIBackPortMBean.class);
            this.mMBeanSvr.registerMBean(mbean, JBIJMXObjectNames.getJbiAdminUiMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    private void unregisterJbiAdminUiMBeans() throws JBIException {
        try {
            this.mMBeanSvr.unregisterMBean(JBIJMXObjectNames.getJbiReferenceAdminUiMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    private void unregisterJbiAdminUiBackPortMBeans() throws JBIException {
        try {
            this.mMBeanSvr.unregisterMBean(JBIJMXObjectNames.getJbiAdminUiMBeanObjectName());
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    protected JBIAdminCommandsUIMBean createJBIAdminCommandsUIMBean(EnvironmentContext aContext) throws JBIException {
        return UIMBeanFactory.getInstance().createJBIAdminCommandsUIMBean(aContext);
    }

    protected JBIAdminCommandsUIBackPortMBean createJBIAdminCommandsUIBackPortMBean(EnvironmentContext aContext) throws JBIException {
        return UIMBeanFactory.getInstance().createJBIAdminCommandsUIBackPortMBean(aContext);
    }

    @Override
    public void createdStandaloneInstance(String instanceName) {
        try {
            if (this.mEnvCtx.isFrameworkReady(false)) {
                this.getRegistry().getUpdater().addServer(instanceName);
                this.addSystemComponents(instanceName);
                this.registerFacadeMBeansForTarget(instanceName);
                this.registerComponentLifeCycleFacadeMBeansForTarget(instanceName);
                this.registerComponentExtensionFacadeMBeansForTarget(instanceName);
            } else {
                this.mEnvCtx.isFrameworkReady(true);
            }
        }
        catch (Exception ex) {
            String message = this.mTranslator.getString("JBI_ADMIN_CREATE_INSTANCE_EVENT_ERROR");
            this.mLog.warning(message + ex.getMessage());
        }
    }

    @Override
    public void deletedInstance(String instanceName) {
        try {
            if (this.mEnvCtx.isFrameworkReady(false)) {
                List<String> servers = this.getRegistry().getGenericQuery().getServers();
                if (servers.contains(instanceName)) {
                    this.unregisterFacadeMBeansForTarget(instanceName);
                    this.unregisterComponentLifeCycleFacadeMBeansForTarget(instanceName);
                    this.unregisterComponentExtensionFacadeMBeansForTarget(instanceName);
                    this.getRegistry().getUpdater().removeServer(instanceName);
                }
            } else {
                this.mEnvCtx.isFrameworkReady(true);
            }
        }
        catch (Exception ex) {
            String message = this.mTranslator.getString("JBI_ADMIN_DELETE_INSTANCE_EVENT_ERROR");
            this.mLog.warning(message + ex.getMessage());
        }
    }

    @Override
    public void createdCluster(String clusterName) {
        try {
            if (this.mEnvCtx.isFrameworkReady(false)) {
                this.getRegistry().getUpdater().addCluster(clusterName);
                this.addSystemComponents(clusterName);
                this.registerFacadeMBeansForTarget(clusterName);
                this.registerComponentLifeCycleFacadeMBeansForTarget(clusterName);
                this.registerComponentExtensionFacadeMBeansForTarget(clusterName);
            } else {
                this.mEnvCtx.isFrameworkReady(true);
            }
        }
        catch (Exception ex) {
            String message = this.mTranslator.getString("JBI_ADMIN_CREATE_CLUSTER_EVENT_ERROR");
            this.mLog.warning(message + ex.getMessage());
        }
    }

    @Override
    public void deletedCluster(String clusterName) {
        try {
            if (this.mEnvCtx.isFrameworkReady(false)) {
                this.unregisterFacadeMBeansForTarget(clusterName);
                this.unregisterComponentLifeCycleFacadeMBeansForTarget(clusterName);
                this.unregisterComponentExtensionFacadeMBeansForTarget(clusterName);
                this.getRegistry().getUpdater().removeCluster(clusterName);
            } else {
                this.mEnvCtx.isFrameworkReady(true);
            }
        }
        catch (Exception ex) {
            String message = this.mTranslator.getString("JBI_ADMIN_DELETE_CLUSTER_EVENT_ERROR");
            this.mLog.warning(message + ex.getMessage());
        }
    }

    private void updateRegistry() throws JBIException {
        try {
            if (this.mPlatform.isAdminServer()) {
                Set<String> asServers = this.mPlatform.getStandaloneServerNames();
                List<String> regServers = this.getRegistry().getGenericQuery().getServers();
                for (String asServer : asServers) {
                    if (regServers.contains(asServer)) continue;
                    this.getRegistry().getUpdater().addServer(asServer);
                    this.addSystemComponents(asServer);
                    this.registerFacadeMBeansForTarget(asServer);
                }
                for (String regServer : regServers) {
                    if (asServers.contains(regServer)) continue;
                    this.getRegistry().getUpdater().removeServer(regServer);
                    this.unregisterFacadeMBeansForTarget(regServer);
                }
                Set<String> asClusters = this.mPlatform.getClusterNames();
                List<String> regClusters = this.getRegistry().getGenericQuery().getClusters();
                for (String asCluster : asClusters) {
                    if (regClusters.contains(asCluster)) continue;
                    this.getRegistry().getUpdater().addCluster(asCluster);
                    this.addSystemComponents(asCluster);
                    this.registerFacadeMBeansForTarget(asCluster);
                }
                for (String regCluster : regClusters) {
                    if (asClusters.contains(regCluster)) continue;
                    this.getRegistry().getUpdater().removeCluster(regCluster);
                    this.unregisterFacadeMBeansForTarget(regCluster);
                }
            } else {
                String thisTargetName = this.mPlatform.getTargetName();
                if (thisTargetName.equals(this.mPlatform.getInstanceName())) {
                    List<String> regServers = this.getRegistry().getGenericQuery().getServers();
                    if (!regServers.contains(thisTargetName)) {
                        this.getRegistry().getUpdater().addServer(thisTargetName);
                    }
                } else {
                    List<String> regClusters = this.getRegistry().getGenericQuery().getClusters();
                    if (!regClusters.contains(thisTargetName)) {
                        this.getRegistry().getUpdater().addCluster(thisTargetName);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new JBIException((Throwable)ex);
        }
    }

    private void registerComponentExtensionFacadeMBeansForTarget(String target) throws Exception {
        ObjectName compExtName;
        StandardMBean compExtMBean;
        ComponentExtension compExt;
        ComponentQuery compQuery = this.getRegistry().getComponentQuery(target);
        List bindingComponents = compQuery.getComponentIds(ComponentType.BINDING);
        List engineComponents = compQuery.getComponentIds(ComponentType.ENGINE);
        for (String compName : bindingComponents) {
            compExt = new ComponentExtension(this.mEnvCtx, target, compName, ComponentType.BINDING);
            compExtMBean = new StandardMBean(compExt, ComponentExtensionMBean.class);
            compExtName = this.mEnvCtx.getMBeanNames().getBindingMBeanName(compName, MBeanNames.ComponentServiceType.Extension, target);
            this.mMBeanSvr.registerMBean(compExtMBean, compExtName);
        }
        for (String compName : engineComponents) {
            compExt = new ComponentExtension(this.mEnvCtx, target, compName, ComponentType.ENGINE);
            compExtMBean = new StandardMBean(compExt, ComponentExtensionMBean.class);
            compExtName = this.mEnvCtx.getMBeanNames().getEngineMBeanName(compName, MBeanNames.ComponentServiceType.Extension, target);
            this.mMBeanSvr.registerMBean(compExtMBean, compExtName);
        }
    }

    private void unregisterComponentExtensionFacadeMBeansForTarget(String target) throws Exception {
        ObjectName compExtName;
        ComponentQuery compQuery = this.getRegistry().getComponentQuery(target);
        List bindingComponents = compQuery.getComponentIds(ComponentType.BINDING);
        List engineComponents = compQuery.getComponentIds(ComponentType.ENGINE);
        ArrayList<ObjectName> objNames = new ArrayList<ObjectName>();
        for (String compName : bindingComponents) {
            compExtName = this.mEnvCtx.getMBeanNames().getBindingMBeanName(compName, MBeanNames.ComponentServiceType.Extension, target);
            objNames.add(compExtName);
        }
        for (String compName : engineComponents) {
            compExtName = this.mEnvCtx.getMBeanNames().getEngineMBeanName(compName, MBeanNames.ComponentServiceType.Extension, target);
            objNames.add(compExtName);
        }
        for (ObjectName objName : objNames) {
            if (!this.mMBeanSvr.isRegistered(objName)) continue;
            this.mMBeanSvr.unregisterMBean(objName);
        }
    }

    private void registerComponentLifeCycleFacadeMBeansForTarget(String target) throws Exception {
        Map<String, Map<String, ObjectName>> bindings = this.getBindingComponentLifeCycleNames(target);
        Map<String, Map<String, ObjectName>> engines = this.getEngineComponentLifeCycleNames(target);
        Set<String> bindingNames = bindings.keySet();
        for (String compName : bindingNames) {
            ComponentLifeCycle bindingLC = new ComponentLifeCycle(this.mEnvCtx, target, compName, ComponentType.BINDING, bindings.get(compName));
            StandardMBean compLC = new StandardMBean(bindingLC, ComponentLifeCycleMBean.class);
            ObjectName compLCName = FacadeMbeanHelper.getComponentLifeCycleFacadeMBeanName(compName, ComponentType.BINDING, target, this.mEnvCtx.getMBeanNames());
            this.mMBeanSvr.registerMBean(compLC, compLCName);
        }
        Set<String> engineNames = engines.keySet();
        for (String compName : engineNames) {
            ComponentLifeCycle engineLC = new ComponentLifeCycle(this.mEnvCtx, target, compName, ComponentType.ENGINE, engines.get(compName));
            StandardMBean compLC = new StandardMBean(engineLC, ComponentLifeCycleMBean.class);
            ObjectName compLCName = FacadeMbeanHelper.getComponentLifeCycleFacadeMBeanName(compName, ComponentType.ENGINE, target, this.mEnvCtx.getMBeanNames());
            this.mMBeanSvr.registerMBean(compLC, compLCName);
        }
    }

    private void unregisterComponentLifeCycleFacadeMBeansForTarget(String target) throws Exception {
        ObjectName[] compLCNames;
        for (ObjectName compLC : compLCNames = FacadeMbeanHelper.getComponentLifeCycleObjectNames(this.mMBeanSvr, this.mEnvCtx.getMBeanNames(), target)) {
            if (!this.mMBeanSvr.isRegistered(compLC)) continue;
            this.mMBeanSvr.unregisterMBean(compLC);
        }
    }

    private Map<String, Map<String, ObjectName>> getBindingComponentLifeCycleNames(String target) throws Exception {
        ComponentQuery compQuery = this.getRegistry().getComponentQuery(target);
        List bindingComponents = compQuery.getComponentIds(ComponentType.BINDING);
        HashMap<String, Map<String, ObjectName>> allBindings = new HashMap<String, Map<String, ObjectName>>();
        boolean i = false;
        for (String bindingName : bindingComponents) {
            HashMap<String, ObjectName> bindingObjNames = new HashMap<String, ObjectName>();
            if ("domain".equals(target)) {
                bindingObjNames.put(target, null);
            } else if (this.mPlatform.isStandaloneServer(target)) {
                ObjectName bindingObjName = this.mMgtCtx.getMBeanNames(target).getBindingMBeanName(bindingName, "Lifecycle");
                bindingObjNames.put(target, bindingObjName);
            } else {
                Set<String> instances = this.mPlatform.getServersInCluster(target);
                for (String instance : instances) {
                    ObjectName bindingObjName = this.mMgtCtx.getMBeanNames(instance).getBindingMBeanName(bindingName, "Lifecycle");
                    bindingObjNames.put(instance, bindingObjName);
                }
            }
            allBindings.put(bindingName, bindingObjNames);
        }
        return allBindings;
    }

    private Map<String, Map<String, ObjectName>> getEngineComponentLifeCycleNames(String target) throws Exception {
        ComponentQuery compQuery = this.getRegistry().getComponentQuery(target);
        List engineComponents = compQuery.getComponentIds(ComponentType.ENGINE);
        HashMap<String, Map<String, ObjectName>> allEngines = new HashMap<String, Map<String, ObjectName>>();
        boolean i = false;
        for (String engineName : engineComponents) {
            HashMap<String, ObjectName> engineObjNames = new HashMap<String, ObjectName>();
            if ("domain".equals(target)) {
                engineObjNames.put(target, null);
            } else if (this.mPlatform.isStandaloneServer(target)) {
                ObjectName engineObjName = this.mMgtCtx.getMBeanNames(target).getEngineMBeanName(engineName, "Lifecycle");
                engineObjNames.put(target, engineObjName);
            } else {
                Set<String> instances = this.mPlatform.getServersInCluster(target);
                for (String instance : instances) {
                    ObjectName engineObjName = this.mMgtCtx.getMBeanNames(instance).getEngineMBeanName(engineName, "Lifecycle");
                    engineObjNames.put(instance, engineObjName);
                }
            }
            allEngines.put(engineName, engineObjNames);
        }
        return allEngines;
    }

    private void registerRuntimeConfigFacadeMBeansForTarget(String target) throws Exception {
        Map<MBeanNames.ServiceType, ConfigurationFactory> configs = ConfigurationBuilder.createConfigurations(this.readDefaultProperties());
        this.mConfigSvcTypes = configs.keySet();
        if (this.mConfigSvcTypes.contains((Object)MBeanNames.ServiceType.Logger)) {
            this.mConfigSvcTypes.remove((Object)MBeanNames.ServiceType.Logger);
        }
        for (MBeanNames.ServiceType serviceType : this.mConfigSvcTypes) {
            ObjectName name = this.mEnvCtx.getMBeanNames().getSystemServiceMBeanName(MBeanNames.ServiceName.ConfigurationService, serviceType, target);
            if (this.mMBeanSvr.isRegistered(name)) continue;
            ModelMBeanInfo mbeanInfo = RuntimeConfiguration.createMBeanInfo(configs.get((Object)serviceType).createMBeanAttributeInfo());
            RuntimeConfiguration modelConfigMBean = new RuntimeConfiguration(mbeanInfo, ConfigurationCategory.valueOf(serviceType.toString()), target);
            modelConfigMBean.setManagedResource(modelConfigMBean, "ObjectReference");
            this.mMBeanSvr.registerMBean(modelConfigMBean, name);
        }
    }

    private void unregisterRuntimeConfigFacadeMBeansForTarget(String target) throws Exception {
        if (this.mConfigSvcTypes != null) {
            for (MBeanNames.ServiceType serviceType : this.mConfigSvcTypes) {
                ObjectName name = this.mEnvCtx.getMBeanNames().getSystemServiceMBeanName(MBeanNames.ServiceName.ConfigurationService, serviceType, target);
                if (!this.mMBeanSvr.isRegistered(name)) continue;
                this.mMBeanSvr.unregisterMBean(name);
            }
        }
    }

    private void addSystemComponents(String targetName) throws Exception {
        ComponentQuery compQuery = this.getRegistry().getComponentQuery("domain");
        GenericQuery genQuery = this.getRegistry().getGenericQuery();
        ComponentInfoImpl compInfo = null;
        String WORKSPACE = "workspace";
        String INSTALL_ROOT = "install_root";
        List components = compQuery.getComponentIds(ComponentType.BINDINGS_AND_ENGINES);
        for (String componentName : components) {
            Archive archive;
            if (!genQuery.isSystemComponent(componentName) || (archive = this.mMgtCtx.getRepository().getArchive(ArchiveType.COMPONENT, componentName)) == null) continue;
            String componentRoot = new File(archive.getPath()).getParent();
            String componentInstallRoot = componentRoot + File.separator + INSTALL_ROOT;
            String componentWorkspaceRoot = componentInstallRoot + File.separator + WORKSPACE;
            compInfo = new ComponentInfoImpl();
            compInfo.setName(componentName);
            compInfo.setInstallRoot(componentInstallRoot);
            compInfo.setWorkspaceRoot(componentWorkspaceRoot);
            compInfo.setStatus(ComponentState.SHUTDOWN);
            this.getRegistry().getUpdater().addComponent(targetName, compInfo);
        }
        List sharedLibs = compQuery.getComponentIds(ComponentType.SHARED_LIBRARY);
        for (String sharedLibName : sharedLibs) {
            Archive archive;
            if (!genQuery.isSystemSharedLibrary(sharedLibName) || (archive = this.mMgtCtx.getRepository().getArchive(ArchiveType.SHARED_LIBRARY, sharedLibName)) == null) continue;
            String sharedLibRoot = new File(archive.getPath()).getParent();
            String sharedLibInstallRoot = sharedLibRoot + File.separator + INSTALL_ROOT;
            compInfo = new ComponentInfoImpl();
            compInfo.setName(sharedLibName);
            compInfo.setInstallRoot(sharedLibInstallRoot);
            this.getRegistry().getUpdater().addSharedLibrary(targetName, compInfo);
        }
    }

    private void createStartStateFile() {
        String startStateFn = this.makeStartStateFn();
        File startStateFile = new File(startStateFn);
        this.mLog.fine("Startfile is " + startStateFile.getAbsolutePath());
        String statusMsg = this.mTranslator.getString("JBI_ADMIN_STATEFILE_START", startStateFn);
        this.mLog.fine(statusMsg);
        try {
            startStateFile.getParentFile().mkdirs();
            startStateFile.createNewFile();
        }
        catch (Exception e) {
            statusMsg = this.mTranslator.getString("JBI_ADMIN_STATEFILE_START_FAILED", e.getMessage());
            this.mLog.severe(statusMsg);
        }
    }

    private void removeStartStateFile() {
        String startStateFn = this.makeStartStateFn();
        File startStateFile = new File(startStateFn);
        String statusMsg = this.mTranslator.getString("JBI_ADMIN_STATEFILE_START_REMOVE", startStateFn);
        this.mLog.fine(statusMsg);
        try {
            startStateFile.delete();
        }
        catch (Exception e) {
            statusMsg = this.mTranslator.getString("JBI_ADMIN_STATEFILE_REMOVE_FAILED", e.getMessage());
            this.mLog.severe(statusMsg);
        }
    }

    private void createStopStateFile() {
        String stoppedStateFn = this.makeStopStateFn();
        File stoppedStateFile = new File(stoppedStateFn);
        String statusMsg = this.mTranslator.getString("JBI_ADMIN_STATEFILE_STOP", stoppedStateFn);
        this.mLog.fine(statusMsg);
        try {
            stoppedStateFile.createNewFile();
        }
        catch (Exception e) {
            statusMsg = this.mTranslator.getString("JBI_ADMIN_STATEFILE_STOP_FAILED", e.getMessage());
            this.mLog.severe(statusMsg);
        }
    }

    private void removeStopStateFile() {
        String stoppedStateFn = this.makeStopStateFn();
        File stoppedStateFile = new File(stoppedStateFn);
        String statusMsg = this.mTranslator.getString("JBI_ADMIN_STATEFILE_STOP_REMOVE", stoppedStateFn);
        this.mLog.fine(statusMsg);
        try {
            stoppedStateFile.delete();
        }
        catch (Exception e) {
            statusMsg = this.mTranslator.getString("JBI_ADMIN_STATEFILE_REMOVE_FAILED", e.getMessage());
            this.mLog.severe(statusMsg);
        }
    }

    private String makeStartStateFn() {
        String ps = File.separator;
        return this.mEnvCtx.getJbiInstanceRoot() + ps + "tmp" + ps + ADMIN_RUNNING_FILE;
    }

    private String makeStopStateFn() {
        String ps = File.separator;
        return this.mEnvCtx.getJbiInstanceRoot() + ps + "tmp" + ps + ADMIN_STOPPED_FILE;
    }

    private void createClientConfigFiles() {
        if (!new File(this.getJbiDomainUpdateScriptPath()).canRead()) {
            return;
        }
        System.setProperty("com.sun.jbi.management.JmxRmiPort", this.mPlatform.getJmxRmiPort());
        this.mLog.fine("Running ant admin startup tasks ...");
        String antfn = this.getJbiDomainUpdateScriptPath();
        AntScriptRunner ant = new AntScriptRunner();
        AntScriptRunner.runAntTarget(this.mEnvCtx.getJbiInstanceRoot(), antfn, "admin_startup_tasks");
    }

    private String getJbiDomainUpdateScriptPath() {
        return this.mEnvCtx.getJbiInstallRoot() + File.separator + "templates" + File.separator + "update_jbi_domain.ant";
    }

    private Properties readDefaultProperties() throws IOException {
        if (this.mDefaults == null) {
            FileInputStream ipStr;
            this.mDefaults = new Properties();
            StringBuffer pathToConfig = new StringBuffer(this.mEnvCtx.getJbiInstallRoot());
            pathToConfig.append(File.separatorChar);
            pathToConfig.append("lib");
            pathToConfig.append(File.separatorChar);
            pathToConfig.append("install");
            pathToConfig.append(File.separatorChar);
            pathToConfig.append("templates");
            pathToConfig.append(File.separatorChar);
            File defConfig = new File(pathToConfig.toString(), DEFAULT_CONFIG_FILE);
            if (defConfig.exists() && defConfig.length() > 0L && (ipStr = new FileInputStream(defConfig)) != null) {
                this.mDefaults.load(ipStr);
                ((InputStream)ipStr).close();
            }
        }
        return this.mDefaults;
    }

    protected Registry getRegistry() {
        return (Registry)this.mEnvCtx.getRegistry();
    }
}

