/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.system;

import com.sun.jbi.JBIProvider;
import com.sun.jbi.StringTranslator;
import com.sun.jbi.management.MBeanNames;
import com.sun.jbi.management.registry.Registry;
import com.sun.jbi.management.repository.Archive;
import com.sun.jbi.management.repository.ArchiveType;
import com.sun.jbi.management.system.ManagementContext;
import com.sun.jbi.ui.common.JBIManagementMessage;
import com.sun.org.apache.xpath.internal.XPathAPI;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringReader;
import java.util.logging.Logger;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class AutoAdminTask {
    public static final String AUTOINSTALL_DIR = "autoinstall";
    private static final String INSTALL_STATUS_DIR = ".autoinstallstatus";
    private static final String INSTALL_SUCCESS = "_installed";
    private static final String INSTALL_FAILURE = "_notInstalled";
    private static final String UNINSTALL_SUCCESS = "_uninstalled";
    private static final String UNINSTALL_FAILURE = "_notUninstalled";
    public static final String AUTODEPLOY_DIR = "autodeploy";
    private static final String DEPLOY_STATUS_DIR = ".autodeploystatus";
    private static final String DEPLOY_SUCCESS = "_deployed";
    private static final String DEPLOY_FAILURE = "_notDeployed";
    private static final String UNDEPLOY_SUCCESS = "_undeployed";
    private static final String UNDEPLOY_FAILURE = "_notUndeployed";
    public static final String DELIMITER = "--";
    public static final String COMP_DELIMITER = "--comp--";
    public static final String SL_DELIMITER = "--sl--";
    private ManagementContext mContext;
    private Logger mLogger;
    private File mAutoInstallDir;
    private String mAutoInstallDirName;
    private File mAutoDeployDir;
    private String mAutoDeployDirName;
    private File mInstallTimestampsDir;
    private File mDeployTimestampsDir;
    private DocumentBuilder mDocBuilder;
    private boolean mAutoInstallEnabled;
    private boolean mAutoReinstallEnabled;
    private boolean mAutoUninstallEnabled;
    private boolean mAutoDeployEnabled = false;
    private boolean mAutoRedeployEnabled;
    private boolean mAutoUndeployEnabled;
    private ObjectName mInstallationMBean;
    private ObjectName mDeploymentMBean;
    private ObjectName mInstallConfigSvcMBean;
    private ObjectName mDeployConfigSvcMBean;
    private StringTranslator mTranslator;

    public AutoAdminTask(ManagementContext anEnv) {
        this.mContext = anEnv;
        AutoAdminTask autoAdminTask = this;
        this.mLogger = autoAdminTask.mContext.getLogger();
        this.mTranslator = anEnv.getEnvironmentContext().getStringTranslator("com.sun.jbi.management");
        AutoAdminTask autoAdminTask2 = this;
        AutoAdminTask autoAdminTask3 = this;
        this.mInstallationMBean = autoAdminTask2.mContext.getMBeanNames().getSystemServiceMBeanName(MBeanNames.ServiceName.InstallationService, MBeanNames.ServiceType.Installation, autoAdminTask3.mContext.getEnvironmentContext().getPlatformContext().getInstanceName());
        AutoAdminTask autoAdminTask4 = this;
        AutoAdminTask autoAdminTask5 = this;
        this.mDeploymentMBean = autoAdminTask4.mContext.getMBeanNames().getSystemServiceMBeanName(MBeanNames.ServiceName.DeploymentService, MBeanNames.ServiceType.Deployment, autoAdminTask5.mContext.getEnvironmentContext().getPlatformContext().getInstanceName());
        AutoAdminTask autoAdminTask6 = this;
        AutoAdminTask autoAdminTask7 = this;
        this.mInstallConfigSvcMBean = autoAdminTask6.mContext.getMBeanNames().getSystemServiceMBeanName(MBeanNames.ServiceName.ConfigurationService, MBeanNames.ServiceType.Installation, autoAdminTask7.mContext.getEnvironmentContext().getPlatformContext().getInstanceName());
        AutoAdminTask autoAdminTask8 = this;
        AutoAdminTask autoAdminTask9 = this;
        this.mDeployConfigSvcMBean = autoAdminTask8.mContext.getMBeanNames().getSystemServiceMBeanName(MBeanNames.ServiceName.ConfigurationService, MBeanNames.ServiceType.Deployment, autoAdminTask9.mContext.getEnvironmentContext().getPlatformContext().getInstanceName());
    }

    public AutoAdminTask(ManagementContext anEnv, String aDirectoryForAutoInstall, String aDirectoryForAutoDeploy, boolean isAutoInstallEnabled, boolean isAutoDeployEnabled) {
        this(anEnv);
        this.mAutoInstallDirName = aDirectoryForAutoInstall;
        this.mAutoDeployDirName = aDirectoryForAutoDeploy;
        this.mAutoInstallEnabled = isAutoInstallEnabled;
        this.mAutoReinstallEnabled = isAutoInstallEnabled;
        this.mAutoUninstallEnabled = isAutoInstallEnabled;
        this.mAutoDeployEnabled = isAutoDeployEnabled;
        this.mAutoRedeployEnabled = isAutoDeployEnabled;
        this.mAutoUndeployEnabled = isAutoDeployEnabled;
    }

    public synchronized void performAutoFunctions() throws Exception {
        this.mAutoInstallDirName = this.getConfigAttribute(this.mInstallConfigSvcMBean, "autoInstallDir");
        this.mAutoDeployDirName = this.getConfigAttribute(this.mDeployConfigSvcMBean, "autoDeployDir");
        this.mAutoInstallEnabled = this.checkConfigPermission(this.mInstallConfigSvcMBean, "autoInstallEnabled");
        this.mAutoReinstallEnabled = this.checkConfigPermission(this.mInstallConfigSvcMBean, "autoReinstallEnabled");
        this.mAutoUninstallEnabled = this.checkConfigPermission(this.mInstallConfigSvcMBean, "autoUninstallEnabled");
        AutoAdminTask autoAdminTask = this;
        if (autoAdminTask.mContext.getEnvironmentContext().getProvider() != JBIProvider.SUNAS) {
            this.mAutoDeployEnabled = this.checkConfigPermission(this.mDeployConfigSvcMBean, "autoDeployEnabled");
            this.mAutoRedeployEnabled = this.checkConfigPermission(this.mDeployConfigSvcMBean, "autoRedeployEnabled");
            this.mAutoUndeployEnabled = this.checkConfigPermission(this.mDeployConfigSvcMBean, "autoUndeployEnabled");
        }
        this.initDirectories(this.mAutoInstallEnabled, this.mAutoDeployEnabled);
        if (this.mAutoInstallEnabled) {
            this.performAutoInstall();
            if (this.mAutoUninstallEnabled) {
                this.performAutoUninstall();
                if (this.mAutoUninstallEnabled) {
                    this.performAutoReinstall();
                }
            }
        }
        if (this.mAutoDeployEnabled) {
            this.performAutoDeploy();
            if (this.mAutoUndeployEnabled) {
                this.performAutoUndeploy();
                if (this.mAutoRedeployEnabled) {
                    this.performAutoRedeploy();
                }
            }
        }
    }

    public void performAutoInstall() {
        File installFile;
        while ((installFile = this.pollAutoDirectory(PollFunction.NEW_FILES, this.mAutoInstallDir, this.mInstallTimestampsDir)) != null) {
            this.doInstall(installFile);
        }
    }

    private void doInstall(File installFile) {
        try {
            String fileName = installFile.getName();
            File timeStamp = new File(this.mInstallTimestampsDir, fileName);
            timeStamp.createNewFile();
            timeStamp.setLastModified(installFile.lastModified());
            Archive installArchive = new Archive(installFile, true);
            if (installArchive.getType().equals(ArchiveType.COMPONENT)) {
                String componentName = this.installComponent(installFile.getAbsolutePath());
                File storedNameFile = new File(this.mInstallTimestampsDir, fileName + COMP_DELIMITER + componentName);
                if (null != componentName) {
                    storedNameFile.createNewFile();
                    storedNameFile.setLastModified(installFile.lastModified());
                }
            } else if (installArchive.getType().equals(ArchiveType.SHARED_LIBRARY)) {
                String componentName = this.installSharedLibrary(installFile.getAbsolutePath());
                File storedNameFile = new File(this.mInstallTimestampsDir, fileName + SL_DELIMITER + componentName);
                if (null != componentName) {
                    storedNameFile.createNewFile();
                    storedNameFile.setLastModified(installFile.lastModified());
                }
            } else if (installArchive.getType().equals(ArchiveType.SERVICE_ASSEMBLY)) {
                this.removeInstallLogs(installFile.getAbsolutePath());
                this.writeLog(installFile.getAbsolutePath() + INSTALL_FAILURE, this.mTranslator.getString("AA_DEPLOY_NOT_SUPPORTED"));
            }
        }
        catch (Exception ex) {
            this.removeInstallLogs(installFile.getAbsolutePath());
            this.writeLog(installFile.getAbsolutePath() + INSTALL_FAILURE, ex.toString());
        }
    }

    public void performAutoDeploy() {
        File deployFile;
        while ((deployFile = this.pollAutoDirectory(PollFunction.NEW_FILES, this.mAutoDeployDir, this.mDeployTimestampsDir)) != null) {
            this.doDeploy(deployFile);
        }
    }

    private void doDeploy(File deployFile) {
        try {
            String fileName = deployFile.getName();
            File timeStamp = new File(this.mDeployTimestampsDir, fileName);
            timeStamp.createNewFile();
            timeStamp.setLastModified(deployFile.lastModified());
            Archive deployArchive = new Archive(deployFile, true);
            if (deployArchive.getType().equals(ArchiveType.SERVICE_ASSEMBLY)) {
                String serviceAssemblyName = deployArchive.getJbiName();
                this.deployServiceAssembly(serviceAssemblyName, deployFile.getAbsolutePath());
                File storedNameFile = new File(this.mDeployTimestampsDir, fileName + DELIMITER + serviceAssemblyName);
                if (null != storedNameFile) {
                    storedNameFile.createNewFile();
                    storedNameFile.setLastModified(deployFile.lastModified());
                }
            } else {
                this.removeDeployLogs(deployFile.getAbsolutePath());
                this.writeLog(deployFile.getAbsolutePath() + DEPLOY_FAILURE, this.mTranslator.getString("AA_INSTALL_NOT_SUPPORTED"));
            }
        }
        catch (Exception ex) {
            this.removeDeployLogs(deployFile.getAbsolutePath());
            this.writeLog(deployFile.getAbsolutePath() + DEPLOY_FAILURE, ex.toString());
        }
    }

    public void performAutoUninstall() {
        File deletedFile;
        while ((deletedFile = this.pollAutoDirectory(PollFunction.DELETED_FILES, this.mAutoInstallDir, this.mInstallTimestampsDir)) != null) {
            this.doUninstall(deletedFile);
        }
    }

    private boolean doUninstall(File deletedFile) {
        String fileName = null;
        try {
            fileName = deletedFile.getName();
            this.mLogger.finer("doUninstall() deleting file " + fileName);
            deletedFile.delete();
            for (File deletedData : this.mInstallTimestampsDir.listFiles(new NamedFileFinder(fileName))) {
                deletedData.delete();
                this.mLogger.finer("doUninstall() on " + deletedData.getName());
                String cSuffix = this.suffix(deletedData.getName(), fileName + COMP_DELIMITER);
                String slSuffix = this.suffix(deletedData.getName(), fileName + SL_DELIMITER);
                if (null != cSuffix) {
                    this.uninstallComponent(cSuffix);
                }
                if (null == slSuffix) continue;
                this.uninstallSharedLibrary(slSuffix);
            }
            fileName = this.mAutoInstallDir.getAbsolutePath() + File.separator + fileName;
            this.removeInstallLogs(fileName);
            this.writeLog(fileName + UNINSTALL_SUCCESS, "");
            return true;
        }
        catch (Exception ex) {
            if (null != fileName) {
                fileName = this.mAutoInstallDir.getAbsolutePath() + File.separator + fileName;
                this.removeInstallLogs(fileName);
                this.writeLog(fileName + UNINSTALL_FAILURE, ex.toString());
            }
            return false;
        }
    }

    public void performAutoUndeploy() {
        File deletedFile;
        while ((deletedFile = this.pollAutoDirectory(PollFunction.DELETED_FILES, this.mAutoDeployDir, this.mDeployTimestampsDir)) != null) {
            this.doUndeploy(deletedFile);
        }
    }

    private boolean doUndeploy(File deletedFile) {
        String fileName = null;
        boolean results = true;
        try {
            fileName = deletedFile.getName();
            this.mLogger.finer("doUndeploy() deleting file " + fileName);
            deletedFile.delete();
            for (File deletedData : this.mDeployTimestampsDir.listFiles(new NamedFileFinder(fileName))) {
                deletedData.delete();
                this.mLogger.finer("doUndeploy() on " + deletedData.getName());
                String saName = this.suffix(deletedData.getName(), fileName + DELIMITER);
                if (null == saName) continue;
                results = this.undeployServiceAssembly(saName);
            }
            fileName = this.mAutoDeployDir.getAbsolutePath() + File.separator + fileName;
            this.removeDeployLogs(fileName);
            this.writeLog(fileName + UNDEPLOY_SUCCESS, "");
            return results;
        }
        catch (Exception ex) {
            if (null != fileName) {
                fileName = this.mAutoDeployDir.getAbsolutePath() + File.separator + fileName;
                this.removeDeployLogs(fileName);
                this.writeLog(fileName + UNDEPLOY_FAILURE, ex.toString());
            }
            return false;
        }
    }

    public void performAutoReinstall() throws IOException {
        File updatedFile;
        while ((updatedFile = this.pollAutoDirectory(PollFunction.UPDATED_FILES, this.mAutoInstallDir, this.mInstallTimestampsDir)) != null) {
            String fileName = updatedFile.getName();
            File timeStamp = new File(this.mInstallTimestampsDir, fileName);
            if (this.doUninstall(timeStamp)) {
                this.doInstall(updatedFile);
                continue;
            }
            timeStamp.createNewFile();
            timeStamp.setLastModified(updatedFile.lastModified());
        }
    }

    public void performAutoRedeploy() throws IOException {
        File updatedFile;
        while ((updatedFile = this.pollAutoDirectory(PollFunction.UPDATED_FILES, this.mAutoDeployDir, this.mDeployTimestampsDir)) != null) {
            String fileName = updatedFile.getName();
            File timeStamp = new File(this.mDeployTimestampsDir, fileName);
            if (this.doUndeploy(timeStamp)) {
                this.doDeploy(updatedFile);
                continue;
            }
            timeStamp.createNewFile();
            timeStamp.setLastModified(updatedFile.lastModified());
        }
    }

    private boolean parseResultAsSuccess(String aResultString) {
        try {
            Document doc = this.getDocument(new InputSource(new StringReader(aResultString)));
            Text resultText = (Text)XPathAPI.selectNodeList(doc, "jbi-task/jbi-task-result/frmwk-task-result/frmwk-task-result-details/task-result-details/task-result").item(0).getFirstChild();
            return "SUCCESS".equalsIgnoreCase(resultText.getData().trim());
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    private synchronized Document getDocument(InputSource source) throws Exception {
        if (this.mDocBuilder == null) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            this.mDocBuilder = dbf.newDocumentBuilder();
        }
        return this.mDocBuilder.parse(source);
    }

    private String installComponent(String location) {
        boolean installSuccessful;
        ObjectName lifecycleMBean = null;
        String compId = null;
        String errorMsg = "";
        try {
            AutoAdminTask autoAdminTask = this;
            ObjectName installerMBean = (ObjectName)autoAdminTask.mContext.getMBeanServer().invoke(this.mInstallationMBean, "loadNewInstaller", new Object[]{location}, new String[]{"java.lang.String"});
            AutoAdminTask autoAdminTask2 = this;
            autoAdminTask2.mContext.getMBeanNames();
            compId = installerMBean.getKeyProperty("ComponentName");
            AutoAdminTask autoAdminTask3 = this;
            lifecycleMBean = (ObjectName)autoAdminTask3.mContext.getMBeanServer().invoke(installerMBean, "install", new Object[0], new String[0]);
            installSuccessful = true;
        }
        catch (Exception ex) {
            installSuccessful = false;
            errorMsg = ex.getMessage();
        }
        try {
            if (compId != null) {
                AutoAdminTask autoAdminTask = this;
                autoAdminTask.mContext.getMBeanServer().invoke(this.mInstallationMBean, "unloadInstaller", new Object[]{compId, !installSuccessful}, new String[]{"java.lang.String", "boolean"});
            }
            if (installSuccessful && lifecycleMBean != null) {
                AutoAdminTask autoAdminTask = this;
                autoAdminTask.mContext.getMBeanServer().invoke(lifecycleMBean, "start", new Object[0], new String[0]);
            }
        }
        catch (Exception ex) {
            errorMsg = ex.getMessage();
        }
        this.removeInstallLogs(location);
        this.writeLog(location + (installSuccessful ? INSTALL_SUCCESS : INSTALL_FAILURE), errorMsg);
        return compId;
    }

    private void uninstallComponent(String componentName) throws Exception {
        AutoAdminTask autoAdminTask = this;
        AutoAdminTask autoAdminTask2 = this;
        ObjectName adminMBean = autoAdminTask.mContext.getMBeanNames().getSystemServiceMBeanName(MBeanNames.ServiceName.AdminService, MBeanNames.ServiceType.Admin, autoAdminTask2.mContext.getEnvironmentContext().getPlatformContext().getInstanceName());
        AutoAdminTask autoAdminTask3 = this;
        ObjectName lifecycleMBean = (ObjectName)autoAdminTask3.mContext.getMBeanServer().invoke(adminMBean, "getComponentByName", new Object[]{componentName}, new String[]{"java.lang.String"});
        if (lifecycleMBean == null) {
            this.mLogger.finer("No need to autouninstall component " + componentName + ", as it has already been uninstalled.");
            return;
        }
        AutoAdminTask autoAdminTask4 = this;
        autoAdminTask4.mContext.getMBeanServer().invoke(lifecycleMBean, "shutDown", new Object[0], new String[0]);
        AutoAdminTask autoAdminTask5 = this;
        ObjectName installerMBean = (ObjectName)autoAdminTask5.mContext.getMBeanServer().invoke(this.mInstallationMBean, "loadInstaller", new Object[]{componentName}, new String[]{"java.lang.String"});
        AutoAdminTask autoAdminTask6 = this;
        lifecycleMBean = (ObjectName)autoAdminTask6.mContext.getMBeanServer().invoke(installerMBean, "uninstall", new Object[0], new String[0]);
        AutoAdminTask autoAdminTask7 = this;
        autoAdminTask7.mContext.getMBeanServer().invoke(this.mInstallationMBean, "unloadInstaller", new Object[]{componentName, true}, new String[]{"java.lang.String", "boolean"});
    }

    private boolean undeployServiceAssembly(String saName) throws Exception {
        String results = null;
        String state = "not found";
        boolean deployed = this.getRegistry().getGenericQuery().isServiceAssemblyDeployed(saName);
        if (!deployed) {
            return true;
        }
        try {
            AutoAdminTask autoAdminTask = this;
            state = (String)autoAdminTask.mContext.getMBeanServer().invoke(this.mDeploymentMBean, "getState", new Object[]{saName}, new String[]{"java.lang.String"});
        }
        catch (Exception e) {
            this.mLogger.finer("getState(" + saName + ") threw " + e + ".");
            return true;
        }
        if (state.equalsIgnoreCase("Started") || state.equalsIgnoreCase("Stopped")) {
            AutoAdminTask autoAdminTask = this;
            autoAdminTask.mContext.getMBeanServer().invoke(this.mDeploymentMBean, "shutDown", new Object[]{saName}, new String[]{"java.lang.String"});
        }
        AutoAdminTask autoAdminTask = this;
        results = (String)autoAdminTask.mContext.getMBeanServer().invoke(this.mDeploymentMBean, "undeploy", new Object[]{saName}, new String[]{"java.lang.String"});
        return this.parseResultAsSuccess(results);
    }

    private String installSharedLibrary(String location) {
        String slId = null;
        try {
            AutoAdminTask autoAdminTask = this;
            slId = (String)autoAdminTask.mContext.getMBeanServer().invoke(this.mInstallationMBean, "installSharedLibrary", new Object[]{location}, new String[]{"java.lang.String"});
            this.removeInstallLogs(location);
            this.writeLog(location + INSTALL_SUCCESS, "");
        }
        catch (Exception ex) {
            this.removeInstallLogs(location);
            this.writeLog(location + INSTALL_FAILURE, ex.getMessage());
        }
        return slId;
    }

    private void uninstallSharedLibrary(String slName) throws Exception {
        boolean installed = this.getRegistry().getGenericQuery().isSharedLibraryInstalled(slName);
        if (installed) {
            AutoAdminTask autoAdminTask = this;
            autoAdminTask.mContext.getMBeanServer().invoke(this.mInstallationMBean, "uninstallSharedLibrary", new Object[]{slName}, new String[]{"java.lang.String"});
        }
    }

    private void deployServiceAssembly(String saName, String location) {
        boolean deploySuccessful;
        String result;
        try {
            AutoAdminTask autoAdminTask = this;
            result = (String)autoAdminTask.mContext.getMBeanServer().invoke(this.mDeploymentMBean, "deploy", new Object[]{location}, new String[]{"java.lang.String"});
            deploySuccessful = this.parseResultAsSuccess(result);
        }
        catch (Exception ex) {
            deploySuccessful = false;
            result = ex.getMessage();
        }
        if (deploySuccessful) {
            try {
                AutoAdminTask autoAdminTask = this;
                result = (String)autoAdminTask.mContext.getMBeanServer().invoke(this.mDeploymentMBean, "start", new Object[]{saName}, new String[]{"java.lang.String"});
            }
            catch (Exception ex) {
                result = ex.getMessage();
            }
        }
        this.removeDeployLogs(location);
        this.writeLog(location + (deploySuccessful ? DEPLOY_SUCCESS : DEPLOY_FAILURE), result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLog(String path, String message) {
        FileOutputStream fos = null;
        JBIManagementMessage prettyMessage = JBIManagementMessage.createJBIManagementMessage(message);
        if (prettyMessage != null) {
            message = prettyMessage.getMessage();
        }
        try {
            fos = new FileOutputStream(path);
            fos.write(message.getBytes());
            fos.flush();
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    synchronized File pollAutoDirectory(PollFunction queryType, File topLevelDir, File statusDir) {
        File candidate;
        block4: {
            block6: {
                block5: {
                    candidate = null;
                    if (queryType != PollFunction.NEW_FILES) break block5;
                    if (topLevelDir == null || !topLevelDir.isDirectory()) break block4;
                    this.mLogger.finest("pollAutoDirectory(new) called on " + topLevelDir);
                    for (File archive : topLevelDir.listFiles()) {
                        File timeStamp;
                        if (!archive.isFile()) continue;
                        String fileName = archive.getName();
                        this.mLogger.finest("pollAutoDirectory(new) Found file: " + fileName);
                        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
                        this.mLogger.finest("pollAutoDirectory(new): File type of the above is: " + fileType);
                        if (fileType.indexOf("_") != -1 || (timeStamp = new File(statusDir, fileName)).exists()) continue;
                        this.mLogger.finer("pollAutoDirectory(new): Ready to handle " + fileName);
                        candidate = archive;
                        break block4;
                    }
                    break block4;
                }
                if (queryType != PollFunction.DELETED_FILES) break block6;
                if (statusDir == null || !statusDir.isDirectory()) break block4;
                this.mLogger.finest("pollAutoDirectory(deleted) called on " + statusDir);
                for (File archive : statusDir.listFiles()) {
                    File topFile;
                    if (!archive.isFile()) continue;
                    String fileName = archive.getName();
                    this.mLogger.finest("pollAutoDirectory(deleted) Found file: " + fileName);
                    String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
                    this.mLogger.finest("pollAutoDirectory(deleted): File type of the above is: " + fileType);
                    if (fileType.indexOf("_") != -1 || fileType.indexOf(DELIMITER) != -1 || (topFile = new File(topLevelDir, fileName)).exists()) continue;
                    this.mLogger.finer("pollAutoDirectory(deleted): Ready to handle " + fileName);
                    candidate = archive;
                    break block4;
                }
                break block4;
            }
            if (queryType == PollFunction.UPDATED_FILES && topLevelDir != null && topLevelDir.isDirectory()) {
                this.mLogger.finest("pollAutoDirectory(updated) called on " + topLevelDir);
                for (File archive : topLevelDir.listFiles()) {
                    File timeStamp;
                    if (!archive.isFile()) continue;
                    String fileName = archive.getName();
                    this.mLogger.finest("pollAutoDirectory(updated) Found file: " + fileName);
                    String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
                    this.mLogger.finest("pollAutoDirectory(updated): File type of the above is: " + fileType);
                    if (fileType.indexOf("_") != -1 || !(timeStamp = new File(statusDir, fileName)).exists() || archive.lastModified() <= timeStamp.lastModified()) continue;
                    this.mLogger.finer("pollAutoDirectory(updated): Ready to handle " + fileName);
                    candidate = archive;
                    break;
                }
            }
        }
        return candidate;
    }

    boolean checkConfigPermission(ObjectName aConfigSvcName, String aPermissionName) {
        try {
            AutoAdminTask autoAdminTask = this;
            Object attr = autoAdminTask.mContext.getMBeanServer().getAttribute(aConfigSvcName, aPermissionName);
            return (Boolean)attr;
        }
        catch (Exception e) {
            this.mLogger.finer("checkConfigPermission(" + aConfigSvcName + ", " + aPermissionName + ") returned " + e + ".  Returning default 'false' value.");
            return false;
        }
    }

    String getConfigAttribute(ObjectName aConfigSvcName, String anAttributeName) {
        try {
            AutoAdminTask autoAdminTask = this;
            Object attr = autoAdminTask.mContext.getMBeanServer().getAttribute(aConfigSvcName, anAttributeName);
            return (String)attr;
        }
        catch (Exception e) {
            this.mLogger.finer("checkConfigPermission(" + aConfigSvcName + ", " + anAttributeName + ") returned " + e + ".  Returning default 'null' value.");
            return null;
        }
    }

    void initDirectories(boolean isAutoInstallEnabled, boolean isAutoDeployEnabled) {
        if (isAutoInstallEnabled && null != this.mAutoInstallDirName) {
            if (this.mAutoInstallDirName.startsWith(File.separator) || ":".equals(this.mAutoInstallDirName.substring(1, 2))) {
                this.mAutoInstallDir = new File(this.mAutoInstallDirName);
            } else {
                AutoAdminTask autoAdminTask = this;
                this.mAutoInstallDir = new File(autoAdminTask.mContext.getJbiInstallRoot(), this.mAutoInstallDirName);
            }
            this.mInstallTimestampsDir = new File(this.mAutoInstallDir, INSTALL_STATUS_DIR);
            if (!this.mInstallTimestampsDir.exists()) {
                this.mLogger.fine("initDirectories() creating " + this.mInstallTimestampsDir);
                this.mInstallTimestampsDir.mkdirs();
            }
        }
        if (isAutoDeployEnabled && null != this.mAutoDeployDirName) {
            if (this.mAutoDeployDirName.startsWith(File.separator) || ":".equals(this.mAutoDeployDirName.substring(1, 2))) {
                this.mAutoDeployDir = new File(this.mAutoDeployDirName);
            } else {
                AutoAdminTask autoAdminTask = this;
                this.mAutoDeployDir = new File(autoAdminTask.mContext.getJbiInstallRoot(), this.mAutoDeployDirName);
            }
            this.mDeployTimestampsDir = new File(this.mAutoDeployDir, DEPLOY_STATUS_DIR);
            if (!this.mDeployTimestampsDir.exists()) {
                this.mLogger.fine("initDirectories() creating " + this.mDeployTimestampsDir);
                this.mDeployTimestampsDir.mkdirs();
            }
        }
    }

    private String suffix(String anInputString, String aPrefix) {
        String[] splitNames = anInputString.split(aPrefix, 2);
        try {
            return splitNames[1];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            this.mLogger.finer("suffix(" + anInputString + ", " + aPrefix + ") threw " + aioobe);
            return null;
        }
    }

    private void removeInstallLogs(String location) {
        try {
            File f1 = new File(location + INSTALL_SUCCESS);
            File f2 = new File(location + INSTALL_FAILURE);
            File f3 = new File(location + UNINSTALL_SUCCESS);
            File f4 = new File(location + UNINSTALL_FAILURE);
            f1.delete();
            f2.delete();
            f3.delete();
            f4.delete();
        }
        catch (Exception e) {
            this.mLogger.finer("removeInstallLogs(" + location + ") threw " + e);
        }
    }

    private void removeDeployLogs(String location) {
        try {
            File f1 = new File(location + DEPLOY_SUCCESS);
            File f2 = new File(location + DEPLOY_FAILURE);
            File f3 = new File(location + UNDEPLOY_SUCCESS);
            File f4 = new File(location + UNDEPLOY_FAILURE);
            f1.delete();
            f2.delete();
            f3.delete();
            f4.delete();
        }
        catch (Exception e) {
            this.mLogger.finer("removeDeployLogs(" + location + ") threw " + e);
        }
    }

    private Registry getRegistry() {
        AutoAdminTask autoAdminTask = this;
        return (Registry)autoAdminTask.mContext.getEnvironmentContext().getRegistry();
    }

    private class NamedFileFinder
    implements FilenameFilter {
        String prefix = null;

        NamedFileFinder(String p) {
            this.prefix = p;
        }

        public boolean accept(File dir, String name) {
            return name.startsWith(this.prefix + AutoAdminTask.DELIMITER);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PollFunction {
        NEW_FILES,
        DELETED_FILES,
        UPDATED_FILES;

    }
}

