/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.messaging.util;

import com.sun.jbi.messaging.ExchangePattern;
import com.sun.jbi.messaging.util.Translator;
import com.sun.jbi.wsdl2.Description;
import com.sun.jbi.wsdl2.Interface;
import com.sun.jbi.wsdl2.InterfaceOperation;
import com.sun.jbi.wsdl2.Service;
import com.sun.jbi.wsdl2.WsdlException;
import com.sun.jbi.wsdl2.WsdlReader;
import com.sun.jbi.wsdl2.impl.WsdlFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class WSDLHelper {
    private static final String WSDL_11 = "http://schemas.xmlsoap.org/wsdl/";
    private static final String WSDL_20 = "http://www.w3.org/2005/05/wsdl";
    private static final String TARGET_NS = "targetNamespace";
    private static final String BINDING = "binding";
    private static final String BINDING_TYPE = "type";
    private static final String PORTTYPE = "portType";
    private static final String SERVICE = "service";
    private static final String PORT = "port";
    private static final String NAME = "name";
    private static final String OPERATION = "operation";
    private static final String IN_MSG = "input";
    private static final String OUT_MSG = "output";
    private static WsdlFactory mFactory;
    private static WsdlReader mReader;
    private static Logger mLog;

    public static HashMap getOperationsForService(Document serviceDesc, QName serviceName) throws MessagingException {
        String version = WSDLHelper.getWSDLVersion(serviceDesc);
        HashMap operations = version.equals(WSDL_11) ? WSDLHelper.getOperationsForService11(serviceDesc, serviceName) : WSDLHelper.getOperationsForService20(serviceDesc, serviceName);
        mLog.fine(Translator.translate("OPERATIONS_FOUND_FOR_SERVICE", new Object[]{operations.size() + "", serviceName}));
        return operations;
    }

    public static QName[] getInterfacesForService(Document serviceDesc, QName serviceName) throws MessagingException {
        String version = WSDLHelper.getWSDLVersion(serviceDesc);
        QName[] interfaces = version.equals(WSDL_11) ? WSDLHelper.getInterfacesForService11(serviceDesc, serviceName) : WSDLHelper.getInterfacesForService20(serviceDesc, serviceName);
        mLog.fine(Translator.translate("INTERFACES_FOUND_FOR_SERVICE", new Object[]{interfaces.length + "", serviceName}));
        return interfaces;
    }

    private static HashMap getOperationsForService11(Document serviceDesc, QName serviceName) throws MessagingException {
        HashMap<String, String> operations = new HashMap<String, String>();
        Element definitions = serviceDesc.getDocumentElement();
        String namespace = WSDLHelper.getTargetNamespace(serviceDesc);
        if (namespace != null && serviceName.getNamespaceURI().equals(namespace)) {
            ArrayList portTypes = WSDLHelper.getPortTypes(definitions, serviceName.getLocalPart());
            for (int i = 0; i < portTypes.size(); ++i) {
                Element portType = (Element)portTypes.get(i);
                NodeList opList = portType.getElementsByTagNameNS(WSDL_11, OPERATION);
                for (int j = 0; j < opList.getLength(); ++j) {
                    Element op = (Element)opList.item(j);
                    QName name = new QName(namespace, op.getAttribute(NAME));
                    NodeList ins = op.getElementsByTagNameNS(WSDL_11, IN_MSG);
                    NodeList outs = op.getElementsByTagNameNS(WSDL_11, OUT_MSG);
                    if (ins.getLength() <= 0) continue;
                    if (outs.getLength() > 0) {
                        operations.put(name.toString(), ExchangePattern.IN_OUT.toString());
                        continue;
                    }
                    operations.put(name.toString(), ExchangePattern.IN_ONLY.toString());
                }
            }
        } else {
            mLog.info(Translator.translate("WSDL_NS_MISMATCH", new Object[]{serviceName}));
        }
        return operations;
    }

    private static HashMap getOperationsForService20(Document serviceDesc, QName serviceName) throws MessagingException {
        HashMap<String, String> operations = new HashMap<String, String>();
        Description defs = WSDLHelper.readWSDL(serviceDesc, serviceName);
        for (int i = 0; i < defs.getServicesLength(); ++i) {
            Service service = defs.getService(i);
            if (!service.getName().equals(serviceName.getLocalPart())) continue;
            Interface interfaze = service.getInterface();
            InterfaceOperation[] iops = interfaze.getExtendedOperations();
            for (int j = 0; j < iops.length; ++j) {
                operations.put(iops[j].getQualifiedName().toString(), iops[j].getPattern());
            }
            break;
        }
        return operations;
    }

    private static QName[] getInterfacesForService11(Document serviceDesc, QName serviceName) throws MessagingException {
        QName[] interfaces;
        Element definitions = serviceDesc.getDocumentElement();
        String namespace = WSDLHelper.getTargetNamespace(serviceDesc);
        if (namespace != null && serviceName.getNamespaceURI().equals(namespace)) {
            ArrayList portTypes = WSDLHelper.getPortTypes(definitions, serviceName.getLocalPart());
            interfaces = new QName[portTypes.size()];
            for (int i = 0; i < portTypes.size(); ++i) {
                Element portType = (Element)portTypes.get(i);
                String name = portType.getAttribute(NAME);
                interfaces[i] = new QName(namespace, name);
            }
        } else {
            interfaces = new QName[]{};
            mLog.info(Translator.translate("WSDL_NS_MISMATCH", new Object[]{serviceName}));
        }
        return interfaces;
    }

    private static QName[] getInterfacesForService20(Document serviceDesc, QName serviceName) throws MessagingException {
        ArrayList<QName> interfaces = new ArrayList<QName>();
        Description defs = WSDLHelper.readWSDL(serviceDesc, serviceName);
        for (int i = 0; i < defs.getServicesLength(); ++i) {
            Service service = defs.getService(i);
            if (!service.getName().equals(serviceName.getLocalPart())) continue;
            Interface impl = service.getInterface();
            Interface[] extended = impl.getExtendedInterfaces();
            interfaces.add(impl.getQName());
            for (int j = 0; j < extended.length; ++j) {
                interfaces.add(extended[j].getQName());
            }
            break;
        }
        return interfaces.toArray(new QName[0]);
    }

    private static String getWSDLVersion(Document description) {
        return description.getDocumentElement().getNamespaceURI();
    }

    private static String getTargetNamespace(Document description) {
        String namespace = null;
        Element definitions = description.getDocumentElement();
        namespace = definitions.getAttribute(TARGET_NS);
        return namespace;
    }

    private static ArrayList getPortTypes(Element definitions, String serviceName) {
        String name;
        int i;
        ArrayList<Element> result = new ArrayList<Element>();
        ArrayList<String> bindingNames = new ArrayList<String>();
        ArrayList<String> portTypeNames = new ArrayList<String>();
        NodeList services = definitions.getElementsByTagNameNS(WSDL_11, SERVICE);
        for (i = 0; i < services.getLength(); ++i) {
            Element service = (Element)services.item(i);
            if (!service.getAttribute(NAME).equals(serviceName)) continue;
            mLog.finer(Translator.translate("WSDL_11_SERVICE_FOUND", new Object[]{serviceName}));
            NodeList ports = service.getElementsByTagNameNS(WSDL_11, PORT);
            for (int j = 0; j < ports.getLength(); ++j) {
                Element port = (Element)ports.item(j);
                bindingNames.add(WSDLHelper.getLocalName(port.getAttribute(BINDING)));
            }
            mLog.finer(Translator.translate("WSDL_11_BINDINGS_FOUND", new Object[]{bindingNames.size() + "", serviceName}));
            break;
        }
        NodeList bindings = definitions.getElementsByTagNameNS(WSDL_11, BINDING);
        for (i = 0; i < bindings.getLength(); ++i) {
            Element binding = (Element)bindings.item(i);
            name = binding.getAttribute(NAME);
            if (!bindingNames.contains(name)) continue;
            portTypeNames.add(WSDLHelper.getLocalName(binding.getAttribute(BINDING_TYPE)));
        }
        mLog.finer(Translator.translate("WSDL_11_PORT_TYPES_FOUND", new Object[]{portTypeNames.size() + "", serviceName}));
        NodeList portTypes = definitions.getElementsByTagNameNS(WSDL_11, PORTTYPE);
        for (i = 0; i < portTypes.getLength(); ++i) {
            Element portType = (Element)portTypes.item(i);
            name = portType.getAttribute(NAME);
            if (!portTypeNames.contains(name)) continue;
            result.add(portType);
        }
        return result;
    }

    private static String getLocalName(String qname) {
        if (qname.indexOf(58) != -1) {
            qname = qname.split(":")[1];
        }
        return qname;
    }

    private static Description readWSDL(Document description, QName serviceName) throws MessagingException {
        try {
            return mReader.readDescription(null, description);
        }
        catch (IOException ioEx) {
            throw new MessagingException(Translator.translate("WSDL_IMPORT_ERROR", new Object[]{serviceName.toString(), ioEx.toString()}));
        }
        catch (WsdlException wEx) {
            throw new MessagingException(Translator.translate("WSDL_IMPORT_ERROR", new Object[]{serviceName.toString(), wEx.toString()}));
        }
    }

    static {
        mLog = Logger.getLogger("com.sun.jbi.messaging.util");
        mFactory = new WsdlFactory();
        mReader = mFactory.newWsdlReader();
    }
}

