/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.client;

import com.sun.jbi.ui.client.JMXConnection;
import com.sun.jbi.ui.client.JMXConnectionFactory;
import com.sun.jbi.ui.client.JMXConnectionProperties;
import com.sun.jbi.ui.common.I18NBundle;
import com.sun.jbi.ui.common.JBIRemoteException;
import com.sun.jbi.ui.common.JBIResultXmlBuilder;
import com.sun.jbi.ui.common.JMXConnectionException;
import java.io.IOException;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

public abstract class JMXConnectionImpl
implements JMXConnection {
    private static I18NBundle sI18NBundle = null;
    protected MBeanServerConnection mMBeanServerConnection = null;

    protected static I18NBundle getI18NBundle() {
        if (sI18NBundle == null) {
            sI18NBundle = new I18NBundle("com.sun.jbi.ui.client");
        }
        return sI18NBundle;
    }

    public MBeanServerConnection getMBeanServerConnection() throws IllegalStateException {
        if (this.mMBeanServerConnection == null) {
            throw new IllegalStateException(JBIResultXmlBuilder.createFailedJbiResultXml(JMXConnectionImpl.getI18NBundle(), "jbi.ui.jmx.connection.not.open", null));
        }
        return this.mMBeanServerConnection;
    }

    public Object invokeMBeanOperation(ObjectName name, String operationName, Object[] params, String[] signature) throws JMXConnectionException, JBIRemoteException {
        try {
            Object resultObject = this.getMBeanServerConnection().invoke(name, operationName, params, signature);
            return resultObject;
        }
        catch (InstanceNotFoundException notFoundEx) {
            throw new JMXConnectionException(JBIResultXmlBuilder.createJbiResultXml(JMXConnectionImpl.getI18NBundle(), "jbi.ui.jmx.invoke.error", null, notFoundEx), null);
        }
        catch (ReflectionException rEx) {
            throw new JMXConnectionException(JBIResultXmlBuilder.createJbiResultXml(JMXConnectionImpl.getI18NBundle(), "jbi.ui.jmx.invoke.error", null, rEx), null);
        }
        catch (IOException ioEx) {
            throw new JMXConnectionException(JBIResultXmlBuilder.createJbiResultXml(JMXConnectionImpl.getI18NBundle(), "jbi.ui.jmx.invoke.error", null, ioEx), null);
        }
        catch (MBeanException mbeanEx) {
            throw JBIRemoteException.filterJmxExceptions(mbeanEx);
        }
        catch (RuntimeMBeanException rtEx) {
            throw JBIRemoteException.filterJmxExceptions(rtEx);
        }
        catch (RuntimeOperationsException rtOpEx) {
            throw JBIRemoteException.filterJmxExceptions(rtOpEx);
        }
        catch (Exception ex) {
            throw new JBIRemoteException(JBIResultXmlBuilder.createJbiResultXml(JMXConnectionImpl.getI18NBundle(), "jbi.ui.jmx.unknown.error", null, ex), null);
        }
    }

    public void setMBeanAttribute(ObjectName name, Attribute attribute) throws JMXConnectionException, JBIRemoteException {
        try {
            this.getMBeanServerConnection().setAttribute(name, attribute);
        }
        catch (Exception allEx) {
            throw JBIRemoteException.filterJmxExceptions(allEx);
        }
    }

    public Object getMBeanAttribute(ObjectName name, String attribute) throws JMXConnectionException, JBIRemoteException {
        try {
            Object resultObject = this.getMBeanServerConnection().getAttribute(name, attribute);
            return resultObject;
        }
        catch (Exception allEx) {
            throw JBIRemoteException.filterJmxExceptions(allEx);
        }
    }

    public static JMXConnection createJmxConnection(String host, String port, String username, String password) throws JMXConnectionException {
        Properties props = JMXConnectionProperties.getJMXConnectionPropertyMap(null, host, port, username, password);
        return JMXConnectionImpl.createJmxConnection(props);
    }

    public static JMXConnection createJmxConnection(Properties connProps) throws JMXConnectionException {
        return JMXConnectionFactory.newInstance("").getConnection(connProps);
    }
}

