/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.common;

import com.sun.jbi.ui.common.I18NBundle;
import com.sun.jbi.ui.common.ToolsLogManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Util {
    private static I18NBundle sI18NBundle = null;

    public static I18NBundle getCommonI18NBundle() {
        if (sI18NBundle == null) {
            sI18NBundle = new I18NBundle("com.sun.jbi.ui.common");
        }
        return sI18NBundle;
    }

    public static void logDebug(String msg) {
        ToolsLogManager.getCommonLogger().log(Level.FINER, msg);
    }

    public static void logDebug(Logger logger, Exception ex) {
        logger.log(Level.FINER, ex.getMessage(), ex);
    }

    public static void logDebug(Exception ex) {
        Util.logDebug(ToolsLogManager.getCommonLogger(), ex);
    }

    public static Object newInstance(String type, String arg) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class objClass = null;
        Object instance = null;
        objClass = type.equals("boolean") ? Boolean.class : (type.equals("byte") ? Byte.class : (type.equals("char") ? Character.class : (type.equals("short") ? Short.class : (type.equals("int") ? Integer.class : (type.equals("long") ? Long.class : (type.equals("float") ? Float.class : (type.equals("double") ? Double.class : (type.equals("void") ? Void.class : Class.forName(type)))))))));
        Class[] argClass = new Class[]{String.class};
        Constructor objConstructor = objClass.getConstructor(argClass);
        Object[] argValue = new String[]{arg};
        instance = objConstructor.newInstance(argValue);
        return instance;
    }

    public static boolean isLocalHost(String host) throws UnknownHostException {
        String localhostName = "localhost";
        String loopbackIP = "127.0.0.1";
        String remoteHost = null;
        if (host != null) {
            remoteHost = host.trim().toLowerCase();
        }
        Util.logDebug("Checking for Remote HOST " + remoteHost);
        if (remoteHost == null || remoteHost.length() == 0 || remoteHost.equalsIgnoreCase(localhostName) || remoteHost.equalsIgnoreCase(loopbackIP)) {
            return true;
        }
        InetAddress localInetAddr = InetAddress.getLocalHost();
        String localHostIP = localInetAddr.getHostAddress();
        InetAddress[] remoteInetAddrs = InetAddress.getAllByName(remoteHost);
        for (int i = 0; i < remoteInetAddrs.length; ++i) {
            String remoteHostIP = remoteInetAddrs[i].getHostAddress();
            if (!localHostIP.equalsIgnoreCase(remoteHostIP)) continue;
            return true;
        }
        return false;
    }

    public static String getHostName(String aHostName) throws UnknownHostException {
        InetAddress ia = null;
        ia = aHostName.equalsIgnoreCase("localhost") || aHostName.equals("") ? InetAddress.getLocalHost() : InetAddress.getByName(aHostName);
        String hostName = ia.getHostName();
        String hostAddress = ia.getHostAddress();
        String returnStr = hostName + "/" + hostAddress;
        return returnStr;
    }
}

